/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.ops;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpService;
import net.imagej.ops.OpUtils;
import net.imagej.ui.swing.ops.OpTreeTableModel;
import net.imagej.ui.swing.ops.OpTreeTableNode;
import net.imglib2.img.Img;
import net.miginfocom.swing.MigLayout;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.scijava.Context;
import org.scijava.command.CommandInfo;
import org.scijava.log.LogService;
import org.scijava.module.ModuleItem;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.script.ScriptService;
import org.scijava.thread.ThreadService;

public class OpFinder
extends JFrame
implements DocumentListener,
ActionListener {
    public static final int DETAILS_WINDOW_WIDTH = 400;
    public static final int MAIN_WINDOW_HEIGHT = 700;
    public static final int COLUMN_MARGIN = 5;
    public static final int HIDE_COOLDOWN = 1500;
    public static final String WINDOW_HEIGHT = "op.viewer.height";
    public static final String WINDOW_WIDTH = "op.viewer.width";
    public static final String NO_NAMESPACE = "(global)";
    public static final String BASE_JAVADOC_URL = "http://javadoc.imagej.net/ImageJ/";
    public static final String SIMPLE_KEY = "net.imagej.ui.swing.ops.opfinder.simple";
    public static final String IMG_REGEX = "ArrayImg|PlanarImg|RandomAccessibleInterval|IterableInterval|Img|Histogram1d";
    public static final String IMGPLUS_REGEX = "ImgPlus|Dataset";
    public static final String NUMBER_REGEX = "int|short|long|double|float|byte|RealType";
    private boolean simple = true;
    private ModeButton modeButton;
    private JLabel searchLabel;
    private boolean autoToggle = true;
    private Set<Class<?>> simpleFilterClasses;
    private FilterRunner lastFilter;
    private HTMLFetcher lastHTMLReq;
    private int[] widths;
    private JTextField searchField;
    private JXTreeTable treeTable;
    private JLabel successLabel = null;
    private JEditorPane textPane;
    private JScrollPane detailsPane;
    private JButton toggleDetailsButton;
    private final JPanel mainPane;
    private final JSplitPane splitPane;
    private JProgressBar progressBar;
    private OpTreeTableModel advModel;
    private OpTreeTableModel smplModel;
    private ImageIcon opFail;
    private ImageIcon opSuccess;
    private ImageIcon expandDetails;
    private ImageIcon hideDetails;
    private ImageIcon useView;
    private ImageIcon devView;
    private Set<TreePath> advExpandedPaths;
    private Set<TreePath> smplExpandedPaths;
    private Map<String, String> elementsMap;
    private Map<Trie, OpTreeTableNode> advTries;
    private Map<Trie, OpTreeTableNode> smplTries;
    private Timer successTimer;
    private Timer progressTimer;
    @Parameter
    private OpService opService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private LogService logService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ThreadService threadService;

    public OpFinder(Context context) {
        super("Op Finder");
        context.inject((Object)this);
        this.initialize();
        this.setDefaultCloseOperation(2);
        this.mainPane = new JPanel((LayoutManager)new MigLayout("", "[][][][][][][grow, right]", "[grow]"));
        this.buildTopPanel();
        this.buildTreeTable();
        this.buildDetailsPane();
        this.buildBottomPanel();
        this.splitPane = new JSplitPane(1, this.mainPane, null);
        this.add(this.splitPane);
        this.setState(this.prefService.getBoolean(SIMPLE_KEY, true));
    }

    public void setState(boolean toSimple) {
        if (toSimple != this.simple) {
            this.simple = toSimple;
            this.prefService.put(SIMPLE_KEY, this.simple);
            this.modeButton.setLabels(toSimple);
            if (this.treeTable != null) {
                this.cacheExpandedPaths(!toSimple);
                this.treeTable.setTreeTableModel((TreeTableModel)(toSimple ? this.smplModel : this.advModel));
                this.restoreExpandedPaths(toSimple, false);
            }
            if (this.autoToggle) {
                this.toggleDetails();
            }
            this.filterOps(this.searchField.getDocument());
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.searchField.requestFocusInWindow();
    }

    @Override
    public void pack() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                super.pack();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OpFinder.super.pack();
                    }
                });
            }
        }
        catch (Exception ie) {
            this.logService.error((Throwable)ie);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.toggleDetailsButton) {
            this.autoToggle = false;
            this.toggleDetails();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.filterOps(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.filterOps(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.filterOps(e);
    }

    private void initialize() {
        this.advExpandedPaths = new HashSet<TreePath>();
        this.smplExpandedPaths = new HashSet<TreePath>();
        this.elementsMap = new HashMap<String, String>();
        this.advTries = new HashMap<Trie, OpTreeTableNode>();
        this.smplTries = new HashMap<Trie, OpTreeTableNode>();
        this.advModel = new OpTreeTableModel(false);
        this.smplModel = new OpTreeTableModel(true);
        this.widths = new int[this.advModel.getColumnCount()];
        this.buildSimpleInputs();
        this.buildTimers();
    }

    private void buildTimers() {
        this.successTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpFinder.this.successLabel.setVisible(false);
            }
        });
        this.progressTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpFinder.this.progressBar.setVisible(false);
            }
        });
    }

    private void buildTreeTable() {
        this.createNodes();
        this.treeTable = new JXTreeTable((TreeTableModel)(this.simple ? this.smplModel : this.advModel)){

            public String getToolTipText(MouseEvent e) {
                String tip = "";
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                try {
                    OpTreeTableNode n = OpFinder.this.getNodeAtRow(rowIndex);
                    if (n != null) {
                        switch (colIndex) {
                            case 0: {
                                String name = rowIndex == 0 ? "all available ops" : n.getName();
                                if (rowIndex > 0 && n.getCodeCall().isEmpty()) {
                                    OpTreeTableNode firstChild = n.getChildren().get(0);
                                    name = firstChild != null && firstChild.getChildren().isEmpty() ? name + " op" : name + " namespace";
                                }
                                return name;
                            }
                        }
                        return (String)OpFinder.this.treeTable.getValueAt(rowIndex, colIndex);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return "";
            }
        };
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int rowIndex = OpFinder.this.treeTable.rowAtPoint(p);
                    int colIndex = OpFinder.this.treeTable.columnAtPoint(p);
                    OpTreeTableNode n = OpFinder.this.getNodeAtRow(rowIndex);
                    if (n != null) {
                        String text = OpFinder.this.treeTable.getValueAt(rowIndex, colIndex).toString();
                        if (text.isEmpty()) {
                            OpFinder.this.selectFail();
                        } else {
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(new StringSelection(text), null);
                            OpFinder.this.copyPass();
                        }
                        OpFinder.this.successTimer.restart();
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent event) {
                String newText;
                OpTreeTableNode n = OpFinder.this.getNodeAtRow(OpFinder.this.treeTable.getSelectedRow());
                if (n != null && OpFinder.this.detailsPane.isVisible() && !(newText = n.getReferenceClass()).isEmpty()) {
                    if ((newText = newText.replaceAll("\\.", "/")).contains("$")) {
                        String suffix = newText.substring(newText.lastIndexOf("$"));
                        newText = newText.replace(suffix, "%2E" + suffix.substring(1));
                    }
                    String requestedClass = newText;
                    StringBuilder sb = new StringBuilder();
                    sb.append(OpFinder.BASE_JAVADOC_URL);
                    sb.append(newText);
                    sb.append(".html");
                    String url = sb.toString();
                    Map map = OpFinder.this.elementsMap;
                    synchronized (map) {
                        if (OpFinder.this.elementsMap.containsKey(url)) {
                            OpFinder.this.textPane.setText((String)OpFinder.this.elementsMap.get(url));
                            OpFinder.this.scrollToTop();
                        } else {
                            if (OpFinder.this.lastHTMLReq != null && !OpFinder.this.lastHTMLReq.isDone()) {
                                OpFinder.this.lastHTMLReq.stop();
                            }
                            OpFinder.this.lastHTMLReq = new HTMLFetcher(sb, url, requestedClass);
                            OpFinder.this.threadService.run((Runnable)OpFinder.this.lastHTMLReq);
                        }
                    }
                }
            }
        });
        this.treeTable.setColumnMargin(5);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.expandRow(0);
        int preferredWidth = this.getPreferredMainWidth();
        this.mainPane.add((Component)new JScrollPane((Component)this.treeTable, 20, 30), "span, wrap, grow, w " + preferredWidth / 2 + ":" + preferredWidth + ", h " + 700);
    }

    private void scrollToTop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpFinder.this.detailsPane.getVerticalScrollBar().setValue(0);
                OpFinder.this.detailsPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    private int getPreferredMainWidth() {
        int preferredWidth = 0;
        for (int i : this.widths) {
            preferredWidth += i + 5;
        }
        return preferredWidth;
    }

    private void buildTopPanel() {
        int searchWidth = 160;
        this.searchField = new JTextField(160);
        this.searchLabel = new JLabel();
        this.searchLabel.setHorizontalAlignment(4);
        this.mainPane.add((Component)this.searchLabel, "w 145!");
        this.mainPane.add((Component)this.searchField, "w 160!");
        this.useView = new ImageIcon(this.getClass().getResource("/icons/opbrowser/view_use.png"));
        this.devView = new ImageIcon(this.getClass().getResource("/icons/opbrowser/view_dev.png"));
        this.modeButton = new ModeButton();
        JButton runButton = new JButton(new ImageIcon(this.getClass().getResource("/icons/opbrowser/play.png")));
        JButton snippetButton = new JButton(new ImageIcon(this.getClass().getResource("/icons/opbrowser/paperclip.png")));
        JButton wikiButton = new JButton(new ImageIcon(this.getClass().getResource("/icons/opbrowser/globe.png")));
        runButton.setToolTipText("Run the selected Op");
        runButton.addActionListener(new RunButtonListener());
        snippetButton.setToolTipText("<html>Copy the selected cell contents to your clipboard.<br />You can also double-click a cell to copy its contents.</html>");
        snippetButton.addActionListener(new CopyButtonListener());
        wikiButton.setToolTipText("Learn more about ImageJ Ops");
        wikiButton.addActionListener(new WikiButtonListener());
        this.mainPane.add((Component)this.modeButton, "w 145!, h 32!, gapleft 15");
        this.mainPane.add((Component)runButton, "w 32!, h 32!, gapleft 15");
        this.mainPane.add((Component)snippetButton, "w 32!, h 32!");
        this.mainPane.add((Component)wikiButton, "w 32!, h 32!");
        this.opFail = new ImageIcon(this.getClass().getResource("/icons/opbrowser/redx.png"));
        this.opSuccess = new ImageIcon(this.getClass().getResource("/icons/opbrowser/greencheck.png"));
        this.successLabel = new JLabel();
        this.successLabel.setHorizontalTextPosition(2);
        this.successLabel.setHorizontalAlignment(4);
        this.successLabel.setVisible(false);
        this.mainPane.add((Component)this.successLabel, "h 20!, w 155!, wrap");
        this.searchField.getDocument().addDocumentListener(this);
    }

    private void buildDetailsPane() {
        this.textPane = new JEditorPane("text/html", "Select an Op for more information");
        this.textPane.setEditable(false);
        this.detailsPane = new JScrollPane(this.textPane, 20, 30);
        this.detailsPane.setPreferredSize(new Dimension(400, 700));
        this.detailsPane.setVisible(false);
    }

    private void buildBottomPanel() {
        this.progressBar = new JProgressBar(0, 0, 100);
        this.mainPane.add((Component)this.progressBar, "w 100!");
        this.progressBar.setVisible(false);
        this.hideDetails = new ImageIcon(this.getClass().getResource("/icons/opbrowser/arrow_left.png"));
        this.expandDetails = new ImageIcon(this.getClass().getResource("/icons/opbrowser/arrow_right.png"));
        this.toggleDetailsButton = new JButton(this.expandDetails);
        this.toggleDetailsButton.setToolTipText("Show / Hide Details");
        this.toggleDetailsButton.addActionListener(this);
        this.mainPane.add((Component)this.toggleDetailsButton, "span, align right, w 32!, h 32!");
    }

    private void setProgress(int progress) {
        this.progressBar.setVisible(true);
        this.progressBar.setValue(progress);
        if (progress >= this.progressBar.getMaximum() || progress <= this.progressBar.getMinimum()) {
            this.progressTimer.restart();
        } else {
            this.progressTimer.stop();
        }
    }

    private void filterOps(DocumentEvent e) {
        javax.swing.text.Document doc = e.getDocument();
        this.filterOps(doc);
    }

    private void filterOps(javax.swing.text.Document doc) {
        try {
            String text = doc.getText(0, doc.getLength());
            if (this.lastFilter != null) {
                this.lastFilter.stop();
            }
            if (text == null || text.isEmpty()) {
                this.treeTable.setTreeTableModel((TreeTableModel)(this.simple ? this.smplModel : this.advModel));
                this.restoreExpandedPaths(this.simple, true);
            } else {
                this.cacheExpandedPaths(this.simple);
                this.lastFilter = new FilterRunner(text);
                this.threadService.run((Runnable)this.lastFilter);
            }
        }
        catch (BadLocationException exc) {
            this.logService.error((Throwable)exc);
        }
    }

    private void restoreExpandedPaths(boolean isSimple, boolean clearCache) {
        Set<TreePath> paths;
        Set<TreePath> set = paths = isSimple ? this.smplExpandedPaths : this.advExpandedPaths;
        if (paths.isEmpty()) {
            this.treeTable.expandRow(0);
        } else {
            for (TreePath path : paths) {
                this.treeTable.expandPath(path);
            }
        }
        if (clearCache) {
            paths.clear();
        }
    }

    private void cacheExpandedPaths(boolean isSimple) {
        Set<TreePath> paths = isSimple ? this.smplExpandedPaths : this.advExpandedPaths;
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            if (!this.treeTable.isExpanded(i)) continue;
            paths.add(this.treeTable.getPathForRow(i));
        }
    }

    private void toggleDetails() {
        if (this.detailsPane == null) {
            return;
        }
        boolean hide = this.detailsPane.isVisible();
        if (hide) {
            this.detailsPane.setPreferredSize(this.detailsPane.getSize());
            this.splitPane.remove(this.detailsPane);
            this.detailsPane.setVisible(false);
            this.toggleDetailsButton.setIcon(this.expandDetails);
        } else {
            this.detailsPane.setVisible(true);
            this.splitPane.add(this.detailsPane);
            this.toggleDetailsButton.setIcon(this.hideDetails);
        }
        if (this.isVisible()) {
            Component lc = this.splitPane.getLeftComponent();
            lc.setPreferredSize(lc.getSize());
            this.pack();
        }
    }

    private void createNodes() {
        OpTreeTableNode advParent = new OpTreeTableNode("ops", "# @OpService ops", "net.imagej.ops.OpService");
        OpTreeTableNode smplParent = new OpTreeTableNode("ops", "# @OpService ops", "net.imagej.ops.OpService");
        this.advModel.getRoot().add(advParent);
        this.smplModel.getRoot().add(smplParent);
        HashMap<String, OpTreeTableNode> advNamespaces = new HashMap<String, OpTreeTableNode>();
        HashMap<String, OpTreeTableNode> smplNamespaces = new HashMap<String, OpTreeTableNode>();
        HashSet<String> smplOps = new HashSet<String>();
        for (OpInfo info : this.opService.infos()) {
            String opName = this.getName(info.getSimpleName(), info.getName());
            if (opName.isEmpty()) continue;
            String namespacePath = this.getName(info.getNamespace(), NO_NAMESPACE);
            String pathToOp = namespacePath + "." + opName;
            OpTreeTableNode advOpType = this.buildNamespaceHierarchy(advParent, advNamespaces, pathToOp);
            OpTreeTableNode smplOpType = this.buildNamespaceHierarchy(smplParent, smplNamespaces, pathToOp);
            String delegateClass = info.cInfo().getDelegateClassName();
            String simpleName = OpUtils.simpleString((CommandInfo)info.cInfo());
            String codeCall = OpUtils.opCall((CommandInfo)info.cInfo());
            OpTreeTableNode opSignature = new OpTreeTableNode(simpleName, codeCall, delegateClass);
            opSignature.setCommandInfo(info.cInfo());
            Trie advTrie = this.buildTries(delegateClass, '.');
            this.advTries.put(advTrie, opSignature);
            advOpType.add(opSignature);
            simpleName = this.simplifyTypes(simpleName);
            if (this.isSimple(info.cInfo(), simpleName, smplOps)) {
                OpTreeTableNode simpleOp = new OpTreeTableNode(simpleName, codeCall, delegateClass);
                simpleOp.setCommandInfo(info.cInfo());
                Trie smplTrie = this.buildTries(simpleName, new char[0]);
                this.smplTries.put(smplTrie, simpleOp);
                smplOpType.add(simpleOp);
            }
            this.updateWidths(this.widths, simpleName, codeCall, delegateClass);
        }
        this.pruneEmptyNodes(smplParent);
    }

    private void buildSimpleInputs() {
        this.simpleFilterClasses = new HashSet();
        this.simpleFilterClasses.add(Img.class);
    }

    private String simplifyTypes(String simpleName) {
        simpleName = simpleName.replaceAll("ArrayImg|PlanarImg|RandomAccessibleInterval|IterableInterval|Img|Histogram1d|ImgPlus|Dataset", "Image");
        simpleName = simpleName.replaceAll(NUMBER_REGEX, "Number");
        simpleName = simpleName.replaceAll("[a-zA-Z0-9]+(\\[\\])? [a-zA-Z0-9]+\\?", "");
        simpleName = simpleName.replaceAll(", (, )+", ", ");
        simpleName = simpleName.replaceAll("(, )+(\\))", "$2");
        simpleName = simpleName.replaceAll("(\\()(, )+", "$1");
        int splitPoint = simpleName.substring(0, simpleName.indexOf(40)).lastIndexOf(32);
        return simpleName.substring(splitPoint + 1);
    }

    private boolean isSimple(CommandInfo info, String simpleName, Set<String> simpleOps) {
        if (!simpleOps.contains(simpleName)) {
            for (ModuleItem moduleItem : info.inputs()) {
                Class inputType = moduleItem.getType();
                for (Class<?> acceptedClass : this.simpleFilterClasses) {
                    if (!acceptedClass.isAssignableFrom(inputType)) continue;
                    simpleOps.add(simpleName);
                    return true;
                }
            }
        }
        return false;
    }

    private Trie buildTries(String rawDict, char ... delim) {
        Trie trie = new Trie().removeOverlaps();
        Set<String> substrings = this.getSubstringsWithDelim(rawDict.toLowerCase(Locale.getDefault()), delim);
        for (String substring : substrings) {
            trie.addKeyword(substring);
        }
        return trie;
    }

    private boolean pruneEmptyNodes(OpTreeTableNode node) {
        boolean removeThis = node.getCodeCall().isEmpty();
        ArrayList<OpTreeTableNode> preservedChildren = new ArrayList<OpTreeTableNode>();
        for (OpTreeTableNode child : node.getChildren()) {
            if (this.pruneEmptyNodes(child)) continue;
            preservedChildren.add(child);
        }
        node.getChildren().retainAll(preservedChildren);
        return removeThis &= node.getChildren().isEmpty();
    }

    private Set<String> getSubstringsWithDelim(String string, char ... delims) {
        HashSet<String> substringsToCheck = new HashSet<String>();
        String strOfInterest = string;
        for (char delim : delims) {
            int dotIndex = 0;
            while (dotIndex >= 0) {
                int startIndex = dotIndex;
                if ((dotIndex = string.indexOf(delim, dotIndex + 1)) < 0) {
                    strOfInterest = string.substring(startIndex, string.length());
                    continue;
                }
                substringsToCheck.add(string.substring(startIndex, dotIndex + 1));
            }
        }
        for (int start = 0; start < strOfInterest.length() - 1; ++start) {
            for (int end = start + 1; end <= strOfInterest.length(); ++end) {
                substringsToCheck.add(strOfInterest.substring(start, end));
            }
        }
        return substringsToCheck;
    }

    private OpTreeTableNode buildNamespaceHierarchy(OpTreeTableNode parent, Map<String, OpTreeTableNode> namespaceMap, String namespace) {
        StringBuilder sb = new StringBuilder();
        OpTreeTableNode prevParent = parent;
        for (String ns : namespace.split("\\.")) {
            sb.append(ns);
            String key = sb.toString().toLowerCase(Locale.getDefault());
            OpTreeTableNode nsNode = namespaceMap.get(key);
            if (nsNode == null) {
                nsNode = new OpTreeTableNode(ns);
                namespaceMap.put(key, nsNode);
                prevParent.add(nsNode);
            }
            prevParent = nsNode;
        }
        return prevParent;
    }

    private void updateWidths(int[] colWidths, String ... colContents) {
        for (int i = 0; i < Math.min(colWidths.length, colContents.length); ++i) {
            colWidths[i] = Math.max(colWidths[i], colContents[i].length());
        }
    }

    private void copyPass() {
        this.setSuccessIcon(this.opSuccess);
        this.successLabel.setText("copied ");
        this.successTimer.restart();
    }

    private void selectFail() {
        this.setSuccessIcon(this.opFail);
        this.successLabel.setText("no selection ");
        this.successTimer.restart();
    }

    private void setSuccessIcon(ImageIcon icon) {
        this.successLabel.setVisible(true);
        this.successLabel.setIcon(icon);
    }

    private String getName(String name, String backupName) {
        if (name == null || name.isEmpty()) {
            name = backupName;
        }
        return name == null ? "" : name.trim();
    }

    private OpTreeTableNode getSelectedNode() {
        int row = this.treeTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.getNodeAtRow(row);
    }

    private OpTreeTableNode getNodeAtRow(int row) {
        TreePath path = this.treeTable.getPathForRow(row);
        return path == null ? null : (OpTreeTableNode)path.getPath()[path.getPathCount() - 1];
    }

    private class CopyButtonListener
    implements ActionListener {
        private CopyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIndex = OpFinder.this.treeTable.getSelectedRow();
            int colIndex = OpFinder.this.treeTable.getSelectedColumn();
            String toCopy = rowIndex < 0 ? "" : (colIndex < 0 ? OpFinder.this.getSelectedNode().getCodeCall() : OpFinder.this.treeTable.getValueAt(rowIndex, colIndex).toString());
            if (toCopy.isEmpty()) {
                OpFinder.this.selectFail();
            } else {
                StringSelection stringSelection = new StringSelection(toCopy);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
                OpFinder.this.copyPass();
            }
        }
    }

    private class RunButtonListener
    implements ActionListener {
        private RunButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandInfo cInfo;
            OpTreeTableNode selectedNode = OpFinder.this.getSelectedNode();
            if (selectedNode == null || (cInfo = selectedNode.getCommandInfo()) == null) {
                OpFinder.this.selectFail();
                return;
            }
            try {
                String script = this.makeScript(cInfo);
                OpFinder.this.scriptService.run("op_browser.py", script, true, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | SecurityException exc) {
                OpFinder.this.logService.error((Throwable)exc);
            }
        }

        private String makeScript(CommandInfo cInfo) throws NoSuchFieldException, SecurityException, InstantiationException, IllegalAccessException, ClassNotFoundException {
            StringBuffer sb = new StringBuffer();
            sb.append("# @OpService ops\n");
            String imgRegex = ".*ArrayImg|PlanarImg|RandomAccessibleInterval|IterableInterval|Img|Histogram1d.*";
            String imgPlusRegex = ".*ImgPlus|Dataset.*";
            ArrayList<String> inputNames = new ArrayList<String>();
            for (ModuleItem in : cInfo.inputs()) {
                if (!in.isRequired()) continue;
                sb.append("# @");
                String type = in.getType().getName();
                String name = "input_" + in.getName();
                inputNames.add(name);
                if (type.matches(".*ImgPlus|Dataset.*")) {
                    sb.append("ImgPlus");
                } else if (type.matches(".*ArrayImg|PlanarImg|RandomAccessibleInterval|IterableInterval|Img|Histogram1d.*")) {
                    sb.append("Img");
                } else {
                    sb.append(type);
                }
                sb.append(" ");
                sb.append(name);
                sb.append(" ");
                sb.append("\n");
            }
            String outType = "";
            String outName = "";
            for (ModuleItem out : cInfo.outputs()) {
                if (outType.isEmpty()) {
                    outType = out.getType().getName();
                    outName = out.getName();
                    if (outType.matches(".*ImgPlus|Dataset.*")) {
                        outType = "ImgPlus";
                        continue;
                    }
                    if (!outType.matches(".*ArrayImg|PlanarImg|RandomAccessibleInterval|IterableInterval|Img|Histogram1d.*")) continue;
                    outType = "Img";
                    continue;
                }
                outType = null;
                break;
            }
            if (outType != null && !outType.isEmpty()) {
                sb.append("# @OUTPUT ");
                sb.append(outType);
                sb.append(" ");
                sb.append(outName);
                sb.append("\n");
                sb.append(outName);
                sb.append(" = ");
            }
            sb.append("ops.run(\"");
            sb.append(OpUtils.getOpName((CommandInfo)cInfo));
            sb.append("\"");
            for (String name : inputNames) {
                sb.append(", ");
                sb.append(name);
            }
            sb.append(")\n");
            return sb.toString();
        }
    }

    private class WikiButtonListener
    implements ActionListener {
        private WikiButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                OpFinder.this.platformService.open(new URL("http://imagej.net/ImageJ_Ops"));
            }
            catch (IOException exc) {
                OpFinder.this.logService.error((Throwable)exc);
            }
        }
    }

    private class ModeButton
    extends JButton {
        private final String toolTip = "Toggle User and Developer views";
        private final String simpleFilterLabel = "Filter Ops:  ";
        private final String advancedFilterLabel = "Filter Ops by Class:  ";

        public ModeButton() {
            this.setLabels(OpFinder.this.simple);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpFinder.this.setState(!OpFinder.this.simple);
                }
            });
        }

        public void setLabels(boolean simple) {
            this.setIcon(simple ? OpFinder.this.useView : OpFinder.this.devView);
            this.setToolTipText("Toggle User and Developer views");
            OpFinder.this.searchLabel.setText(simple ? "Filter Ops:  " : "Filter Ops by Class:  ");
        }
    }

    private class HTMLFetcher
    extends InterruptableRunner {
        private final String url;
        private final String requestedClass;
        private final StringBuilder sb;

        public HTMLFetcher(StringBuilder sb, String url, String requestedClass) {
            this.url = url;
            this.requestedClass = requestedClass;
            this.sb = sb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Document doc = Jsoup.connect((String)this.sb.toString()).get();
                Elements elements = doc.select("div.header");
                elements.addAll((Collection)doc.select("div.contentContainer"));
                Map map = OpFinder.this.elementsMap;
                synchronized (map) {
                    OpFinder.this.elementsMap.put(this.url, elements.html());
                }
            }
            catch (IOException exc) {
                Map map = OpFinder.this.elementsMap;
                synchronized (map) {
                    OpFinder.this.elementsMap.put(this.url, "Javadoc not available for: " + this.requestedClass);
                }
            }
            if (this.poll()) {
                return;
            }
            OpFinder.this.textPane.setText((String)OpFinder.this.elementsMap.get(this.url));
            OpFinder.this.scrollToTop();
            this.stop();
        }
    }

    private class FilterRunner
    extends InterruptableRunner {
        private final String text;

        public FilterRunner(String text) {
            this.text = text;
        }

        @Override
        public synchronized void stop() {
            super.stop();
            OpFinder.this.setProgress(0);
        }

        @Override
        public void run() {
            final OpTreeTableModel tempModel = new OpTreeTableModel(OpFinder.this.simple);
            OpTreeTableNode filtered = this.applyFilter(this.text.toLowerCase(Locale.getDefault()), OpFinder.this.simple ? OpFinder.this.smplTries : OpFinder.this.advTries);
            if (filtered == null) {
                return;
            }
            tempModel.getRoot().add(filtered);
            if (this.poll()) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OpFinder.this.treeTable.setTreeTableModel((TreeTableModel)tempModel);
                        OpFinder.this.treeTable.expandAll();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exc) {
                OpFinder.this.logService.error((Throwable)exc);
            }
        }

        private OpTreeTableNode applyFilter(String filter, Map<Trie, OpTreeTableNode> tries) {
            OpTreeTableNode parent = new OpTreeTableNode("ops", "# @OpService ops", "net.imagej.ops.OpService");
            HashMap scoredOps = new HashMap();
            ArrayList<Integer> keys = new ArrayList<Integer>();
            boolean keep = true;
            int count = 0;
            double nextProgress = 0.05;
            for (Trie trie : tries.keySet()) {
                if ((double)(++count) / (double)tries.keySet().size() >= nextProgress) {
                    if (this.poll()) {
                        return null;
                    }
                    OpFinder.this.setProgress((int)(nextProgress * 100.0));
                    nextProgress += 0.05;
                }
                Collection parse = trie.parseText(filter);
                int score = 0;
                for (Emit e : parse) {
                    score += 2 * e.getKeyword().length() - 1;
                }
                int pos = -(Collections.binarySearch(keys, score) + 1);
                if (scoredOps.containsKey(score)) {
                    ((List)scoredOps.get(score)).add(tries.get(trie));
                    if (keys.contains(score)) continue;
                    keys.add(score, pos);
                    continue;
                }
                if (keys.size() >= 1 && pos <= 0) continue;
                ArrayList<OpTreeTableNode> ops = new ArrayList<OpTreeTableNode>();
                ops.add(tries.get(trie));
                scoredOps.put(score, ops);
                keys.add(pos, score);
                if (keys.size() <= 1) continue;
                scoredOps.remove(keys.remove(0));
            }
            List<OpTreeTableNode> children = parent.getChildren();
            for (int i = keys.size() - 1; i >= 0; --i) {
                Integer key = (Integer)keys.get(i);
                for (OpTreeTableNode node : (List)scoredOps.get(key)) {
                    children.add(node);
                }
            }
            OpFinder.this.setProgress(100);
            return parent;
        }
    }

    private abstract class InterruptableRunner
    implements Runnable {
        private boolean stop = false;

        private InterruptableRunner() {
        }

        public synchronized boolean poll() {
            return this.stop;
        }

        public synchronized void stop() {
            this.stop = true;
        }

        public synchronized boolean isDone() {
            return this.stop;
        }
    }
}

