/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Ellipse;
import ome.xml.model.Label;
import ome.xml.model.Line;
import ome.xml.model.Mask;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Rectangle;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Union
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Union.class);
    private List<Shape> shapes = new ArrayList<Shape>();

    public Union() {
    }

    public Union(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Union(Union orig) {
        this.shapes = orig.shapes;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        List<Element> Ellipse_nodeList = Union.getChildrenByTagName(element, "Ellipse");
        for (Element element2 : Ellipse_nodeList) {
            this.addShape(new Ellipse(element2, model));
        }
        List<Element> Label_nodeList = Union.getChildrenByTagName(element, "Label");
        for (Element element3 : Label_nodeList) {
            this.addShape(new Label(element3, model));
        }
        List<Element> list = Union.getChildrenByTagName(element, "Line");
        for (Element element4 : list) {
            this.addShape(new Line(element4, model));
        }
        List<Element> list2 = Union.getChildrenByTagName(element, "Mask");
        for (Element element5 : list2) {
            this.addShape(new Mask(element5, model));
        }
        List<Element> list3 = Union.getChildrenByTagName(element, "Point");
        for (Element element6 : list3) {
            this.addShape(new Point(element6, model));
        }
        List<Element> list4 = Union.getChildrenByTagName(element, "Polygon");
        for (Element element7 : list4) {
            this.addShape(new Polygon(element7, model));
        }
        List<Element> list5 = Union.getChildrenByTagName(element, "Polyline");
        for (Element Polyline_element : list5) {
            this.addShape(new Polyline(Polyline_element, model));
        }
        List<Element> list6 = Union.getChildrenByTagName(element, "Rectangle");
        for (Element Rectangle_element : list6) {
            this.addShape(new Rectangle(Rectangle_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public int sizeOfShapeList() {
        return this.shapes.size();
    }

    public List<Shape> copyShapeList() {
        return new ArrayList<Shape>(this.shapes);
    }

    public void clearShapeList() {
        this.shapes.clear();
    }

    public Shape getShape(int index) {
        return this.shapes.get(index);
    }

    public Shape setShape(int index, Shape shape) {
        shape.setUnion(this);
        return this.shapes.set(index, shape);
    }

    public void addShape(Shape shape) {
        shape.setUnion(this);
        this.shapes.add(shape);
    }

    public void removeShape(Shape shape) {
        this.shapes.remove(shape);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Union_element) {
        if (Union_element == null) {
            Union_element = document.createElementNS(NAMESPACE, "Union");
        }
        super.asXMLElement(document, Union_element);
        if (this.shapes != null) {
            for (Shape shapes_value : this.shapes) {
                Element child = document.createElementNS(NAMESPACE, shapes_value.getClass().getSimpleName());
                shapes_value.asXMLElement(document, child);
                Union_element.appendChild(child);
            }
        }
        return Union_element;
    }
}

