/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.detection.FilamentDetectorService;
import sc.fiji.filamentdetector.detection.FilteringParameters;
import sc.fiji.filamentdetector.detection.IJ2RidgeDetectionFilamentDetector;
import sc.fiji.filamentdetector.detection.RidgeDetectionFilamentDetector;
import sc.fiji.filamentdetector.event.FilterFilamentEvent;
import sc.fiji.filamentdetector.event.PreventPanelSwitchEvent;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.gui.controller.detection.AbstractFilamentDetectorController;
import sc.fiji.filamentdetector.gui.controller.detection.IJ2RidgeDetectionFilamentDetectorController;
import sc.fiji.filamentdetector.gui.controller.detection.RidgeDetectionFilamentDetectorController;
import sc.fiji.filamentdetector.gui.event.DetectionParametersUpdatedEvent;
import sc.fiji.filamentdetector.gui.fxwidgets.UpperLowerSynchronizer;
import sc.fiji.filamentdetector.gui.view.FilamentsTableView;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;

public class DetectFilamentController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/DetectFilamentView.fxml";
    @Parameter
    private Context context;
    @Parameter
    private StatusService status;
    @Parameter
    private EventService eventService;
    @Parameter
    private LogService log;
    @Parameter
    private FilamentOverlayService overlayService;
    @Parameter
    private FilamentDetectorService filamentDetectorService;
    @FXML
    private ComboBox<FilamentDetector> detectorComboBox;
    @FXML
    private AnchorPane detectorParametersPane;
    @FXML
    private Button detectButton;
    @FXML
    private CheckBox detectCurrentFrameButton;
    @FXML
    private CheckBox liveDetectionButton;
    @FXML
    private ProgressIndicator detectionProgressIndicator;
    @FXML
    private VBox filamentViewContainer;
    @FXML
    private AnchorPane detailViewContainer;
    @FXML
    private Slider maxLengthSlider;
    @FXML
    private TextField maxLengthField;
    @FXML
    private Slider minLengthSlider;
    @FXML
    private TextField minLengthField;
    @FXML
    private Slider maxSinuositySlider;
    @FXML
    private TextField maxSinuosityField;
    @FXML
    private Slider minSinuositySlider;
    @FXML
    private TextField minSinuosityField;
    @FXML
    private CheckBox simplifyFilamentsCheckbox;
    @FXML
    private CheckBox disableFilteringBox;
    @FXML
    private TextField simplifyToleranceDistanceField;
    private FilamentsTableView filamentsTableView;
    private FilamentWorkflow filamentWorkflow;
    private Thread detectionThread;
    private Task<Integer> detectionTask;
    private Thread filterThread;
    private Task<Integer> filterTask;
    private FilteringParameters filteringParameters;
    private UpperLowerSynchronizer lengthSync;
    private UpperLowerSynchronizer sinuositySync;
    private List<FilamentDetector> filamentDetectors;

    public DetectFilamentController(Context context, FilamentWorkflow filamentWorkflow) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentWorkflow = filamentWorkflow;
        this.filamentDetectors = this.filamentDetectorService.getDetectors();
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.detectionProgressIndicator.setVisible(false);
        this.initDetectionComboBox();
        this.detectCurrentFrameButton.setSelected(this.filamentWorkflow.getFilamentDetector().isDetectOnlyCurrentFrame());
        this.simplifyFilamentsCheckbox.setSelected(this.filamentWorkflow.getFilamentDetector().isSimplifyFilaments());
        this.simplifyToleranceDistanceField.setText(Double.toString(this.filamentWorkflow.getFilamentDetector().getSimplifyToleranceDistance()));
        this.filteringParameters = new FilteringParameters();
        this.filteringParameters.setDisableFiltering(true);
        this.lengthSync = new UpperLowerSynchronizer(this.minLengthSlider, this.minLengthField, this.maxLengthSlider, this.maxLengthField);
        this.lengthSync.setLowerValue(this.filteringParameters.getMinLength());
        this.lengthSync.setUpperValue(this.filteringParameters.getMaxLength());
        this.sinuositySync = new UpperLowerSynchronizer(this.minSinuositySlider, this.minSinuosityField, this.maxSinuositySlider, this.maxSinuosityField);
        this.sinuositySync.setLowerValue(this.filteringParameters.getMinSinuosity());
        this.sinuositySync.setUpperValue(this.filteringParameters.getMaxSinuosity());
        this.disableFilteringBox.setSelected(this.filteringParameters.isDisableFiltering());
        Tooltip tooltip = new Tooltip("Only detect filaments on the current frame (use for quick detection parameters tuning).");
        Tooltip.install((Node)this.detectCurrentFrameButton, (Tooltip)tooltip);
        tooltip = new Tooltip("Perform detection each time a parameter is modified.");
        Tooltip.install((Node)this.liveDetectionButton, (Tooltip)tooltip);
        this.filamentsTableView = new FilamentsTableView(this.context, this.filamentWorkflow.getFilaments());
        this.filamentViewContainer.getChildren().add(0, (Object)this.filamentsTableView.getInfoPane());
        this.filamentViewContainer.getChildren().add(1, (Object)this.filamentsTableView);
        this.detailViewContainer.getChildren().add((Object)this.filamentsTableView.getDetailPane());
    }

    public void initPane() {
    }

    private void setFilamentDetector(FilamentDetector filamentDetector) {
        this.filamentWorkflow.setFilamentDetector(filamentDetector);
        AbstractFilamentDetectorController controller = null;
        if (filamentDetector.getClass().equals(RidgeDetectionFilamentDetector.class)) {
            controller = new RidgeDetectionFilamentDetectorController(this.context, filamentDetector);
        } else if (filamentDetector.getClass().equals(IJ2RidgeDetectionFilamentDetector.class)) {
            controller = new IJ2RidgeDetectionFilamentDetectorController(this.context, filamentDetector);
        } else {
            this.log.error((Object)"Can't load FilamentDetector parameters pane.");
        }
        if (controller != null) {
            this.detectorParametersPane.getChildren().clear();
            this.detectorParametersPane.getChildren().add((Object)controller.loadPane());
        }
    }

    public void initDetectionComboBox() {
        Callback<ListView<FilamentDetector>, ListCell<FilamentDetector>> cellFactory = new Callback<ListView<FilamentDetector>, ListCell<FilamentDetector>>(){

            public ListCell<FilamentDetector> call(ListView<FilamentDetector> p) {
                return new ListCell<FilamentDetector>(){

                    protected void updateItem(FilamentDetector t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
        this.detectorComboBox.setButtonCell((ListCell)cellFactory.call(null));
        this.detectorComboBox.setCellFactory((Callback)cellFactory);
        this.detectorComboBox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.setFilamentDetector((FilamentDetector)newValue);
            } else {
                this.setFilamentDetector(this.filamentDetectors.get(0));
            }
        });
        this.detectorComboBox.setItems(FXCollections.observableList(this.filamentDetectors));
        this.detectorComboBox.getSelectionModel().selectFirst();
    }

    private void updateFilamentsList() {
        this.filamentsTableView.setFilaments(this.filamentWorkflow.getFilaments());
    }

    @FXML
    public void importLinesfromROIManager(MouseEvent event) {
        this.updateFilamentsList();
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            this.status.showStatus("Roi Manager not found. Press 't' to add a line to it.");
            return;
        }
        int total = 0;
        int i = 1;
        Filament filament = null;
        for (Roi roi : rm.getRoisAsArray()) {
            Object[] y;
            Object[] x;
            PolygonRoi line;
            if (roi.getType() == 7 || roi.getType() == 6) {
                line = (PolygonRoi)roi;
                x = line.getFloatPolygon().xpoints;
                y = line.getFloatPolygon().ypoints;
                filament = new Filament((float[])x, (float[])y, roi.getTPosition());
                rm.select(i);
                rm.runCommand("Delete");
                ++total;
            } else if (roi.getType() == 5) {
                line = (Line)roi;
                x = new double[]{line.x1d, line.x2d};
                y = new double[]{line.y1d, line.y2d};
                filament = new Filament((double[])x, (double[])y, roi.getTPosition());
                rm.select(i);
                rm.runCommand("Delete");
                ++total;
            }
            if (filament != null) {
                this.filamentsTableView.addFilament(filament);
            }
            ++i;
        }
        this.status.showStatus(total + " filament(s) has been added.");
        this.eventService.publish((SciJavaEvent)new FilterFilamentEvent(this.filteringParameters));
    }

    @FXML
    public void updateDetectionParameters(Event event) {
        if (event.getSource().equals(this.detectCurrentFrameButton)) {
            this.filamentWorkflow.getFilamentDetector().setDetectOnlyCurrentFrame(this.detectCurrentFrameButton.isSelected());
        } else if (event.getSource().equals(this.simplifyToleranceDistanceField)) {
            double newValue = Double.parseDouble(this.simplifyToleranceDistanceField.getText());
            if (newValue < 0.0) {
                this.simplifyToleranceDistanceField.setText(Double.toString(this.filamentWorkflow.getFilamentDetector().getSimplifyToleranceDistance()));
            } else {
                this.filamentWorkflow.getFilamentDetector().setSimplifyToleranceDistance(newValue);
            }
        } else if (event.getSource().equals(this.simplifyFilamentsCheckbox)) {
            this.filamentWorkflow.getFilamentDetector().setSimplifyFilaments(this.simplifyFilamentsCheckbox.isSelected());
        }
        if (this.liveDetectionButton.isSelected()) {
            this.detect(null);
        }
    }

    @EventHandler
    public void updateDetectionParameters(DetectionParametersUpdatedEvent event) {
        if (this.liveDetectionButton.isSelected()) {
            this.detect(null);
        }
    }

    @FXML
    public void updateFilteringParameters(Event event) {
        if (this.lengthSync.isEvent(event)) {
            this.lengthSync.update(event);
            this.filteringParameters.setMinLength(this.lengthSync.getLowerValue());
            this.filteringParameters.setMaxLength(this.lengthSync.getUpperValue());
        } else if (this.sinuositySync.isEvent(event)) {
            this.sinuositySync.update(event);
            this.filteringParameters.setMinSinuosity(this.sinuositySync.getLowerValue());
            this.filteringParameters.setMaxSinuosity(this.sinuositySync.getUpperValue());
        } else if (event.getSource().equals(this.disableFilteringBox)) {
            this.filteringParameters.setDisableFiltering(this.disableFilteringBox.isSelected());
        }
        this.eventService.publish((SciJavaEvent)new FilterFilamentEvent(this.filteringParameters));
    }

    @FXML
    public void detect(ActionEvent event) {
        if (this.detectionTask != null) {
            this.detectionTask.cancel();
        }
        this.detectionProgressIndicator.setVisible(true);
        this.detectionTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    Platform.runLater(() -> DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(true)));
                }
                if (DetectFilamentController.this.detectCurrentFrameButton.isSelected()) {
                    DetectFilamentController.this.filamentWorkflow.detectCurrentFrame();
                } else {
                    DetectFilamentController.this.filamentWorkflow.detect();
                }
                return DetectFilamentController.this.filamentWorkflow.getFilaments().size();
            }

            protected void succeeded() {
                super.succeeded();
                DetectFilamentController.this.status.showStatus(DetectFilamentController.this.filamentWorkflow.getFilaments().size() + " filaments has been detected with the following parameters : ");
                DetectFilamentController.this.status.showStatus(DetectFilamentController.this.filamentWorkflow.getFilamentDetector().toString());
                DetectFilamentController.this.detectionProgressIndicator.setVisible(false);
                DetectFilamentController.this.updateFilamentsList();
                DetectFilamentController.this.eventService.publish((SciJavaEvent)new FilterFilamentEvent(DetectFilamentController.this.filteringParameters));
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                }
            }

            protected void cancelled() {
                super.cancelled();
                DetectFilamentController.this.detectionProgressIndicator.setVisible(false);
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                }
            }

            protected void failed() {
                super.failed();
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                }
                DetectFilamentController.this.status.showStatus("Something failed during detection: ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                DetectFilamentController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
                DetectFilamentController.this.detectionProgressIndicator.setVisible(false);
            }
        };
        this.detectionThread = new Thread((Runnable)this.detectionTask);
        this.detectionThread.setDaemon(true);
        this.detectionThread.start();
    }

    @FXML
    public void filter(ActionEvent event) {
        this.eventService.publish((SciJavaEvent)new FilterFilamentEvent(this.filteringParameters));
    }

    @EventHandler
    public void filter(final FilterFilamentEvent event) {
        if (this.filterTask != null) {
            this.filterTask.cancel();
        }
        if (this.filterThread != null) {
            this.filterThread.stop();
        }
        this.filterTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                Platform.runLater(() -> {
                    if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                        DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(true));
                    }
                    DetectFilamentController.this.filamentWorkflow.filterFilament(event.getFilteringParameters());
                    DetectFilamentController.this.updateFilamentsList();
                });
                return DetectFilamentController.this.filamentWorkflow.getFilaments().size();
            }

            protected void succeeded() {
                super.succeeded();
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    Platform.runLater(() -> DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false)));
                }
                if (!DetectFilamentController.this.filteringParameters.isDisableFiltering()) {
                    DetectFilamentController.this.status.showStatus("Filtering with the following parameters : ");
                    DetectFilamentController.this.status.showStatus(DetectFilamentController.this.filteringParameters.toString());
                    DetectFilamentController.this.status.showStatus(DetectFilamentController.this.filamentWorkflow.getFilaments().size() + " filament(s) remain.");
                } else {
                    DetectFilamentController.this.status.showStatus("Filtering is disabled. " + DetectFilamentController.this.filamentWorkflow.getFilaments().size() + " filaments detected.");
                }
            }

            protected void cancelled() {
                super.cancelled();
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                }
            }

            protected void failed() {
                super.failed();
                if (!DetectFilamentController.this.liveDetectionButton.isSelected()) {
                    DetectFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                }
                DetectFilamentController.this.status.showStatus("Something failed during filtering: ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                DetectFilamentController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
            }
        };
        this.filterThread = new Thread((Runnable)this.filterTask);
        this.filterThread.setDaemon(true);
        this.filterThread.start();
    }

    @FXML
    public void liveDetectionClicked(MouseEvent event) {
        if (this.liveDetectionButton.isSelected()) {
            this.detectButton.setDisable(true);
            this.detect(null);
        } else {
            this.detectButton.setDisable(false);
        }
    }
}

