/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.event.FilterTrackedFilamentEvent;
import sc.fiji.filamentdetector.event.PreventPanelSwitchEvent;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.gui.controller.tracking.BBoxLAPFilamentsTrackerController;
import sc.fiji.filamentdetector.gui.fxwidgets.SliderLabelSynchronizer;
import sc.fiji.filamentdetector.gui.fxwidgets.UpperLowerSynchronizer;
import sc.fiji.filamentdetector.gui.view.TrackedFilamentsTableView;
import sc.fiji.filamentdetector.tracking.BBoxLAPFilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilamentTrackerService;
import sc.fiji.filamentdetector.tracking.FilamentsTracker;
import sc.fiji.filamentdetector.tracking.FilteringTrackedFilamentsParameters;

public class TrackingFilamentController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/TrackingFilamentView.fxml";
    @Parameter
    private Context context;
    @Parameter
    private StatusService status;
    @Parameter
    private EventService eventService;
    @Parameter
    private LogService log;
    @Parameter
    private FilamentTrackerService trackerService;
    @FXML
    private ComboBox<FilamentsTracker> trackerComboBox;
    @FXML
    private AnchorPane trackerParametersPane;
    @FXML
    private Label nFilamentsField;
    @FXML
    private ProgressIndicator trackingProgressIndicator;
    @FXML
    private Slider maxSizeSlider;
    @FXML
    private TextField maxSizeField;
    @FXML
    private Slider minSizeSlider;
    @FXML
    private TextField minSizeField;
    @FXML
    private Slider limitBorderSlider;
    @FXML
    private TextField limitBorderField;
    @FXML
    private CheckBox disableFilteringBox;
    @FXML
    private VBox trackedFilamentViewContainer;
    @FXML
    private AnchorPane detailViewContainer;
    private Thread trackingThread;
    private Task<Integer> trackingTask;
    private Thread filterThread;
    private Task<Integer> filterTask;
    private UpperLowerSynchronizer sizeSync;
    private SliderLabelSynchronizer limitBorderSync;
    private List<FilamentsTracker> filamentsTrackers;
    private FilamentWorkflow filamentWorkflow;
    private FilteringTrackedFilamentsParameters filteringParameters;
    private TrackedFilamentsTableView trackedFilamentsTableView;

    public TrackingFilamentController(Context context, FilamentWorkflow filamentDetector) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentWorkflow = filamentDetector;
        this.filamentsTrackers = new ArrayList<FilamentsTracker>();
        this.filamentsTrackers.add(this.trackerService.getBBoxTracker());
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.trackingProgressIndicator.setVisible(false);
        this.initTrackerComboBox();
        this.setFilamentsTracker(this.filamentsTrackers.get(0));
        this.filteringParameters = new FilteringTrackedFilamentsParameters();
        this.sizeSync = new UpperLowerSynchronizer(this.minSizeSlider, this.minSizeField, this.maxSizeSlider, this.maxSizeField);
        this.sizeSync.setLowerTooltip("Keep tracks with a minimum number of filaments.");
        this.sizeSync.setUpperTooltip("Keep tracks with a maximum number of filaments.");
        this.sizeSync.setLowerValue(this.filteringParameters.getMinSize());
        this.sizeSync.setUpperValue(this.filteringParameters.getMaxSize());
        this.limitBorderSync = new SliderLabelSynchronizer(this.limitBorderSlider, this.limitBorderField);
        this.limitBorderSync.setValue(this.filteringParameters.getBorderLimit());
        this.disableFilteringBox.setSelected(this.filteringParameters.isDisableFiltering());
        this.trackedFilamentsTableView = new TrackedFilamentsTableView(this.context, this.filamentWorkflow.getTrackedFilaments());
        this.trackedFilamentViewContainer.getChildren().add(0, (Object)this.trackedFilamentsTableView.getInfoPane());
        this.trackedFilamentViewContainer.getChildren().add(1, (Object)this.trackedFilamentsTableView);
        this.detailViewContainer.getChildren().add((Object)this.trackedFilamentsTableView.getDetailPane());
    }

    public void initPane() {
        if (this.filamentWorkflow.getDataset().getFrames() == 1L) {
            this.status.showStatus("The image only has 1 timepoints. Tracking can't be done.");
            this.getPane().setDisable(true);
            this.nFilamentsField.setText("");
        } else if (this.filamentWorkflow.getFilaments() == null || this.filamentWorkflow.getFilaments().size() == 0) {
            this.status.showStatus("No filaments detected. Please use the \"Detect Filaments\" panel first.");
            this.getPane().setDisable(true);
            this.nFilamentsField.setText("");
        } else {
            this.trackerComboBox.getSelectionModel().select(0);
            this.getPane().setDisable(false);
            this.nFilamentsField.setText(Integer.toString(this.filamentWorkflow.getFilaments().size()));
        }
    }

    private void setFilamentsTracker(FilamentsTracker filamentTracker) {
        this.filamentWorkflow.setFilamentsTracker(filamentTracker);
        BBoxLAPFilamentsTrackerController controller = null;
        if (filamentTracker.getClass().equals(BBoxLAPFilamentsTracker.class)) {
            controller = new BBoxLAPFilamentsTrackerController(this.context, filamentTracker);
        } else {
            this.log.error((Object)"Can't load FilamentsTracker parameters pane.");
        }
        if (controller != null) {
            this.trackerParametersPane.getChildren().add((Object)controller.loadPane());
        }
    }

    public void initTrackerComboBox() {
        Callback<ListView<FilamentsTracker>, ListCell<FilamentsTracker>> cellFactory = new Callback<ListView<FilamentsTracker>, ListCell<FilamentsTracker>>(){

            public ListCell<FilamentsTracker> call(ListView<FilamentsTracker> p) {
                return new ListCell<FilamentsTracker>(){

                    protected void updateItem(FilamentsTracker t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getName());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
        this.trackerComboBox.setButtonCell((ListCell)cellFactory.call(null));
        this.trackerComboBox.setCellFactory((Callback)cellFactory);
        this.trackerComboBox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.setFilamentsTracker((FilamentsTracker)newValue);
            } else {
                this.setFilamentsTracker(this.filamentsTrackers.get(0));
            }
        });
        this.trackerComboBox.setItems(FXCollections.observableList(this.filamentsTrackers));
        this.trackerComboBox.getSelectionModel().selectFirst();
    }

    private void updateTrackedFilamentsList() {
        this.trackedFilamentsTableView.setTrackedFilaments(this.filamentWorkflow.getTrackedFilaments());
    }

    @FXML
    void track(ActionEvent event) {
        if (this.trackingTask != null) {
            this.trackingTask.cancel();
        }
        if (this.trackingThread != null) {
            this.trackingThread.stop();
        }
        this.trackingProgressIndicator.setVisible(true);
        this.trackingTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(true));
                TrackingFilamentController.this.filamentWorkflow.track();
                return TrackingFilamentController.this.filamentWorkflow.getTrackedFilaments().size();
            }

            protected void succeeded() {
                super.succeeded();
                TrackingFilamentController.this.status.showStatus(TrackingFilamentController.this.filamentWorkflow.getTrackedFilaments().size() + " tracks has been created with the following parameters : ");
                TrackingFilamentController.this.status.showStatus(TrackingFilamentController.this.filamentWorkflow.getFilamentsTracker().toString());
                TrackingFilamentController.this.trackingProgressIndicator.setVisible(false);
                TrackingFilamentController.this.updateTrackedFilamentsList();
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new FilterTrackedFilamentEvent(TrackingFilamentController.this.filteringParameters));
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
            }

            protected void cancelled() {
                super.cancelled();
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
                TrackingFilamentController.this.trackingProgressIndicator.setVisible(false);
            }

            protected void failed() {
                super.failed();
                TrackingFilamentController.this.status.showStatus("Something failed during tracking: ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                TrackingFilamentController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
                TrackingFilamentController.this.trackingProgressIndicator.setVisible(false);
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
            }
        };
        this.trackingThread = new Thread((Runnable)this.trackingTask);
        this.trackingThread.setDaemon(true);
        this.trackingThread.start();
    }

    @FXML
    void updateFilteringParameters(Event event) {
        if (this.sizeSync.isEvent(event)) {
            this.sizeSync.update(event);
            this.filteringParameters.setMinSize(this.sizeSync.getLowerValue());
            this.filteringParameters.setMaxSize(this.sizeSync.getUpperValue());
        } else if (this.limitBorderSync.isEvent(event)) {
            this.limitBorderSync.update(event);
            this.filteringParameters.setBorderLimit(this.limitBorderSync.getValue());
        } else if (event.getSource().equals(this.disableFilteringBox)) {
            this.filteringParameters.setDisableFiltering(this.disableFilteringBox.isSelected());
        }
        this.eventService.publish((SciJavaEvent)new FilterTrackedFilamentEvent(this.filteringParameters));
    }

    @FXML
    void filter(ActionEvent event) {
        this.eventService.publish((SciJavaEvent)new FilterTrackedFilamentEvent(this.filteringParameters));
    }

    @EventHandler
    public void filter(final FilterTrackedFilamentEvent event) {
        if (this.filterTask != null) {
            this.filterTask.cancel();
        }
        if (this.filterThread != null) {
            this.filterThread.stop();
        }
        this.filterTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                Platform.runLater(() -> {
                    TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(true));
                    TrackingFilamentController.this.filamentWorkflow.filterTrackedFilament(event.getFilteringTrackedFilamentsParameters());
                    TrackingFilamentController.this.updateTrackedFilamentsList();
                });
                return TrackingFilamentController.this.filamentWorkflow.getTrackedFilaments().size();
            }

            protected void succeeded() {
                super.succeeded();
                if (!TrackingFilamentController.this.filteringParameters.isDisableFiltering()) {
                    TrackingFilamentController.this.status.showStatus("Filtering with the following parameters : ");
                    TrackingFilamentController.this.status.showStatus(TrackingFilamentController.this.filteringParameters.toString());
                    TrackingFilamentController.this.status.showStatus(TrackingFilamentController.this.filamentWorkflow.getTrackedFilaments().size() + " track(s) remain.");
                } else {
                    TrackingFilamentController.this.status.showStatus("Filtering is disabled. " + TrackingFilamentController.this.filamentWorkflow.getTrackedFilaments().size() + " tracks detected.");
                }
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
            }

            protected void cancelled() {
                super.cancelled();
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
            }

            protected void failed() {
                super.failed();
                TrackingFilamentController.this.status.showStatus("Something failed during filtering: ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                TrackingFilamentController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
                TrackingFilamentController.this.eventService.publish((SciJavaEvent)new PreventPanelSwitchEvent(false));
            }
        };
        this.filterThread = new Thread((Runnable)this.filterTask);
        this.filterThread.setDaemon(true);
        this.filterThread.start();
    }
}

