/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.kymograph.linedrawer;

import java.util.Comparator;
import sc.fiji.filamentdetector.kymograph.linedrawer.AbstractLineDrawer;
import sc.fiji.filamentdetector.kymograph.linedrawer.LineDrawer;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.TrackedFilament;

public class AverageFilamentLineDrawer
extends AbstractLineDrawer
implements LineDrawer {
    public static String NAME = "Average Filament Line Drawer";
    public static String DESCRIPTION = "Find an \"average filament\" in the tracks while keeping the length similar to the longest one.";

    public AverageFilamentLineDrawer() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    @Override
    public double[] draw(TrackedFilament trackedFilament) {
        Filament filament = trackedFilament.stream().max(Comparator.comparing(Filament::getLength)).orElse(null);
        return filament.getTips();
    }
}

