/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.scijava.plugins.scripteditor.jython.JythonAutoCompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.ui.swing.script.autocompletion.ClassUtil;
import org.scijava.ui.swing.script.autocompletion.ImportCompletionImpl;
import org.scijava.ui.swing.script.autocompletion.ImportFormat;

public class JythonAutocompletionProvider
extends DefaultCompletionProvider {
    private final JythonAutoCompletions autoCompletions = new JythonAutoCompletions();
    private final RSyntaxTextArea text_area;
    private final ImportFormat formatter;
    private static final Pattern fromImport = Pattern.compile("^((from|import)[ \\t]+)([a-zA-Z_][a-zA-Z0-9._]*)$");
    private static final Pattern fastImport = Pattern.compile("^(from[ \\t]+)([a-zA-Z_][a-zA-Z0-9._]*)[ \\t]+$");
    private static final Pattern importStatement = Pattern.compile("^((from[ \\t]+([a-zA-Z0-9._]+)[ \\t]+|[ \\t]*)import[ \\t]+)([a-zA-Z0-9_., \\t]*)$");
    private static final Pattern simpleClassName = Pattern.compile("^(.*[ \\t]+|)([A-Z_][a-zA-Z0-9_]+)$");
    private static final Pattern staticMethodOrField = Pattern.compile("^((.*[ \\t]+|)([A-Z_][a-zA-Z0-9_]*)\\.)([a-zA-Z0-9_]*)$");

    public JythonAutocompletionProvider(RSyntaxTextArea text_area, ImportFormat formatter) {
        this.text_area = text_area;
        this.formatter = formatter;
        this.setParameterizedCompletionParams('(', ", ", ')');
        this.setAutoActivationRules(true, ".");
        new Thread(ClassUtil::ensureCache).start();
    }

    public boolean isValidChar(char c) {
        return Character.isLetterOrDigit(c) || '.' == c || ' ' == c;
    }

    private final List<Completion> asCompletionList(Stream<String> stream, String pre) {
        return stream.map(s -> new BasicCompletion((CompletionProvider)this, pre + s)).collect(Collectors.toList());
    }

    public List<Completion> getCompletionsImpl(JTextComponent comp) {
        String currentLine;
        String codeWithoutLastLine;
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String alreadyEnteredText = this.getAlreadyEnteredText(comp);
        try {
            codeWithoutLastLine = comp.getText(0, comp.getCaretPosition());
            int lastLineBreak = codeWithoutLastLine.lastIndexOf("\n") + 1;
            currentLine = codeWithoutLastLine.substring(lastLineBreak);
            codeWithoutLastLine = codeWithoutLastLine.substring(0, lastLineBreak);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return completions;
        }
        try {
            List<Completion> cs = this.autoCompletions.completionsFor(this, codeWithoutLastLine, currentLine, alreadyEnteredText);
            if (cs != null) {
                completions.addAll(cs);
            }
        }
        catch (Exception e) {
            JythonDev.print("Failed to get autocompletions from " + this.autoCompletions);
            JythonDev.printError(e);
        }
        completions.addAll(this.getCompletions(alreadyEnteredText));
        return completions;
    }

    public List<Completion> getCompletions(String text) {
        if (!ClassUtil.isCacheReady()) {
            return Collections.emptyList();
        }
        Matcher m1 = fromImport.matcher(text);
        if (m1.find()) {
            return this.asCompletionList(ClassUtil.findClassNamesContaining((String)m1.group(3)).map(arg_0 -> ((ImportFormat)this.formatter).singleToImportStatement(arg_0)), "");
        }
        Matcher m1f = fastImport.matcher(text);
        if (m1f.find()) {
            return this.asCompletionList(ClassUtil.findClassNamesForPackage((String)m1f.group(2)).map(arg_0 -> ((ImportFormat)this.formatter).singleToImportStatement(arg_0)), "");
        }
        Matcher m2 = importStatement.matcher(text);
        if (m2.find()) {
            String packageName = m2.group(3);
            String className2 = m2.group(4);
            JythonDev.print("m2 matches className: " + className2);
            String[] bycomma = className2.split(",");
            String precomma = "";
            if (bycomma.length > 1) {
                className2 = bycomma[bycomma.length - 1].trim();
                for (int i = 0; i < bycomma.length - 1; ++i) {
                    precomma = precomma + bycomma[0] + ", ";
                }
            }
            Stream<String> stream = className2.length() > 0 ? ClassUtil.findClassNamesStartingWith((String)(null == packageName ? className2 : packageName + "." + className2)) : ClassUtil.findClassNamesForPackage((String)packageName);
            stream = stream.map(s -> s.substring(Math.max(0, s.lastIndexOf(46) + 1)));
            return this.asCompletionList(stream, m2.group(1) + precomma);
        }
        Matcher m3 = simpleClassName.matcher(text);
        if (m3.find()) {
            return ClassUtil.findSimpleClassNamesStartingWith((String)m3.group(2)).stream().map(className -> new ImportCompletionImpl((CompletionProvider)this, m3.group(1) + className.substring(className.lastIndexOf(46) + 1), className, this.formatter.singleToImportStatement(className))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String[] getVariableAnSeedAtCaretLocation() {
        try {
            String[] stringArray;
            int caretOffset = this.text_area.getCaretPosition();
            int lineNumber = this.text_area.getLineOfOffset(caretOffset);
            int startOffset = this.text_area.getLineStartOffset(lineNumber);
            String lineUpToCaret = this.text_area.getText(startOffset, caretOffset - startOffset);
            String[] words = lineUpToCaret.split("\\s+");
            String[] varAndSeed = words[words.length - 1].split("\\.");
            if (varAndSeed.length == 2) {
                stringArray = varAndSeed;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = varAndSeed[varAndSeed.length - 1];
                stringArray = stringArray2;
                stringArray2[1] = "";
            }
            return stringArray;
        }
        catch (BadLocationException e) {
            JythonDev.printError(e);
            return null;
        }
    }
}

