/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBuildAndEnvironmentInfo {
    private static final String UNKNOWN = "UNKNOWN";
    private final String version;
    private final String revision;
    private final boolean cleanSources;
    private final String applicationName;

    protected AbstractBuildAndEnvironmentInfo(String applicationName) {
        boolean extractedCleanFlag;
        String extractedRevision;
        String extractedVersion;
        block20: {
            this.applicationName = applicationName;
            extractedVersion = UNKNOWN;
            extractedRevision = UNKNOWN;
            extractedCleanFlag = false;
            InputStream stream = AbstractBuildAndEnvironmentInfo.class.getResourceAsStream("/BUILD-" + applicationName + ".INFO");
            if (stream != null) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(stream));
                        String line = reader.readLine();
                        if (line != null) {
                            String[] rev = line.split("::");
                            if (rev.length == 3) {
                                extractedVersion = rev[0];
                                extractedRevision = rev[1];
                                extractedCleanFlag = "clean".equals(rev[2]);
                            } else {
                                String[] rev2 = line.split(":");
                                if (rev2.length == 3) {
                                    extractedVersion = rev2[0];
                                    extractedRevision = rev2[1];
                                    extractedCleanFlag = "clean".equals(rev2[2]);
                                } else {
                                    extractedVersion = line;
                                    extractedRevision = "?";
                                    extractedCleanFlag = false;
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException2) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.version = extractedVersion;
        this.revision = extractedRevision;
        this.cleanSources = extractedCleanFlag;
    }

    private static final String getProperty(String property) {
        return System.getProperty(property, UNKNOWN);
    }

    private static final boolean isUnknown(String property) {
        return property.equals(UNKNOWN);
    }

    public final String getCPUArchitecture() {
        return AbstractBuildAndEnvironmentInfo.getProperty("os.arch");
    }

    public final String getOS() {
        String osName = AbstractBuildAndEnvironmentInfo.getProperty("os.name");
        String osVersion = AbstractBuildAndEnvironmentInfo.getProperty("os.version");
        if (AbstractBuildAndEnvironmentInfo.isUnknown(osName) || AbstractBuildAndEnvironmentInfo.isUnknown(osVersion)) {
            return osName;
        }
        return String.valueOf(osName) + " (v" + osVersion + ")";
    }

    public final String getJavaVM() {
        String vmName = AbstractBuildAndEnvironmentInfo.getProperty("java.vm.name");
        String vmVersion = AbstractBuildAndEnvironmentInfo.getProperty("java.vm.version");
        if (AbstractBuildAndEnvironmentInfo.isUnknown(vmName) || AbstractBuildAndEnvironmentInfo.isUnknown(vmVersion)) {
            return vmName;
        }
        return String.valueOf(vmName) + " (v" + vmVersion + ")";
    }

    public final String getVersion() {
        return this.version;
    }

    public final boolean isCleanSources() {
        return this.cleanSources;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final String getFullVersion() {
        StringBuilder builder = new StringBuilder();
        String rev = this.getRevision();
        boolean isDirty = !this.isCleanSources();
        builder.append(this.getVersion());
        if (!AbstractBuildAndEnvironmentInfo.isUnknown(rev)) {
            builder.append(" (").append(rev);
            if (isDirty) {
                builder.append("*");
            }
            builder.append(")");
        } else if (isDirty) {
            builder.append("*");
        }
        return builder.toString();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public final List<String> getEnvironmentInfo() {
        ArrayList<String> environmentInfo = new ArrayList<String>();
        environmentInfo.add("Application: " + this.getApplicationName());
        environmentInfo.add("Version: " + this.getFullVersion());
        environmentInfo.add("Java VM: " + this.getJavaVM());
        environmentInfo.add("CPU Architecture: " + this.getCPUArchitecture());
        environmentInfo.add("OS: " + this.getOS());
        return environmentInfo;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        List<String> environmentInfo = this.getEnvironmentInfo();
        int n = environmentInfo.size();
        int i = 0;
        while (i < n) {
            builder.append(environmentInfo.get(i));
            if (i < n - 1) {
                builder.append(System.getProperty("line.separator"));
            }
            ++i;
        }
        return builder.toString();
    }
}

