/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import anisotropic_diffusion.Anisotropic_Diffusion_2D;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.io.FileSaver;
import ij.plugin.ZProjector;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.RankFilters;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import trainableSegmentation.ImageScience;
import trainableSegmentation.ReusableDenseInstance;
import trainableSegmentation.filters.Entropy_Filter;
import trainableSegmentation.filters.Kuwahara;
import trainableSegmentation.filters.Lipschitz_;
import trainableSegmentation.utils.Utils;
import vib.BilateralFilter;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class FeatureStack {
    private ImagePlus originalImage = null;
    private ImageStack wholeStack = null;
    private int width = 0;
    private int height = 0;
    private float minimumSigma = 1.0f;
    private float maximumSigma = 16.0f;
    public static final int GAUSSIAN = 0;
    public static final int SOBEL = 1;
    public static final int HESSIAN = 2;
    public static final int DOG = 3;
    public static final int MEMBRANE = 4;
    public static final int VARIANCE = 5;
    public static final int MEAN = 6;
    public static final int MINIMUM = 7;
    public static final int MAXIMUM = 8;
    public static final int MEDIAN = 9;
    public static final int ANISOTROPIC_DIFFUSION = 10;
    public static final int BILATERAL = 11;
    public static final int LIPSCHITZ = 12;
    public static final int KUWAHARA = 13;
    public static final int GABOR = 14;
    public static final int DERIVATIVES = 15;
    public static final int LAPLACIAN = 16;
    public static final int STRUCTURE = 17;
    public static final int ENTROPY = 18;
    public static final int NEIGHBORS = 19;
    public static final String[] availableFeatures = new String[]{"Gaussian_blur", "Sobel_filter", "Hessian", "Difference_of_gaussians", "Membrane_projections", "Variance", "Mean", "Minimum", "Maximum", "Median", "Anisotropic_diffusion", "Bilateral", "Lipschitz", "Kuwahara", "Gabor", "Derivatives", "Laplacian", "Structure", "Entropy", "Neighbors"};
    public static final boolean[] IMAGESCIENCE_FEATURES = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false};
    private boolean[] enableFeatures = new boolean[]{true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private boolean useNeighbors = false;
    private int membraneSize = 1;
    private int membranePatchSize = 19;
    private int nAngles = 10;
    private int minDerivativeOrder = 2;
    private int maxDerivativeOrder = 5;
    private final boolean colorFeatures;
    private boolean oldColorFormat = false;
    private boolean oldHessianFormat = false;
    private ExecutorService exe = null;

    public FeatureStack(ImagePlus image) {
        if (image.getType() == 4) {
            this.originalImage = new ImagePlus("original image", image.getProcessor());
            this.colorFeatures = true;
        } else {
            this.originalImage = new ImagePlus("original image", image.getProcessor().duplicate().convertToFloat());
            this.colorFeatures = false;
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.wholeStack = new ImageStack(this.width, this.height);
        this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate());
    }

    public FeatureStack(int width, int height, boolean colorFeatures) {
        this.width = width;
        this.height = height;
        this.wholeStack = new ImageStack(width, height);
        this.colorFeatures = colorFeatures;
    }

    public FeatureStack(ImageProcessor ip) {
        if (ip instanceof ColorProcessor) {
            this.originalImage = new ImagePlus("original image", ip);
            this.colorFeatures = true;
        } else {
            this.originalImage = new ImagePlus("original image", ip.duplicate().convertToFloat());
            this.colorFeatures = false;
        }
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.wholeStack = new ImageStack(this.width, this.height);
        this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate());
    }

    public void shutDownNow() {
        if (null != this.exe) {
            this.exe.shutdownNow();
        }
    }

    public void show() {
        ImagePlus showStack = new ImagePlus("featureStack", this.wholeStack);
        showStack.show();
    }

    public int getSize() {
        if (null != this.wholeStack) {
            return this.wholeStack.getSize();
        }
        return 0;
    }

    public String getSliceLabel(int index) {
        return this.wholeStack.getSliceLabel(index);
    }

    public int getHeight() {
        return this.wholeStack.getHeight();
    }

    public int getWidth() {
        return this.wholeStack.getWidth();
    }

    public boolean useNeighborhood() {
        return this.useNeighbors;
    }

    public void setUseNeighbors(boolean useNeighbors) {
        this.useNeighbors = useNeighbors;
    }

    public void setMembranePatchSize(int patchSize) {
        if (patchSize % 2 == 0) {
            ++patchSize;
        }
        this.membranePatchSize = patchSize;
    }

    public void addGaussianBlur(float sigma) {
        ImageProcessor ip = this.originalImage.getProcessor().duplicate();
        GaussianBlur gs = new GaussianBlur();
        gs.blurGaussian(ip, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
        this.wholeStack.addSlice(availableFeatures[0] + "_" + sigma, ip);
    }

    public Callable<ImagePlus> getGaussianBlur(final ImagePlus originalImage, final float sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                GaussianBlur gs = new GaussianBlur();
                gs.blurGaussian(ip, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
                return new ImagePlus(availableFeatures[0] + "_" + sigma, ip);
            }
        };
    }

    public void addEntropy(int radius, int numBins) {
        Entropy_Filter filter = new Entropy_Filter();
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageProcessor ip = channels[ch].getProcessor().duplicate();
            results[ch] = new ImagePlus(availableFeatures[18] + "_" + radius + "_" + numBins, (ImageProcessor)filter.getEntropy(ip, radius, numBins));
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getProcessor());
    }

    public Callable<ImagePlus> getEntropy(final ImagePlus originalImage, final int radius, final int numBins) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                Entropy_Filter filter = new Entropy_Filter();
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageProcessor ip = channels[ch].getProcessor().duplicate();
                    results[ch] = new ImagePlus(availableFeatures[18] + "_" + radius + "_" + numBins, (ImageProcessor)filter.getEntropy(ip, radius, numBins));
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addNeighbors(int minSigma, int maxSigma) {
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageStack result = new ImageStack(this.originalImage.getWidth(), this.originalImage.getHeight());
            for (int sigma = minSigma; sigma <= maxSigma; sigma *= 2) {
                double[][] neighborhood = new double[8][this.originalImage.getWidth() * this.originalImage.getHeight()];
                int n = 0;
                for (int y = 0; y < this.originalImage.getHeight(); ++y) {
                    int x = 0;
                    while (x < this.originalImage.getWidth()) {
                        int k = 0;
                        for (int i = -1 * sigma; i < sigma + 1; i += sigma) {
                            for (int j = -1 * sigma; j < sigma + 1; j += sigma) {
                                if (i == 0 && j == 0) continue;
                                neighborhood[k][n] = this.getPixelMirrorConditions(channels[ch].getProcessor(), x + i, y + j);
                                ++k;
                            }
                        }
                        ++x;
                        ++n;
                    }
                }
                for (int i = 0; i < 8; ++i) {
                    result.addSlice(availableFeatures[19] + "_" + sigma + "_" + i, (ImageProcessor)new FloatProcessor(this.originalImage.getWidth(), this.originalImage.getHeight(), neighborhood[i]));
                }
            }
            results[ch] = new ImagePlus("Neighbors", result);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        for (int i = 1; i <= merged.getImageStackSize(); ++i) {
            this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(i), merged.getImageStack().getPixels(i));
        }
    }

    public Callable<ImagePlus> getNeighbors(final ImagePlus originalImage, final int minSigma, final int maxSigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageStack result = new ImageStack(originalImage.getWidth(), originalImage.getHeight());
                    for (int sigma = minSigma; sigma <= maxSigma; sigma *= 2) {
                        double[][] neighborhood = new double[8][originalImage.getWidth() * originalImage.getHeight()];
                        int n = 0;
                        for (int y = 0; y < originalImage.getHeight(); ++y) {
                            int x = 0;
                            while (x < originalImage.getWidth()) {
                                int k = 0;
                                for (int i = -1 * sigma; i < sigma + 1; i += sigma) {
                                    for (int j = -1 * sigma; j < sigma + 1; j += sigma) {
                                        if (i == 0 && j == 0) continue;
                                        neighborhood[k][n] = FeatureStack.this.getPixelMirrorConditions(channels[ch].getProcessor(), x + i, y + j);
                                        ++k;
                                    }
                                }
                                ++x;
                                ++n;
                            }
                        }
                        for (int i = 0; i < 8; ++i) {
                            result.addSlice(availableFeatures[19] + "_" + sigma + "_" + i, (ImageProcessor)new FloatProcessor(originalImage.getWidth(), originalImage.getHeight(), neighborhood[i]));
                        }
                    }
                    results[ch] = new ImagePlus("Neighbors", result);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addVariance(float radius) {
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageProcessor ip = channels[ch].getProcessor().duplicate();
            RankFilters filter = new RankFilters();
            filter.rank(ip, (double)radius, 3);
            results[ch] = new ImagePlus(availableFeatures[5] + "_" + radius, ip);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getProcessor());
    }

    public Callable<ImagePlus> getVariance(final ImagePlus originalImage, final float radius) {
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageProcessor ip = channels[ch].getProcessor().duplicate();
                    RankFilters filter = new RankFilters();
                    filter.rank(ip, (double)radius, 3);
                    results[ch] = new ImagePlus(availableFeatures[5] + "_" + radius, ip);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addMean(float radius) {
        ImageProcessor ip = this.originalImage.getProcessor().duplicate();
        RankFilters filter = new RankFilters();
        filter.rank(ip, (double)radius, 0);
        this.wholeStack.addSlice(availableFeatures[6] + "_" + radius, ip);
    }

    public Callable<ImagePlus> getMean(final ImagePlus originalImage, final float radius) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                RankFilters filter = new RankFilters();
                filter.rank(ip, (double)radius, 0);
                return new ImagePlus(availableFeatures[6] + "_" + radius, ip);
            }
        };
    }

    public void addMin(float radius) {
        ImageProcessor ip = this.originalImage.getProcessor().duplicate();
        RankFilters filter = new RankFilters();
        filter.rank(ip, (double)radius, 1);
        this.wholeStack.addSlice(availableFeatures[7] + "_" + radius, ip);
    }

    public Callable<ImagePlus> getMin(final ImagePlus originalImage, final float radius) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                RankFilters filter = new RankFilters();
                filter.rank(ip, (double)radius, 1);
                return new ImagePlus(availableFeatures[7] + "_" + radius, ip);
            }
        };
    }

    public void addMax(float radius) {
        ImageProcessor ip = this.originalImage.getProcessor().duplicate();
        RankFilters filter = new RankFilters();
        filter.rank(ip, (double)radius, 2);
        this.wholeStack.addSlice(availableFeatures[8] + "_" + radius, ip);
    }

    public Callable<ImagePlus> getMax(final ImagePlus originalImage, final float radius) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                RankFilters filter = new RankFilters();
                filter.rank(ip, (double)radius, 2);
                return new ImagePlus(availableFeatures[8] + "_" + radius, ip);
            }
        };
    }

    public void addMedian(float radius) {
        ImageProcessor ip = this.originalImage.getProcessor().duplicate();
        RankFilters filter = new RankFilters();
        filter.rank(ip, (double)radius, 4);
        this.wholeStack.addSlice(availableFeatures[9] + "_" + radius, ip);
    }

    public Callable<ImagePlus> getMedian(final ImagePlus originalImage, final float radius) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                RankFilters filter = new RankFilters();
                filter.rank(ip, (double)radius, 4);
                return new ImagePlus(availableFeatures[9] + "_" + radius, ip);
            }
        };
    }

    public void writeConfigurationToFile(String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            try {
                for (int i = 1; i <= this.wholeStack.getSize(); ++i) {
                    out.write(this.wholeStack.getSliceLabel(i));
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                System.out.println("IOException");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found!");
        }
    }

    public void addGradient(float sigma) {
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            GaussianBlur gs = new GaussianBlur();
            ImageProcessor ip_x = channels[ch].getProcessor().duplicate().convertToFloat();
            gs.blurGaussian(ip_x, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
            Convolver c = new Convolver();
            float[] sobelFilter_x = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
            c.convolveFloat(ip_x, sobelFilter_x, 3, 3);
            ImageProcessor ip_y = channels[ch].getProcessor().duplicate().convertToFloat();
            gs.blurGaussian(ip_y, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
            c = new Convolver();
            float[] sobelFilter_y = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
            c.convolveFloat(ip_y, sobelFilter_y, 3, 3);
            FloatProcessor ip = new FloatProcessor(this.width, this.height);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    float s_x = ip_x.getf(x, y);
                    float s_y = ip_y.getf(x, y);
                    ip.setf(x, y, (float)Math.sqrt(s_x * s_x + s_y * s_y));
                }
            }
            results[ch] = new ImagePlus(availableFeatures[1] + "_" + sigma, (ImageProcessor)ip);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getImageStack().getProcessor(1));
    }

    public Callable<ImagePlus> getGradient(final ImagePlus originalImage, final float sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    GaussianBlur gs = new GaussianBlur();
                    ImageProcessor ip_x = channels[ch].getProcessor().duplicate().convertToFloat();
                    gs.blurGaussian(ip_x, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
                    Convolver c = new Convolver();
                    float[] sobelFilter_x = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
                    c.convolveFloat(ip_x, sobelFilter_x, 3, 3);
                    ImageProcessor ip_y = channels[ch].getProcessor().duplicate().convertToFloat();
                    gs.blurGaussian(ip_y, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
                    c = new Convolver();
                    float[] sobelFilter_y = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
                    c.convolveFloat(ip_y, sobelFilter_y, 3, 3);
                    FloatProcessor ip = new FloatProcessor(FeatureStack.this.width, FeatureStack.this.height);
                    for (int x = 0; x < FeatureStack.this.width; ++x) {
                        for (int y = 0; y < FeatureStack.this.height; ++y) {
                            float s_x = ip_x.getf(x, y);
                            float s_y = ip_y.getf(x, y);
                            ip.setf(x, y, (float)Math.sqrt(s_x * s_x + s_y * s_y));
                        }
                    }
                    results[ch] = new ImagePlus(availableFeatures[1] + "_" + sigma, (ImageProcessor)ip);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addHessian(float sigma) {
        ImagePlus merged = this.calculateHessian(this.originalImage, sigma);
        for (int i = 1; i <= merged.getImageStackSize(); ++i) {
            this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(i), merged.getImageStack().getPixels(i));
        }
    }

    public Callable<ImagePlus> getHessian(final ImagePlus originalImage, final float sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                return FeatureStack.this.calculateHessian(originalImage, sigma);
            }
        };
    }

    private ImagePlus calculateHessian(ImagePlus originalImage, float sigma) {
        ImagePlus[] channels = this.extractChannels(originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            results[ch] = this.calculateHessianOnChannel(channels[ch], sigma);
        }
        return this.mergeResultChannels(results);
    }

    private ImagePlus calculateHessianOnChannel(ImagePlus channel, float sigma) {
        float[] sobelFilter_x = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
        float[] sobelFilter_y = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
        Convolver c = new Convolver();
        GaussianBlur gs = new GaussianBlur();
        int width = channel.getWidth();
        int height = channel.getHeight();
        ImageProcessor ip_x = channel.getProcessor().duplicate().convertToFloat();
        gs.blurGaussian(ip_x, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
        c.convolveFloat(ip_x, sobelFilter_x, 3, 3);
        ImageProcessor ip_y = channel.getProcessor().duplicate().convertToFloat();
        gs.blurGaussian(ip_y, 0.4 * (double)sigma, 0.4 * (double)sigma, 2.0E-4);
        c.convolveFloat(ip_y, sobelFilter_y, 3, 3);
        ImageProcessor ip_xx = ip_x.duplicate();
        c.convolveFloat(ip_xx, sobelFilter_x, 3, 3);
        ImageProcessor ip_xy = ip_x.duplicate();
        c.convolveFloat(ip_xy, sobelFilter_y, 3, 3);
        ImageProcessor ip_yy = ip_y.duplicate();
        c.convolveFloat(ip_yy, sobelFilter_y, 3, 3);
        FloatProcessor ip = new FloatProcessor(width, height);
        FloatProcessor ipTr = new FloatProcessor(width, height);
        FloatProcessor ipDet = new FloatProcessor(width, height);
        FloatProcessor ipEig1 = new FloatProcessor(width, height);
        FloatProcessor ipEig2 = new FloatProcessor(width, height);
        FloatProcessor ipOri = new FloatProcessor(width, height);
        FloatProcessor ipSed = new FloatProcessor(width, height);
        FloatProcessor ipNed = new FloatProcessor(width, height);
        double t = Math.pow(1.0, 0.75);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float orientation;
                float s_xx = ip_xx.getf(x, y);
                float s_xy = ip_xy.getf(x, y);
                float s_yy = ip_yy.getf(x, y);
                ip.setf(x, y, (float)Math.sqrt(s_xx * s_xx + s_xy * s_xy + s_yy * s_yy));
                float trace = s_xx + s_yy;
                ipTr.setf(x, y, trace);
                float determinant = s_xx * s_yy - s_xy * s_xy;
                ipDet.setf(x, y, determinant);
                if (this.isOldHessianFormat()) {
                    ipEig1.setf(x, y, (float)((double)trace / 2.0 + Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
                    ipEig2.setf(x, y, (float)((double)trace / 2.0 - Math.sqrt((double)(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy)) / 2.0)));
                } else {
                    ipEig1.setf(x, y, (float)((double)trace + Math.sqrt(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy))) / 2.0f);
                    ipEig2.setf(x, y, (float)((double)trace - Math.sqrt(4.0f * s_xy * s_xy + (s_xx - s_yy) * (s_xx - s_yy))) / 2.0f);
                }
                if ((double)s_xy < 0.0) {
                    orientation = (float)(-0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
                    if (Float.isNaN(orientation)) {
                        orientation = 0.0f;
                    }
                    ipOri.setf(x, y, orientation);
                } else {
                    orientation = (float)(0.5 * Math.acos((double)(s_xx - s_yy) / Math.sqrt(4.0 * (double)s_xy * (double)s_xy + (double)((s_xx - s_yy) * (s_xx - s_yy)))));
                    if (Float.isNaN(orientation)) {
                        orientation = 0.0f;
                    }
                    ipOri.setf(x, y, orientation);
                }
                ipSed.setf(x, y, (float)(Math.pow(t, 4.0) * (double)trace * (double)trace * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
                ipNed.setf(x, y, (float)(Math.pow(t, 2.0) * (double)((s_xx - s_yy) * (s_xx - s_yy) + 4.0f * s_xy * s_xy)));
            }
        }
        ImageStack hessianStack = new ImageStack(width, height);
        hessianStack.addSlice(availableFeatures[2] + "_" + sigma, (ImageProcessor)ip);
        hessianStack.addSlice(availableFeatures[2] + "_Trace_" + sigma, (ImageProcessor)ipTr);
        hessianStack.addSlice(availableFeatures[2] + "_Determinant_" + sigma, (ImageProcessor)ipDet);
        hessianStack.addSlice(availableFeatures[2] + "_Eigenvalue_1_" + sigma, (ImageProcessor)ipEig1);
        hessianStack.addSlice(availableFeatures[2] + "_Eigenvalue_2_" + sigma, (ImageProcessor)ipEig2);
        hessianStack.addSlice(availableFeatures[2] + "_Orientation_" + sigma, (ImageProcessor)ipOri);
        hessianStack.addSlice(availableFeatures[2] + "_Square_Eigenvalue_Difference_" + sigma, (ImageProcessor)ipSed);
        hessianStack.addSlice(availableFeatures[2] + "_Normalized_Eigenvalue_Difference_" + sigma, (ImageProcessor)ipNed);
        return new ImagePlus("hessian stack", hessianStack);
    }

    public void addDoG(float sigma1, float sigma2) {
        GaussianBlur gs = new GaussianBlur();
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageProcessor ip_1 = channels[ch].getProcessor().duplicate();
            gs.blurGaussian(ip_1, 0.4 * (double)sigma1, 0.4 * (double)sigma1, 2.0E-4);
            ImageProcessor ip_2 = channels[ch].getProcessor().duplicate();
            gs.blurGaussian(ip_2, 0.4 * (double)sigma2, 0.4 * (double)sigma2, 2.0E-4);
            FloatProcessor ip = new FloatProcessor(this.width, this.height);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    float v1 = ip_1.getf(x, y);
                    float v2 = ip_2.getf(x, y);
                    ip.setf(x, y, v2 - v1);
                }
            }
            results[ch] = new ImagePlus(availableFeatures[3] + "_" + sigma1 + "_" + sigma2, (ImageProcessor)ip);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getImageStack().getProcessor(1));
    }

    public Callable<ImagePlus> getDoG(final ImagePlus originalImage, final float sigma1, final float sigma2) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                int width = originalImage.getWidth();
                int height = originalImage.getHeight();
                GaussianBlur gs = new GaussianBlur();
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageProcessor ip_1 = channels[ch].getProcessor().duplicate();
                    gs.blurGaussian(ip_1, 0.4 * (double)sigma1, 0.4 * (double)sigma1, 2.0E-4);
                    ImageProcessor ip_2 = channels[ch].getProcessor().duplicate();
                    gs.blurGaussian(ip_2, 0.4 * (double)sigma2, 0.4 * (double)sigma2, 2.0E-4);
                    FloatProcessor ip = new FloatProcessor(width, height);
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            float v1 = ip_1.getf(x, y);
                            float v2 = ip_2.getf(x, y);
                            ip.setf(x, y, v2 - v1);
                        }
                    }
                    results[ch] = new ImagePlus(availableFeatures[3] + "_" + sigma1 + "_" + sigma2, (ImageProcessor)ip);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addMembraneFeatures(int patchSize, int membraneSize) {
        FloatProcessor membranePatch = new FloatProcessor(patchSize, patchSize);
        int middle = Math.round(patchSize / 2);
        int startX = middle - (int)Math.floor((double)membraneSize / 2.0);
        int endX = middle + (int)Math.ceil((double)membraneSize / 2.0);
        for (int x = startX; x <= endX; ++x) {
            for (int y = 0; y < patchSize; ++y) {
                membranePatch.setf(x, y, 1.0f);
            }
        }
        double rotationAngle = 180 / this.nAngles;
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        Convolver c = new Convolver();
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageStack is = new ImageStack(this.width, this.height);
            for (int i = 0; i < this.nAngles; ++i) {
                ImageProcessor rotatedPatch = membranePatch.duplicate();
                rotatedPatch.rotate((double)i * rotationAngle);
                float[] kernel = (float[])rotatedPatch.getPixels();
                ImageProcessor ip = channels[ch].getProcessor().duplicate();
                c.convolveFloat(ip, kernel, patchSize, patchSize);
                is.addSlice("Membrane_" + patchSize + "_" + membraneSize, ip);
            }
            ImagePlus projectStack = new ImagePlus("membraneStack", is);
            ImageStack membraneStack = new ImageStack(this.width, this.height);
            ZProjector zp = new ZProjector(projectStack);
            zp.setStopSlice(is.getSize());
            for (int i = 0; i < 6; ++i) {
                zp.setMethod(i);
                zp.doProjection();
                membraneStack.addSlice(availableFeatures[4] + "_" + i + "_" + patchSize + "_" + membraneSize, zp.getProjection().getChannelProcessor());
            }
            results[ch] = new ImagePlus("membrane stack", membraneStack);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        for (int i = 1; i <= merged.getImageStackSize(); ++i) {
            this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(i), merged.getImageStack().getPixels(i));
        }
    }

    public Callable<ImagePlus> getMembraneFeatures(final ImagePlus originalImage, final int patchSize, final int membraneSize) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                int width = originalImage.getWidth();
                int height = originalImage.getHeight();
                FloatProcessor membranePatch = new FloatProcessor(patchSize, patchSize);
                int middle = Math.round(patchSize / 2);
                int startX = middle - (int)Math.floor((double)membraneSize / 2.0);
                int endX = middle + (int)Math.ceil((double)membraneSize / 2.0);
                for (int x = startX; x <= endX; ++x) {
                    for (int y = 0; y < patchSize; ++y) {
                        membranePatch.setf(x, y, 1.0f);
                    }
                }
                double rotationAngle = 180 / FeatureStack.this.nAngles;
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                Convolver c = new Convolver();
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageStack is = new ImageStack(width, height);
                    for (int i = 0; i < FeatureStack.this.nAngles; ++i) {
                        ImageProcessor rotatedPatch = membranePatch.duplicate();
                        rotatedPatch.rotate((double)i * rotationAngle);
                        float[] kernel = (float[])rotatedPatch.getPixels();
                        ImageProcessor ip = channels[ch].getProcessor().duplicate();
                        c.convolveFloat(ip, kernel, patchSize, patchSize);
                        is.addSlice("Membrane_" + patchSize + "_" + membraneSize, ip);
                    }
                    ImagePlus projectStack = new ImagePlus("membraneStack", is);
                    ImageStack membraneStack = new ImageStack(width, height);
                    ZProjector zp = new ZProjector(projectStack);
                    zp.setStopSlice(is.getSize());
                    for (int i = 0; i < 6; ++i) {
                        zp.setMethod(i);
                        zp.doProjection();
                        membraneStack.addSlice(availableFeatures[4] + "_" + i + "_" + patchSize + "_" + membraneSize, zp.getProjection().getChannelProcessor());
                    }
                    results[ch] = new ImagePlus("membrane stack", membraneStack);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    ImagePlus[] extractChannels(ImagePlus originalImage) {
        ImagePlus[] channels;
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        if (originalImage.getType() == 4) {
            ByteProcessor redBp = new ByteProcessor(width, height);
            ByteProcessor greenBp = new ByteProcessor(width, height);
            ByteProcessor blueBp = new ByteProcessor(width, height);
            byte[] redPixels = (byte[])redBp.getPixels();
            byte[] greenPixels = (byte[])greenBp.getPixels();
            byte[] bluePixels = (byte[])blueBp.getPixels();
            ((ColorProcessor)originalImage.getProcessor().duplicate()).getRGB(redPixels, greenPixels, bluePixels);
            channels = new ImagePlus[]{new ImagePlus("red", redBp.convertToFloat()), new ImagePlus("green", greenBp.convertToFloat()), new ImagePlus("blue", blueBp.convertToFloat())};
        } else {
            channels = new ImagePlus[]{new ImagePlus(originalImage.getTitle(), originalImage.getProcessor().duplicate().convertToFloat())};
        }
        return channels;
    }

    ImagePlus mergeResultChannels(ImagePlus[] channels) {
        if (channels.length > 1) {
            ImageStack mergedColorStack = this.mergeStacks(channels[0].getImageStack(), channels[1].getImageStack(), channels[2].getImageStack());
            ImagePlus merged = new ImagePlus(channels[0].getTitle(), mergedColorStack);
            for (int n = 1; n <= merged.getImageStackSize(); ++n) {
                merged.getImageStack().setSliceLabel(channels[0].getImageStack().getSliceLabel(n), n);
            }
            return merged;
        }
        return channels[0];
    }

    ImageStack mergeStacks(ImageStack redChannel, ImageStack greenChannel, ImageStack blueChannel) {
        ImageStack colorStack = new ImageStack(redChannel.getWidth(), redChannel.getHeight());
        for (int n = 1; n <= redChannel.getSize(); ++n) {
            ByteProcessor red = (ByteProcessor)redChannel.getProcessor(n).convertToByte(false);
            ByteProcessor green = (ByteProcessor)greenChannel.getProcessor(n).convertToByte(false);
            ByteProcessor blue = (ByteProcessor)blueChannel.getProcessor(n).convertToByte(false);
            ColorProcessor cp = new ColorProcessor(redChannel.getWidth(), redChannel.getHeight());
            cp.setRGB((byte[])red.getPixels(), (byte[])green.getPixels(), (byte[])blue.getPixels());
            colorStack.addSlice(redChannel.getSliceLabel(n), (ImageProcessor)cp);
        }
        return colorStack;
    }

    public Callable<ImagePlus> getFilter(final ImagePlus originalImage, final ImageProcessor filter, final String title) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                int patchSize = filter.getWidth();
                Convolver c = new Convolver();
                float[] kernel = (float[])filter.getPixels();
                ImageProcessor ip = originalImage.getProcessor().duplicate();
                c.convolveFloat(ip, kernel, patchSize, patchSize);
                return new ImagePlus(title, ip);
            }
        };
    }

    public Callable<ImagePlus> getDerivatives(final ImagePlus originalImage, final double sigma, final int xOrder, final int yOrder) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = ImageScience.computeDerivativeImage(sigma, xOrder, yOrder, channels[ch]);
                }
                ImagePlus newimp = FeatureStack.this.mergeResultChannels(results);
                return new ImagePlus(availableFeatures[15] + "_" + xOrder + "_" + yOrder + "_" + sigma, newimp.getProcessor());
            }
        };
    }

    public void addDerivatives(double sigma, int xOrder, int yOrder) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            results[ch] = ImageScience.computeDerivativeImage(sigma, xOrder, yOrder, channels[ch]);
        }
        ImagePlus newimp = this.mergeResultChannels(results);
        this.wholeStack.addSlice(availableFeatures[15] + "_" + xOrder + "_" + yOrder + "_" + sigma, newimp.getProcessor());
    }

    public Callable<ImagePlus> getLaplacian(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = ImageScience.computeLaplacianImage(sigma, channels[ch]);
                }
                ImagePlus newimp = FeatureStack.this.mergeResultChannels(results);
                return new ImagePlus(availableFeatures[16] + "_" + sigma, newimp.getProcessor());
            }
        };
    }

    public void addLaplacian(double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ImagePlus[] channels = this.extractChannels(this.originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            results[ch] = ImageScience.computeLaplacianImage(sigma, channels[ch]);
        }
        ImagePlus newimp = this.mergeResultChannels(results);
        this.wholeStack.addSlice(availableFeatures[16] + "_" + sigma, newimp.getProcessor());
    }

    public Callable<ImagePlus> getStructure(final ImagePlus originalImage, final double sigma, final double integrationScale) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                return FeatureStack.this.computeStructure(originalImage, sigma, integrationScale);
            }
        };
    }

    public void addStructure(double sigma, double integrationScale) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ImagePlus merged = this.computeStructure(this.originalImage, sigma, integrationScale);
        this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(1), merged.getImageStack().getProcessor(1));
        this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(2), merged.getImageStack().getProcessor(2));
    }

    public Callable<ImagePlus> getGabor(final ImagePlus originalImage, final double sigma, final double gamma, final double psi, final double frequency, final int nAngles, final ExecutorService exec) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                int largerSigma;
                int width = originalImage.getWidth();
                int height = originalImage.getHeight();
                double sigma_x = sigma;
                double sigma_y = sigma / gamma;
                int n = largerSigma = sigma_x > sigma_y ? (int)sigma_x : (int)sigma_y;
                if (largerSigma < 1) {
                    largerSigma = 1;
                }
                int filterSizeX = 6 * largerSigma + 1;
                int filterSizeY = 6 * largerSigma + 1;
                int middleX = Math.round(filterSizeX / 2);
                int middleY = Math.round(filterSizeY / 2);
                ImageStack kernels = new ImageStack(filterSizeX, filterSizeY);
                double rotationAngle = Math.PI / (double)nAngles;
                double sigma_x2 = sigma_x * sigma_x;
                double sigma_y2 = sigma_y * sigma_y;
                for (int i = 0; i < nAngles; ++i) {
                    double theta = rotationAngle * (double)i;
                    FloatProcessor filter = new FloatProcessor(filterSizeX, filterSizeY);
                    for (int x = -middleX; x <= middleX; ++x) {
                        for (int y = -middleY; y <= middleY; ++y) {
                            double xPrime = (double)x * Math.cos(theta) + (double)y * Math.sin(theta);
                            double yPrime = (double)y * Math.cos(theta) - (double)x * Math.sin(theta);
                            double a = 1.0 / (Math.PI * 2 * sigma_x * sigma_y) * Math.exp(-0.5 * (xPrime * xPrime / sigma_x2 + yPrime * yPrime / sigma_y2));
                            double c = Math.cos(Math.PI * 2 * (frequency * xPrime) / (double)filterSizeX + psi);
                            filter.setf(x + middleX, y + middleY, (float)(a * c));
                        }
                    }
                    kernels.addSlice("kernel angle = " + i, (ImageProcessor)filter);
                }
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageStack is = new ImageStack(width, height);
                    for (int i = 0; i < nAngles; ++i) {
                        ImagePlus ip2 = channels[ch].duplicate();
                        ImagePlusImg kernel = ImagePlusAdapter.wrap((ImagePlus)new ImagePlus("", kernels.getProcessor(i + 1)));
                        ImagePlusImg image2 = ImagePlusAdapter.wrap((ImagePlus)ip2);
                        FFTConvolution c = new FFTConvolution((Img)image2, (Img)kernel, exec);
                        c.convolve();
                        ip2 = ImageJFunctions.wrap((RandomAccessibleInterval)image2, (String)"");
                        is.addSlice("gabor angle = " + i, ip2.getProcessor());
                    }
                    ImagePlus projectStack = new ImagePlus("filtered stack", Utils.normalize(is));
                    ImageStack resultStack = new ImageStack(width, height);
                    ZProjector zp = new ZProjector(projectStack);
                    zp.setStopSlice(is.getSize());
                    for (int i = 1; i <= 2; ++i) {
                        zp.setMethod(i);
                        zp.doProjection();
                        resultStack.addSlice(availableFeatures[14] + "_" + i + "_" + sigma + "_" + gamma + "_" + (int)(psi / 0.7853981633974483) + "_" + frequency, zp.getProjection().getChannelProcessor());
                    }
                    results[ch] = new ImagePlus("Gabor stack", resultStack);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addGabor(ImagePlus originalImage, double sigma, double gamma, double psi, double frequency, int nAngles) {
        int largerSigma;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        double sigma_x = sigma;
        double sigma_y = sigma / gamma;
        int n = largerSigma = sigma_x > sigma_y ? (int)sigma_x : (int)sigma_y;
        if (largerSigma < 1) {
            largerSigma = 1;
        }
        int filterSizeX = 6 * largerSigma + 1;
        int filterSizeY = 6 * largerSigma + 1;
        int middleX = Math.round(filterSizeX / 2);
        int middleY = Math.round(filterSizeY / 2);
        ImageStack kernels = new ImageStack(filterSizeX, filterSizeY);
        double rotationAngle = Math.PI / (double)nAngles;
        double sigma_x2 = sigma_x * sigma_x;
        double sigma_y2 = sigma_y * sigma_y;
        for (int i = 0; i < nAngles; ++i) {
            double theta = rotationAngle * (double)i;
            FloatProcessor filter = new FloatProcessor(filterSizeX, filterSizeY);
            for (int x = -middleX; x <= middleX; ++x) {
                for (int y = -middleY; y <= middleY; ++y) {
                    double xPrime = (double)x * Math.cos(theta) + (double)y * Math.sin(theta);
                    double yPrime = (double)y * Math.cos(theta) - (double)x * Math.sin(theta);
                    double a = 1.0 / (Math.PI * 2 * sigma_x * sigma_y) * Math.exp(-0.5 * (xPrime * xPrime / sigma_x2 + yPrime * yPrime / sigma_y2));
                    double c = Math.cos(Math.PI * 2 * (frequency * xPrime) / (double)filterSizeX + psi);
                    filter.setf(x + middleX, y + middleY, (float)(a * c));
                }
            }
            kernels.addSlice("kernel angle = " + i, (ImageProcessor)filter);
        }
        ImagePlus[] channels = this.extractChannels(originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageStack is = new ImageStack(width, height);
            for (int i = 0; i < nAngles; ++i) {
                ImagePlus ip2 = channels[ch].duplicate();
                ImagePlusImg kernel = ImagePlusAdapter.wrap((ImagePlus)new ImagePlus("", kernels.getProcessor(i + 1)));
                ImagePlusImg image2 = ImagePlusAdapter.wrap((ImagePlus)ip2);
                FFTConvolution c = new FFTConvolution((Img)image2, (Img)kernel);
                c.convolve();
                ip2 = ImageJFunctions.wrap((RandomAccessibleInterval)image2, (String)"");
                is.addSlice("gabor angle = " + i, ip2.getProcessor());
            }
            ImagePlus projectStack = new ImagePlus("filtered stack", Utils.normalize(is));
            ImageStack resultStack = new ImageStack(width, height);
            ZProjector zp = new ZProjector(projectStack);
            zp.setStopSlice(is.getSize());
            for (int i = 1; i <= 2; ++i) {
                zp.setMethod(i);
                zp.doProjection();
                resultStack.addSlice(availableFeatures[14] + "_" + i + "_" + sigma + "_" + gamma + "_" + (int)(psi / 0.7853981633974483) + "_" + frequency, zp.getProjection().getChannelProcessor());
            }
            results[ch] = new ImagePlus("Gabor stack", resultStack);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        for (int i = 1; i <= merged.getImageStackSize(); ++i) {
            this.wholeStack.addSlice(merged.getImageStack().getSliceLabel(i), merged.getImageStack().getPixels(i));
        }
    }

    public Callable<ImagePlus> getKuwaharaFeatures(final ImagePlus originalImage, final int kernelSize, final int nAngles, final int criterion) {
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageProcessor ip = channels[ch].getProcessor().duplicate();
                    Kuwahara filter = new Kuwahara();
                    filter.applyFilter(ip, kernelSize, nAngles, criterion);
                    results[ch] = new ImagePlus(availableFeatures[13] + "_" + kernelSize + "_ " + nAngles + "_" + criterion, ip);
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addKuwaharaFeatures(ImagePlus originalImage, int kernelSize, int nAngles, int criterion) {
        ImagePlus[] channels = this.extractChannels(originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageProcessor ip = channels[ch].getProcessor().duplicate();
            Kuwahara filter = new Kuwahara();
            filter.applyFilter(ip, kernelSize, nAngles, criterion);
            results[ch] = new ImagePlus(availableFeatures[13] + "_" + kernelSize + "_ " + nAngles + "_" + criterion, ip);
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getProcessor());
    }

    public Callable<ImagePlus> getAnisotropicDiffusion(final ImagePlus originalImage, final int nb_iter, final int saveSteps, final int nb_smoothings, final float a1, final float a2, final float edgeThreshold) {
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                Anisotropic_Diffusion_2D ad = new Anisotropic_Diffusion_2D();
                ad.setup("", originalImage);
                ad.setSaveSteps(saveSteps);
                ad.setNumOfIterations(nb_iter);
                ad.setLimiterMinimalVariations(a1);
                ad.setLimiterMaximalVariations(a2);
                ad.setSmoothings(nb_smoothings);
                ad.setEdgeThreshold(edgeThreshold);
                ImagePlus result = ad.runTD(originalImage.getProcessor());
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                if (result.getImageStackSize() == 1) {
                    return new ImagePlus(availableFeatures[10] + "_" + nb_iter + "_" + nb_smoothings + "_" + a1 + "_" + a2 + "_" + edgeThreshold, result.getProcessor());
                }
                ImageStack slices = result.getImageStack();
                slices.deleteSlice(1);
                for (int i = 1; i <= slices.getSize(); ++i) {
                    slices.setSliceLabel(availableFeatures[10] + "_" + saveSteps * i + "_" + nb_smoothings + "_" + a1 + "_" + a2 + "_" + edgeThreshold, i);
                }
                return new ImagePlus("Anisotropic diffusion", slices);
            }
        };
    }

    public void addAnisotropicDiffusion(ImagePlus originalImage, int nb_iter, int saveSteps, int nb_smoothings, float a1, float a2, float edgeThreshold) {
        Anisotropic_Diffusion_2D ad = new Anisotropic_Diffusion_2D();
        ad.setup("", originalImage);
        ad.setSaveSteps(saveSteps);
        ad.setNumOfIterations(nb_iter);
        ad.setLimiterMinimalVariations(a1);
        ad.setLimiterMaximalVariations(a2);
        ad.setSmoothings(nb_smoothings);
        ad.setEdgeThreshold(edgeThreshold);
        ImagePlus result = ad.runTD(originalImage.getProcessor());
        if (result.getImageStackSize() == 1) {
            this.wholeStack.addSlice(availableFeatures[10] + "_" + nb_iter + "_" + nb_smoothings + "_" + a1 + "_" + a2 + "_" + edgeThreshold, result.getProcessor());
        } else {
            ImageStack slices = result.getImageStack();
            slices.deleteSlice(1);
            for (int i = 1; i <= slices.getSize(); ++i) {
                this.wholeStack.addSlice(availableFeatures[10] + "_" + saveSteps * i + "_" + nb_smoothings + "_" + a1 + "_" + a2 + "_" + edgeThreshold, slices.getProcessor(i));
            }
        }
    }

    public Callable<ImagePlus> getBilateralFilter(final ImagePlus originalImage, final double spatialRadius, final double rangeRadius) {
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImagePlus result = BilateralFilter.filter((ImagePlus)new ImagePlus("", channels[ch].getProcessor().convertToByte(true)), (double)spatialRadius, (double)rangeRadius);
                    results[ch] = new ImagePlus(availableFeatures[11] + "_" + spatialRadius + "_" + rangeRadius, result.getProcessor().convertToFloat());
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addBilateralFilter(ImagePlus originalImage, double spatialRadius, double rangeRadius) {
        ImagePlus[] channels = this.extractChannels(originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImagePlus result = BilateralFilter.filter((ImagePlus)new ImagePlus("", channels[ch].getProcessor().convertToByte(true)), (double)spatialRadius, (double)rangeRadius);
            results[ch] = new ImagePlus(availableFeatures[11] + "_" + spatialRadius + "_" + rangeRadius, result.getProcessor().convertToFloat());
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getImageStack().getProcessor(1));
    }

    public Callable<ImagePlus> getLipschitzFilter(final ImagePlus originalImage, final boolean downHat, final boolean topHat, final double slope) {
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                Lipschitz_ filter = new Lipschitz_();
                filter.setDownHat(downHat);
                filter.setTopHat(topHat);
                filter.m_Slope = slope;
                ImagePlus[] channels = FeatureStack.this.extractChannels(originalImage);
                ImagePlus[] results = new ImagePlus[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    ImageProcessor result = channels[ch].getProcessor().duplicate().convertToByte(true);
                    filter.Lipschitz2D(result);
                    results[ch] = new ImagePlus(availableFeatures[12] + "_" + downHat + "_" + topHat + "_" + slope, result.convertToFloat());
                }
                return FeatureStack.this.mergeResultChannels(results);
            }
        };
    }

    public void addLipschitzFilter(ImagePlus originalImage, boolean downHat, boolean topHat, double slope) {
        Lipschitz_ filter = new Lipschitz_();
        filter.setDownHat(downHat);
        filter.setTopHat(topHat);
        filter.m_Slope = slope;
        ImagePlus[] channels = this.extractChannels(originalImage);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ImageProcessor result = channels[ch].getProcessor().duplicate().convertToByte(true);
            filter.Lipschitz2D(result);
            results[ch] = new ImagePlus(availableFeatures[12] + "_" + downHat + "_" + topHat + "_" + slope, result.convertToFloat());
        }
        ImagePlus merged = this.mergeResultChannels(results);
        this.wholeStack.addSlice(merged.getTitle(), merged.getImageStack().getProcessor(1));
    }

    public ImageProcessor getProcessor(int index) {
        return this.wholeStack.getProcessor(index);
    }

    public Instances createInstances(ArrayList<String> classes) {
        int i;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (this.oldColorFormat) {
            IJ.log((String)"Using old color format...");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (i = 1; i <= this.wholeStack.getSize(); ++i) {
            String attString = this.wholeStack.getSliceLabel(i);
            attributes.add(new Attribute(attString));
        }
        if (this.useNeighborhood()) {
            for (i = 0; i < 8; ++i) {
                IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
            }
        }
        attributes.add(new Attribute("class", classes));
        Instances data = new Instances("segment", attributes, this.width * this.height);
        for (int y = 0; y < this.wholeStack.getHeight(); ++y) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            IJ.showProgress((int)y, (int)this.wholeStack.getHeight());
            for (int x = 0; x < this.wholeStack.getWidth(); ++x) {
                data.add((Instance)this.createInstance(x, y, 0));
            }
        }
        data.setClassIndex(attributes.size() - 1);
        IJ.showProgress((double)1.0);
        return data;
    }

    public void addDefaultFeatures() {
        int counter = 1;
        for (float i = 1.0f; i < this.maximumSigma; i *= 2.0f) {
            IJ.showStatus((String)("Creating feature stack...   " + counter));
            this.addGaussianBlur(i);
            IJ.showStatus((String)("Creating feature stack...   " + ++counter));
            this.addGradient(i);
            IJ.showStatus((String)("Creating feature stack...   " + ++counter));
            this.addHessian(i);
            ++counter;
            for (float j = 1.0f; j < i; j *= 2.0f) {
                IJ.showStatus((String)("Creating feature stack...   " + counter));
                this.addDoG(i, j);
                ++counter;
            }
        }
        this.addMembraneFeatures(19, 1);
        IJ.showProgress((double)1.0);
    }

    public void updateFeatures() {
        float i;
        this.wholeStack = new ImageStack(this.width, this.height);
        if (this.originalImage.getType() == 4) {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate());
            this.addHSB();
        } else {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate().convertToFloat());
        }
        if (this.enableFeatures[10]) {
            for (i = this.minimumSigma; i <= this.maximumSigma; i *= 2.0f) {
                for (float j = 0.1f; j < 0.5f; j += 0.25f) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    this.addAnisotropicDiffusion(this.originalImage, 20, 20, (int)i, j, 0.9f, this.membraneSize);
                }
            }
        }
        if (this.enableFeatures[11]) {
            for (double i2 = 5.0; i2 < 20.0; i2 *= 2.0) {
                for (double j = 50.0; j <= 100.0; j *= 2.0) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    this.addBilateralFilter(this.originalImage, i2, j);
                }
            }
        }
        if (this.enableFeatures[12]) {
            for (double i3 = 5.0; i3 < 30.0; i3 += 5.0) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.addLipschitzFilter(this.originalImage, true, true, i3);
            }
        }
        if (this.enableFeatures[13]) {
            for (int i4 = 0; i4 < 3; ++i4) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.addKuwaharaFeatures(this.originalImage, this.membranePatchSize, this.nAngles, i4);
            }
        }
        if (this.enableFeatures[14]) {
            int i5;
            for (i5 = 0; i5 < 2; ++i5) {
                for (double gamma = 1.0; gamma >= 0.25; gamma /= 2.0) {
                    for (int frequency = 2; frequency < 3; ++frequency) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        double psi = 1.5707963267948966 * (double)i5;
                        this.addGabor(this.originalImage, 1.0, gamma, psi, frequency, this.nAngles);
                    }
                }
            }
            for (i5 = 0; i5 < 2; ++i5) {
                for (double sigma = 2.0; sigma <= 4.0; sigma *= 2.0) {
                    for (double gamma = 1.0; gamma <= 2.0; gamma *= 2.0) {
                        for (int frequency = 2; frequency <= 3; ++frequency) {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            double psi = 1.5707963267948966 * (double)i5;
                            this.addGabor(this.originalImage, sigma, gamma, psi, frequency, this.nAngles);
                        }
                    }
                }
            }
        }
        if (this.enableFeatures[1]) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.addGradient(0.0f);
        }
        if (this.enableFeatures[2]) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.addHessian(0.0f);
        }
        for (i = this.minimumSigma; i <= this.maximumSigma; i *= 2.0f) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.enableFeatures[0]) {
                this.addGaussianBlur(i);
            }
            if (this.enableFeatures[1]) {
                this.addGradient(i);
            }
            if (this.enableFeatures[2]) {
                this.addHessian(i);
            }
            if (this.enableFeatures[3]) {
                for (float j = this.minimumSigma; j < i; j *= 2.0f) {
                    this.addDoG(i, j);
                }
            }
            if (this.enableFeatures[5]) {
                this.addVariance(i);
            }
            if (this.enableFeatures[6]) {
                this.addMean(i);
            }
            if (this.enableFeatures[7]) {
                this.addMin(i);
            }
            if (this.enableFeatures[8]) {
                this.addMax(i);
            }
            if (this.enableFeatures[9]) {
                this.addMedian(i);
            }
            if (this.enableFeatures[15]) {
                for (int order = this.minDerivativeOrder; order <= this.maxDerivativeOrder; ++order) {
                    this.addDerivatives(i, order, order);
                }
            }
            if (this.enableFeatures[16]) {
                this.addLaplacian(i);
            }
            if (!this.enableFeatures[17]) continue;
            for (int integrationScale = 1; integrationScale <= 3; integrationScale += 2) {
                this.addStructure(i, integrationScale);
            }
        }
        if (this.enableFeatures[4]) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.addMembraneFeatures(this.membranePatchSize, this.membraneSize);
        }
        if (this.enableFeatures[19]) {
            this.addNeighbors((int)this.minimumSigma, (int)this.maximumSigma);
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Features stack is updated now!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addFeaturesMT(ImagePlus filterList) {
        this.exe = Executors.newFixedThreadPool(Prefs.getThreads());
        this.wholeStack = new ImageStack(this.width, this.height);
        ArrayList<Future<ImagePlus>> futures = new ArrayList<Future<ImagePlus>>();
        try {
            for (int i = 1; i <= filterList.getStackSize(); ++i) {
                void var4_6;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                String string = filterList.getImageStack().getSliceLabel(i);
                if (null == string || string.equals("")) {
                    String string2 = new String("filter-" + i);
                }
                futures.add(this.exe.submit(this.getFilter(this.originalImage, filterList.getImageStack().getProcessor(i), (String)var4_6)));
            }
            for (Future future : futures) {
                ImagePlus res = (ImagePlus)future.get();
                if (res.getImageStackSize() == 1) {
                    this.wholeStack.addSlice(res.getTitle(), res.getProcessor());
                    continue;
                }
                ImageStack slices = res.getImageStack();
                for (int i = 1; i <= slices.getSize(); ++i) {
                    this.wholeStack.addSlice(slices.getSliceLabel(i), slices.getProcessor(i));
                }
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating feature stack.");
            ex.printStackTrace();
        }
        finally {
            this.exe.shutdown();
        }
    }

    public boolean updateFeaturesST() {
        float i;
        this.wholeStack = new ImageStack(this.width, this.height);
        if (this.originalImage.getType() == 4) {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate());
            this.addHSB();
        } else {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate().convertToFloat());
        }
        if (this.enableFeatures[10]) {
            for (i = this.minimumSigma; i <= this.maximumSigma; i *= 2.0f) {
                for (float j = 0.1f; j < 0.5f; j += 0.25f) {
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    this.addAnisotropicDiffusion(this.originalImage, 20, 20, (int)i, j, 0.9f, this.membraneSize);
                }
            }
        }
        if (this.enableFeatures[11]) {
            for (double i2 = 5.0; i2 < 20.0; i2 *= 2.0) {
                for (double j = 50.0; j <= 100.0; j *= 2.0) {
                    if (Thread.currentThread().isInterrupted()) {
                        return false;
                    }
                    this.addBilateralFilter(this.originalImage, i2, j);
                }
            }
        }
        if (this.enableFeatures[12]) {
            for (double i3 = 5.0; i3 < 30.0; i3 += 5.0) {
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                this.addLipschitzFilter(this.originalImage, true, true, i3);
            }
        }
        if (this.enableFeatures[13]) {
            for (int i4 = 0; i4 < 3; ++i4) {
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                this.addKuwaharaFeatures(this.originalImage, this.membranePatchSize, this.nAngles, i4);
            }
        }
        if (this.enableFeatures[14]) {
            int i5;
            for (i5 = 0; i5 < 2; ++i5) {
                for (double gamma = 1.0; gamma >= 0.25; gamma /= 2.0) {
                    for (int frequency = 2; frequency < 3; ++frequency) {
                        if (Thread.currentThread().isInterrupted()) {
                            return false;
                        }
                        double psi = 1.5707963267948966 * (double)i5;
                        this.addGabor(this.originalImage, 1.0, gamma, psi, frequency, this.nAngles);
                    }
                }
            }
            for (i5 = 0; i5 < 2; ++i5) {
                for (double sigma = 2.0; sigma <= 4.0; sigma *= 2.0) {
                    for (double gamma = 1.0; gamma <= 2.0; gamma *= 2.0) {
                        for (int frequency = 2; frequency <= 3; ++frequency) {
                            if (Thread.currentThread().isInterrupted()) {
                                return false;
                            }
                            double psi = 1.5707963267948966 * (double)i5;
                            this.addGabor(this.originalImage, sigma, gamma, psi, frequency, this.nAngles);
                        }
                    }
                }
            }
        }
        if (this.enableFeatures[1] && this.minimumSigma < 2.0f) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            this.addGradient(0.0f);
        }
        if (this.enableFeatures[2] && this.minimumSigma < 2.0f) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            this.addHessian(0.0f);
        }
        for (i = this.minimumSigma; i <= this.maximumSigma; i *= 2.0f) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (this.enableFeatures[0]) {
                this.addGaussianBlur(i);
            }
            if (this.enableFeatures[1]) {
                this.addGradient(i);
            }
            if (this.enableFeatures[2]) {
                this.addHessian(i);
            }
            if (this.enableFeatures[3]) {
                for (float j = this.minimumSigma; j < i; j *= 2.0f) {
                    this.addDoG(i, j);
                }
            }
            if (this.enableFeatures[5]) {
                this.addVariance(i);
            }
            if (this.enableFeatures[6]) {
                this.addMean(i);
            }
            if (this.enableFeatures[7]) {
                this.addMin(i);
            }
            if (this.enableFeatures[8]) {
                this.addMax(i);
            }
            if (this.enableFeatures[9]) {
                this.addMedian(i);
            }
            if (this.enableFeatures[15]) {
                for (int order = this.minDerivativeOrder; order <= this.maxDerivativeOrder; ++order) {
                    this.addDerivatives(i, order, order);
                }
            }
            if (this.enableFeatures[16]) {
                this.addLaplacian(i);
            }
            if (this.enableFeatures[17]) {
                for (int integrationScale = 1; integrationScale <= 3; integrationScale += 2) {
                    this.addStructure(i, integrationScale);
                }
            }
            if (!this.enableFeatures[18]) continue;
            for (int nBins = 32; nBins <= 256; nBins *= 2) {
                this.addEntropy((int)i, nBins);
            }
        }
        if (this.enableFeatures[4]) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            this.addMembraneFeatures(this.membranePatchSize, this.membraneSize);
        }
        if (this.enableFeatures[19]) {
            this.addNeighbors((int)this.minimumSigma, (int)this.maximumSigma);
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Features stack is updated now!");
        return true;
    }

    public void addHSB() {
        ImagePlus hsb = this.originalImage.duplicate();
        ImageConverter ic = new ImageConverter(hsb);
        ic.convertToHSB();
        for (int n = 1; n <= hsb.getImageStackSize(); ++n) {
            this.wholeStack.addSlice(hsb.getImageStack().getSliceLabel(n), hsb.getImageStack().getProcessor(n).convertToRGB());
        }
    }

    public Callable<ImagePlus> getHSB(final ImagePlus originalImage) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                ImagePlus hsb = originalImage.duplicate();
                ImageConverter ic = new ImageConverter(hsb);
                ic.convertToHSB();
                ImageStack is = new ImageStack(originalImage.getWidth(), originalImage.getHeight());
                for (int n = 1; n <= hsb.getImageStackSize(); ++n) {
                    is.addSlice(hsb.getImageStack().getSliceLabel(n), hsb.getImageStack().getProcessor(n).convertToRGB());
                }
                return new ImagePlus("HSB", is);
            }
        };
    }

    public boolean updateFeaturesMT() {
        return this.updateFeaturesMT(Prefs.getThreads());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean updateFeaturesMT(int numThreads) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        this.exe = Executors.newFixedThreadPool(numThreads);
        this.wholeStack = new ImageStack(this.width, this.height);
        if (this.originalImage.getType() == 4) {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate());
        } else {
            this.wholeStack.addSlice("original", this.originalImage.getProcessor().duplicate().convertToFloat());
        }
        int finalIndex = 0;
        for (int i = 0; i < this.enableFeatures.length; ++i) {
            if (!this.enableFeatures[i]) continue;
            ++finalIndex;
        }
        ArrayList<Future<ImagePlus>> futures = new ArrayList<Future<ImagePlus>>();
        int currentIndex = 0;
        IJ.showStatus((String)"Updating features...");
        try {
            if (this.enableFeatures[10]) {
                for (float i = this.minimumSigma; i <= this.maximumSigma; i *= 2.0f) {
                    for (float f = 0.1f; f < 0.5f; f += 0.25f) {
                        if (Thread.currentThread().isInterrupted()) {
                            boolean bl = false;
                            return bl;
                        }
                        futures.add(this.exe.submit(this.getAnisotropicDiffusion(this.originalImage, 20, 20, (int)i, f, 0.9f, this.membraneSize)));
                    }
                }
            }
            if (this.originalImage.getType() == 4) {
                futures.add(this.exe.submit(this.getHSB(this.originalImage)));
            }
            if (this.enableFeatures[11]) {
                for (double i2 = 5.0; i2 < 20.0; i2 *= 2.0) {
                    for (double j = 50.0; j <= 100.0; j *= 2.0) {
                        if (Thread.currentThread().isInterrupted()) {
                            boolean bl = false;
                            return bl;
                        }
                        futures.add(this.exe.submit(this.getBilateralFilter(this.originalImage, i2, j)));
                    }
                }
            }
            if (this.enableFeatures[12]) {
                for (double i3 = 5.0; i3 < 30.0; i3 += 5.0) {
                    if (Thread.currentThread().isInterrupted()) {
                        boolean j = false;
                        return j;
                    }
                    futures.add(this.exe.submit(this.getLipschitzFilter(this.originalImage, true, true, i3)));
                }
            }
            if (this.enableFeatures[13]) {
                for (int i4 = 0; i4 < 3; ++i4) {
                    if (Thread.currentThread().isInterrupted()) {
                        boolean bl = false;
                        return bl;
                    }
                    futures.add(this.exe.submit(this.getKuwaharaFeatures(this.originalImage, this.membranePatchSize, this.nAngles, i4)));
                }
            }
            if (this.enableFeatures[14]) {
                for (int i5 = 0; i5 < 2; ++i5) {
                    for (double d = 1.0; d >= 0.25; d /= 2.0) {
                        for (int frequency = 2; frequency < 3; ++frequency) {
                            if (Thread.currentThread().isInterrupted()) {
                                boolean bl = false;
                                return bl;
                            }
                            double psi = 1.5707963267948966 * (double)i5;
                            ImagePlus res = this.exe.submit(this.getGabor(this.originalImage, 1.0, d, psi, frequency, this.nAngles, this.exe)).get();
                            IJ.showStatus((String)"Updating features...");
                            IJ.showProgress((int)(++currentIndex), (int)finalIndex);
                            if (res.getImageStackSize() == 1) {
                                this.wholeStack.addSlice(res.getTitle(), res.getProcessor());
                                continue;
                            }
                            ImageStack slices = res.getImageStack();
                            for (int s = 1; s <= slices.getSize(); ++s) {
                                this.wholeStack.addSlice(slices.getSliceLabel(s), slices.getProcessor(s));
                            }
                        }
                    }
                }
                for (int i6 = 0; i6 < 2; ++i6) {
                    for (double d = 2.0; d <= 4.0; d *= 2.0) {
                        for (double gamma = 1.0; gamma <= 2.0; gamma *= 2.0) {
                            for (int frequency = 2; frequency <= 3; ++frequency) {
                                if (Thread.currentThread().isInterrupted()) {
                                    boolean res = false;
                                    return res;
                                }
                                double psi = 1.5707963267948966 * (double)i6;
                                ImagePlus res = this.exe.submit(this.getGabor(this.originalImage, d, gamma, psi, frequency, this.nAngles, this.exe)).get();
                                IJ.showStatus((String)"Updating features...");
                                IJ.showProgress((int)(++currentIndex), (int)finalIndex);
                                if (res.getImageStackSize() == 1) {
                                    this.wholeStack.addSlice(res.getTitle(), res.getProcessor());
                                    continue;
                                }
                                ImageStack slices = res.getImageStack();
                                for (int s = 1; s <= slices.getSize(); ++s) {
                                    this.wholeStack.addSlice(slices.getSliceLabel(s), slices.getProcessor(s));
                                }
                            }
                        }
                    }
                }
            }
            if (this.enableFeatures[1] && this.minimumSigma < 2.0f) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean i6 = false;
                    return i6;
                }
                futures.add(this.exe.submit(this.getGradient(this.originalImage, 0.0f)));
            }
            if (this.enableFeatures[2] && this.minimumSigma < 2.0f) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean i6 = false;
                    return i6;
                }
                futures.add(this.exe.submit(this.getHessian(this.originalImage, 0.0f)));
            }
            for (float i7 = this.minimumSigma; i7 <= this.maximumSigma; i7 *= 2.0f) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.enableFeatures[0]) {
                    futures.add(this.exe.submit(this.getGaussianBlur(this.originalImage, i7)));
                }
                if (this.enableFeatures[1]) {
                    futures.add(this.exe.submit(this.getGradient(this.originalImage, i7)));
                }
                if (this.enableFeatures[2]) {
                    futures.add(this.exe.submit(this.getHessian(this.originalImage, i7)));
                }
                if (this.enableFeatures[3]) {
                    for (float f = this.minimumSigma; f < i7; f *= 2.0f) {
                        futures.add(this.exe.submit(this.getDoG(this.originalImage, i7, f)));
                    }
                }
                if (this.enableFeatures[5]) {
                    futures.add(this.exe.submit(this.getVariance(this.originalImage, i7)));
                }
                if (this.enableFeatures[6]) {
                    futures.add(this.exe.submit(this.getMean(this.originalImage, i7)));
                }
                if (this.enableFeatures[7]) {
                    futures.add(this.exe.submit(this.getMin(this.originalImage, i7)));
                }
                if (this.enableFeatures[8]) {
                    futures.add(this.exe.submit(this.getMax(this.originalImage, i7)));
                }
                if (this.enableFeatures[9]) {
                    futures.add(this.exe.submit(this.getMedian(this.originalImage, i7)));
                }
                if (this.enableFeatures[15]) {
                    void var6_25;
                    int n = this.minDerivativeOrder;
                    while (var6_25 <= this.maxDerivativeOrder) {
                        futures.add(this.exe.submit(this.getDerivatives(this.originalImage, i7, (int)var6_25, (int)var6_25)));
                        ++var6_25;
                    }
                }
                if (this.enableFeatures[16]) {
                    futures.add(this.exe.submit(this.getLaplacian(this.originalImage, i7)));
                }
                if (this.enableFeatures[17]) {
                    void var6_27;
                    boolean bl = true;
                    while (var6_27 <= 3) {
                        futures.add(this.exe.submit(this.getStructure(this.originalImage, i7, (double)var6_27)));
                        var6_27 += 2;
                    }
                }
                if (!this.enableFeatures[18]) continue;
                int bl = 32;
                while (bl <= 256) {
                    futures.add(this.exe.submit(this.getEntropy(this.originalImage, (int)i7, (int)bl)));
                    bl *= 2;
                }
            }
            if (this.enableFeatures[4]) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean i7 = false;
                    return i7;
                }
                futures.add(this.exe.submit(this.getMembraneFeatures(this.originalImage, this.membranePatchSize, this.membraneSize)));
            }
            if (this.enableFeatures[19]) {
                futures.add(this.exe.submit(this.getNeighbors(this.originalImage, (int)this.minimumSigma, (int)this.maximumSigma)));
            }
            for (Future future : futures) {
                ImagePlus res = (ImagePlus)future.get();
                IJ.showStatus((String)"Updating features...");
                IJ.showProgress((int)(++currentIndex), (int)finalIndex);
                if (res.getImageStackSize() == 1) {
                    this.wholeStack.addSlice(res.getTitle(), res.getProcessor());
                    continue;
                }
                ImageStack slices = res.getImageStack();
                for (int i8 = 1; i8 <= slices.getSize(); ++i8) {
                    this.wholeStack.addSlice(slices.getSliceLabel(i8), slices.getProcessor(i8));
                }
            }
        }
        catch (InterruptedException ie) {
            IJ.log((String)"The features udpate was interrupted by the user.");
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating feature stack.");
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.exe.shutdownNow();
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Features stack is updated now!");
        return true;
    }

    public void setEnabledFeatures(boolean[] enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public boolean setEnabledFeature(String featureName, boolean enable) {
        for (int i = 0; i < availableFeatures.length; ++i) {
            if (!featureName.equalsIgnoreCase(availableFeatures[i])) continue;
            this.enableFeatures[i] = enable;
            return true;
        }
        return false;
    }

    public boolean[] getEnabledFeatures() {
        return this.enableFeatures;
    }

    public int getMembraneSize() {
        return this.membraneSize;
    }

    public void setMembraneSize(int membraneSize) {
        this.membraneSize = membraneSize;
    }

    public boolean isEmpty() {
        return null == this.wholeStack || this.wholeStack.getSize() < 2;
    }

    public boolean saveStackAsTiff(String filename) {
        ImagePlus ip = new ImagePlus("feature-stack", this.wholeStack);
        FileSaver fs = new FileSaver(ip);
        return fs.saveAsTiffStack(filename);
    }

    public void removeFeature(String featureName) {
        for (int n = 1; n <= this.wholeStack.getSize(); ++n) {
            if (!featureName.equalsIgnoreCase(this.wholeStack.getSliceLabel(n))) continue;
            this.wholeStack.deleteSlice(n);
            return;
        }
    }

    public void setMinimumSigma(float minSigma) {
        this.minimumSigma = minSigma;
    }

    public void setMaximumSigma(float maxSigma) {
        this.maximumSigma = maxSigma;
    }

    public DenseInstance createInstance(int x, int y, int classValue) {
        int z;
        int extra = this.useNeighbors ? 8 : 0;
        double[] values = new double[this.getSize() + 1 + extra];
        int n = 0;
        if (!this.colorFeatures || this.oldColorFormat) {
            z = 0;
            while (z < this.getSize()) {
                values[z] = this.wholeStack.getVoxel(x, y, z);
                ++z;
                ++n;
            }
        } else {
            z = 0;
            while (z < this.getSize()) {
                int c = (int)this.wholeStack.getVoxel(x, y, z);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                values[z] = (double)(r + g + b) / 3.0;
                ++z;
                ++n;
            }
        }
        if (this.useNeighbors) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    values[n] = this.getPixelMirrorConditions(this.getProcessor(1), x + i, y + j);
                    ++n;
                }
            }
        }
        values[values.length - 1] = classValue;
        return new DenseInstance(1.0, values);
    }

    public DenseInstance createInstance(int x, int y) {
        int z;
        int extra = this.useNeighbors ? 8 : 0;
        double[] values = new double[this.getSize() + extra];
        int n = 0;
        if (!this.colorFeatures || this.oldColorFormat) {
            z = 0;
            while (z < this.getSize()) {
                values[z] = this.wholeStack.getVoxel(x, y, z);
                ++z;
                ++n;
            }
        } else {
            z = 0;
            while (z < this.getSize()) {
                int c = (int)this.wholeStack.getVoxel(x, y, z);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                values[z] = (double)(r + g + b) / 3.0;
                ++z;
                ++n;
            }
        }
        if (this.useNeighbors) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    values[n] = this.getPixelMirrorConditions(this.getProcessor(1), x + i, y + j);
                    ++n;
                }
            }
        }
        return new DenseInstance(1.0, values);
    }

    public void createInstanceInPlace(int x, int y, int classValue, DenseInstance ins) {
        int z;
        if (classValue < 0) {
            IJ.log((String)"Error: negative class value.");
            return;
        }
        int n = 0;
        if (!this.colorFeatures || this.oldColorFormat) {
            z = 0;
            while (z < this.getSize()) {
                ins.setValue(z, this.wholeStack.getVoxel(x, y, z));
                ++z;
                ++n;
            }
        } else {
            z = 0;
            while (z < this.getSize()) {
                int c = (int)this.wholeStack.getVoxel(x, y, z);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                ins.setValue(z, (double)(r + g + b) / 3.0);
                ++z;
                ++n;
            }
        }
        if (this.useNeighbors) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    ins.setValue(n, this.getPixelMirrorConditions(this.getProcessor(1), x + i, y + j));
                    ++n;
                }
            }
        }
        ins.setClassValue((double)classValue);
    }

    public void setInstance(int x, int y, ReusableDenseInstance ins, double[] auxArray) {
        int z;
        int n = 0;
        if (!this.colorFeatures || this.oldColorFormat) {
            z = 0;
            while (z < this.getSize()) {
                auxArray[z] = this.wholeStack.getVoxel(x, y, z);
                ++z;
                ++n;
            }
        } else {
            z = 0;
            while (z < this.getSize()) {
                int c = (int)this.wholeStack.getVoxel(x, y, z);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                auxArray[z] = (double)(r + g + b) / 3.0;
                ++z;
                ++n;
            }
        }
        if (this.useNeighbors) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    auxArray[n] = this.getPixelMirrorConditions(this.getProcessor(1), x + i, y + j);
                    ++n;
                }
            }
        }
        ins.setValues(1.0, auxArray);
    }

    public void setInstance(int x, int y, int classValue, ReusableDenseInstance ins, double[] auxArray) {
        int z;
        int n = 0;
        if (!this.colorFeatures || this.oldColorFormat) {
            z = 0;
            while (z < this.getSize()) {
                auxArray[z] = this.wholeStack.getVoxel(x, y, z);
                ++z;
                ++n;
            }
        } else {
            z = 0;
            while (z < this.getSize()) {
                int c = (int)this.wholeStack.getVoxel(x, y, z);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                auxArray[z] = (double)(r + g + b) / 3.0;
                ++z;
                ++n;
            }
        }
        if (this.useNeighbors) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 && j == 0) continue;
                    auxArray[n] = this.getPixelMirrorConditions(this.getProcessor(1), x + i, y + j);
                    ++n;
                }
            }
        }
        auxArray[auxArray.length - 1] = classValue;
        ins.setValues(1.0, auxArray);
    }

    double getPixelMirrorConditions(ImageProcessor ip, int x, int y) {
        int y2;
        int x2 = x < 0 ? -x : x;
        int n = y2 = y < 0 ? -y : y;
        if (x2 >= ip.getWidth()) {
            x2 = 2 * (ip.getWidth() - 1) - x2;
        }
        if (y2 >= ip.getHeight()) {
            y2 = 2 * (ip.getHeight() - 1) - y2;
        }
        return ip.getPixelValue(x2, y2);
    }

    public void setStack(ImageStack stack) {
        this.wholeStack = stack;
    }

    public ImageStack getStack() {
        return this.wholeStack;
    }

    public void setOldColorFormat(boolean b) {
        this.oldColorFormat = b;
    }

    public boolean isOldColorFormat() {
        return this.oldColorFormat;
    }

    public void setOldHessianFormat(boolean b) {
        this.oldHessianFormat = b;
    }

    public boolean isOldHessianFormat() {
        return this.oldHessianFormat;
    }

    private ImagePlus computeStructure(ImagePlus imp, double sigma, double integrationScale) {
        ImagePlus[] channels = this.extractChannels(imp);
        ImagePlus[] results = new ImagePlus[channels.length];
        for (int ch = 0; ch < channels.length; ++ch) {
            ArrayList<ImagePlus> eigenimages = ImageScience.computeEigenimages(sigma, integrationScale, channels[ch]);
            ImageStack is = new ImageStack(this.width, this.height);
            is.addSlice(availableFeatures[17] + "_largest_" + sigma + "_" + integrationScale, eigenimages.get(0).getProcessor());
            is.addSlice(availableFeatures[17] + "_smallest_" + sigma + "_" + integrationScale, eigenimages.get(1).getProcessor());
            results[ch] = new ImagePlus("Structure stack", is);
        }
        return this.mergeResultChannels(results);
    }

    public boolean reorderFeatures(Instances data) {
        if (null == data) {
            return false;
        }
        Enumeration attributes = data.enumerateAttributes();
        block0: for (int i = 0; attributes.hasMoreElements() && i != this.wholeStack.getSize(); ++i) {
            String featureName = ((Attribute)attributes.nextElement()).name();
            if (this.wholeStack.getSliceLabel(i + 1).equals(featureName)) continue;
            for (int j = i + 1; j < this.wholeStack.getSize(); ++j) {
                if (!this.wholeStack.getSliceLabel(j + 1).equals(featureName)) continue;
                this.wholeStack.addSlice(this.wholeStack.getSliceLabel(j + 1), this.wholeStack.getProcessor(j + 1), i);
                this.wholeStack.deleteSlice(j + 2);
                continue block0;
            }
        }
        return true;
    }
}

