/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.utils;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import trainableSegmentation.utils.Cursor2D;
import trainableSegmentation.utils.Neighborhood2D;
import trainableSegmentation.utils.Neighborhood2DC4;
import trainableSegmentation.utils.Neighborhood2DC8;
import trainableSegmentation.utils.PixelRecord;

public class WatershedTransform2D {
    private ImageProcessor inputImage = null;
    private int connectivity = 4;
    private static final int MASK = -2;
    private static final int WSHED = 0;
    private static final int INIT = -1;
    private static final int INQUEUE = -3;
    protected boolean verbose = false;

    public WatershedTransform2D(ImageProcessor input) {
        this.inputImage = input;
    }

    public WatershedTransform2D(ImageProcessor input, int connectivity) {
        this.inputImage = input;
        if (connectivity != 4 && connectivity != 8) {
            throw new IllegalArgumentException("Illegal connectivity value: it must be 4 or 8!");
        }
        this.connectivity = connectivity;
    }

    public int getConnectivity() {
        return this.connectivity;
    }

    public void setConnectivity(int conn) {
        if (conn == 4 || conn == 8) {
            this.connectivity = conn;
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ImageProcessor apply() {
        return this.apply(this.inputImage.getMin(), this.inputImage.getMax());
    }

    private ImageProcessor apply(double hMin, double hMax) {
        int j;
        int size1 = this.inputImage.getWidth();
        int size2 = this.inputImage.getHeight();
        int[][] tabLabels = new int[size1][size2];
        for (int i = 0; i < size1; ++i) {
            Arrays.fill(tabLabels[i], -1);
        }
        int currentLabel = 0;
        boolean flag = false;
        IJ.showStatus((String)"Extracting pixel values...");
        if (this.verbose) {
            IJ.log((String)("  Extracting pixel values (h_min = " + hMin + ", h_max = " + hMax + ")..."));
        }
        long t0 = System.currentTimeMillis();
        ArrayList<PixelRecord> pixelList = this.extractPixelValues(this.inputImage, hMin, hMax);
        long t1 = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log((String)("  Extraction took " + (t1 - t0) + " ms."));
        }
        if (this.verbose) {
            IJ.log((String)"  Sorting pixels by value...");
        }
        IJ.showStatus((String)"Sorting pixels by value...");
        Collections.sort(pixelList);
        long t2 = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log((String)("  Sorting took " + (t2 - t1) + " ms."));
        }
        if (this.verbose) {
            IJ.log((String)"  Flooding...");
        }
        IJ.showStatus((String)"Flooding...");
        long start = System.currentTimeMillis();
        Neighborhood2D neigh = this.connectivity == 4 ? new Neighborhood2DC4() : new Neighborhood2DC8();
        LinkedList<Cursor2D> fifo = new LinkedList<Cursor2D>();
        double h = hMin;
        int currentIndex = 0;
        while (h < hMin) {
            h = pixelList.get(currentIndex).getValue();
            ++currentIndex;
        }
        int heightIndex1 = currentIndex;
        int heightIndex2 = currentIndex;
        while (currentIndex < pixelList.size() && h <= hMax) {
            PixelRecord pixelRecord;
            int pixelIndex;
            h = pixelList.get(currentIndex).getValue();
            block3: for (pixelIndex = heightIndex1; pixelIndex < pixelList.size(); ++pixelIndex) {
                pixelRecord = pixelList.get(pixelIndex);
                if (pixelRecord.getValue() != h) {
                    heightIndex1 = pixelIndex;
                    break;
                }
                Cursor2D p = pixelRecord.getCursor();
                int i = p.getX();
                j = p.getY();
                tabLabels[i][j] = -2;
                neigh.setCursor(p);
                for (Cursor2D c : neigh.getNeighbors()) {
                    int u = c.getX();
                    int v = c.getY();
                    if (u < 0 || u >= size1 || v < 0 || v >= size2 || tabLabels[u][v] < 0) continue;
                    fifo.addLast(p);
                    tabLabels[i][j] = -3;
                    continue block3;
                }
            }
            while (!fifo.isEmpty()) {
                Cursor2D p = (Cursor2D)fifo.poll();
                int i = p.getX();
                int j2 = p.getY();
                neigh.setCursor(p);
                for (Cursor2D c : neigh.getNeighbors()) {
                    int u = c.getX();
                    int v = c.getY();
                    if (u < 0 || u >= size1 || v < 0 || v >= size2) continue;
                    if (tabLabels[u][v] > 0) {
                        if (tabLabels[i][j2] == -3 || tabLabels[i][j2] == 0 && flag) {
                            tabLabels[i][j2] = tabLabels[u][v];
                            continue;
                        }
                        if (tabLabels[i][j2] <= 0 || tabLabels[i][j2] == tabLabels[u][v]) continue;
                        tabLabels[i][j2] = 0;
                        flag = false;
                        continue;
                    }
                    if (tabLabels[u][v] == 0) {
                        if (tabLabels[i][j2] != -3) continue;
                        tabLabels[i][j2] = 0;
                        flag = true;
                        continue;
                    }
                    if (tabLabels[u][v] != -2) continue;
                    tabLabels[u][v] = -3;
                    fifo.addLast(c);
                }
            }
            pixelIndex = heightIndex2;
            while (pixelIndex < pixelList.size()) {
                pixelRecord = pixelList.get(pixelIndex);
                if (pixelRecord.getValue() != h) {
                    heightIndex2 = pixelIndex;
                    break;
                }
                Cursor2D p = pixelRecord.getCursor();
                int i = p.getX();
                if (tabLabels[i][j = p.getY()] == -2) {
                    fifo.addLast(p);
                    tabLabels[i][j] = ++currentLabel;
                    while (!fifo.isEmpty()) {
                        Cursor2D p2 = (Cursor2D)fifo.poll();
                        neigh.setCursor(p2);
                        for (Cursor2D c : neigh.getNeighbors()) {
                            int u = c.getX();
                            int v = c.getY();
                            if (u < 0 || u >= size1 || v < 0 || v >= size2 || tabLabels[u][v] != -2) continue;
                            fifo.addLast(c);
                            tabLabels[u][v] = currentLabel;
                        }
                    }
                }
                ++pixelIndex;
                ++currentIndex;
            }
            IJ.showProgress((double)(h / hMax));
        }
        IJ.showProgress((double)1.0);
        long end = System.currentTimeMillis();
        if (this.verbose) {
            IJ.log((String)("  Flooding took: " + (end - start) + " ms"));
        }
        FloatProcessor fp = new FloatProcessor(size1, size2);
        for (int i = 0; i < size1; ++i) {
            for (j = 0; j < size2; ++j) {
                if (tabLabels[i][j] == -1) {
                    fp.setf(i, j, 0.0f);
                    continue;
                }
                fp.setf(i, j, (float)tabLabels[i][j]);
            }
        }
        return fp;
    }

    public ArrayList<PixelRecord> extractPixelValues(ImageProcessor inputImage, double hMin, double hMax) {
        int size1 = inputImage.getWidth();
        int size2 = inputImage.getHeight();
        ArrayList<PixelRecord> list = new ArrayList<PixelRecord>();
        for (int x = 0; x < size1; ++x) {
            for (int y = 0; y < size2; ++y) {
                double h = inputImage.getf(x, y);
                if (!(h >= hMin) || !(h <= hMax)) continue;
                list.add(new PixelRecord(x, y, h));
            }
        }
        return list;
    }
}

