/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.catmaid;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.ViewerSetupImgLoader;
import bdv.img.cache.VolatileCachedCellImg;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.catmaid.CatmaidVolatileIntArrayLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;

public class CatmaidImageLoader
extends AbstractViewerSetupImgLoader<ARGBType, VolatileARGBType>
implements ViewerImgLoader {
    private final int numScales;
    private final double[][] mipmapResolutions;
    private final AffineTransform3D[] mipmapTransforms;
    private final long[][] imageDimensions;
    private final int[][] blockDimensions;
    private VolatileGlobalCellCache cache;
    private final CatmaidVolatileIntArrayLoader loader;

    private static final int[][] blockDimensions(int tileWidth, int tileHeight, int numScales) {
        int[][] blockDimensions = new int[numScales][];
        for (int i = 0; i < numScales; ++i) {
            blockDimensions[i] = new int[]{tileWidth, tileHeight, 1};
        }
        return blockDimensions;
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, String urlFormat, int tileWidth, int tileHeight, int[][] blockDimensions, boolean topLeft) {
        super(new ARGBType(), new VolatileARGBType());
        this.numScales = blockDimensions.length;
        this.mipmapResolutions = new double[this.numScales][];
        this.imageDimensions = new long[this.numScales][];
        this.mipmapTransforms = new AffineTransform3D[this.numScales];
        int[] zScales = new int[this.numScales];
        this.blockDimensions = new int[this.numScales][];
        for (int l = 0; l < this.numScales; ++l) {
            int sixy = 1 << l;
            int siz = Math.max(1, (int)Math.round((double)sixy / zScale));
            this.mipmapResolutions[l] = new double[]{sixy, sixy, siz};
            this.imageDimensions[l] = new long[]{width >> l, height >> l, depth / (long)siz};
            this.blockDimensions[l] = (int[])blockDimensions[l].clone();
            zScales[l] = siz;
            AffineTransform3D mipmapTransform = new AffineTransform3D();
            mipmapTransform.set((double)sixy, 0, 0);
            mipmapTransform.set((double)sixy, 1, 1);
            mipmapTransform.set(zScale * (double)siz, 2, 2);
            if (topLeft) {
                mipmapTransform.set(0.5 * (double)(sixy - 1), 0, 3);
                mipmapTransform.set(0.5 * (double)(sixy - 1), 1, 3);
            }
            mipmapTransform.set(0.5 * (zScale * (double)siz - 1.0), 2, 3);
            this.mipmapTransforms[l] = mipmapTransform;
        }
        this.loader = new CatmaidVolatileIntArrayLoader(urlFormat, tileWidth, tileHeight, zScales);
        this.cache = new VolatileGlobalCellCache(this.numScales, 10);
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, String urlFormat, int tileWidth, int tileHeight, int[][] blockDimensions) {
        this(width, height, depth, zScale, urlFormat, tileWidth, tileHeight, blockDimensions, true);
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, int numScales, String urlFormat, int tileWidth, int tileHeight, int blockWidth, int blockHeight, boolean topLeft) {
        this(width, height, depth, zScale, urlFormat, tileWidth, tileHeight, CatmaidImageLoader.blockDimensions(blockWidth, blockHeight, numScales), topLeft);
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, int numScales, String urlFormat, int tileWidth, int tileHeight, int blockWidth, int blockHeight) {
        this(width, height, depth, zScale, urlFormat, tileWidth, tileHeight, CatmaidImageLoader.blockDimensions(blockWidth, blockHeight, numScales), true);
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, int numScales, String urlFormat, int tileWidth, int tileHeight, boolean topLeft) {
        this(width, height, depth, zScale, numScales, urlFormat, tileWidth, tileHeight, tileWidth, tileHeight, topLeft);
    }

    public CatmaidImageLoader(long width, long height, long depth, double zScale, int numScales, String urlFormat, int tileWidth, int tileHeight) {
        this(width, height, depth, zScale, numScales, urlFormat, tileWidth, tileHeight, true);
    }

    public static final int getNumScales(long width, long height, long tileWidth, long tileHeight) {
        int i = 1;
        while ((width >>= 1) > tileWidth && (height >>= 1) > tileHeight) {
            ++i;
        }
        return i;
    }

    protected <T extends NativeType<T>> VolatileCachedCellImg<T, VolatileIntArray> prepareCachedImage(int timepointId, int setupId, int level, LoadingStrategy loadingStrategy, T type) {
        long[] dimensions = this.imageDimensions[level];
        CellGrid grid = new CellGrid(dimensions, this.blockDimensions[level]);
        int priority = this.numScales - 1 - level;
        CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
        return this.cache.createImg(grid, timepointId, setupId, level, cacheHints, this.loader, type);
    }

    @Override
    public VolatileGlobalCellCache getCacheControl() {
        return this.cache;
    }

    @Override
    public ViewerSetupImgLoader<?, ?> getSetupImgLoader(int setupId) {
        return this;
    }

    public RandomAccessibleInterval<ARGBType> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, 0, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
    }

    @Override
    public RandomAccessibleInterval<VolatileARGBType> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, 0, level, LoadingStrategy.VOLATILE, (NativeType)((Object)this.volatileType));
    }

    public double[][] getMipmapResolutions() {
        return this.mipmapResolutions;
    }

    public AffineTransform3D[] getMipmapTransforms() {
        return this.mipmapTransforms;
    }

    public int numMipmapLevels() {
        return this.numScales;
    }

    public void setCache(VolatileGlobalCellCache cache) {
        this.cache = cache;
    }
}

