/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;

public class Partition {
    protected final String path;
    private final Map<Integer, Integer> timepointIdSequenceToPartition;
    private final Map<Integer, Integer> setupIdSequenceToPartition;

    public Partition(String path, int[] timepointIdsSequence, int[] setupIdsSequence, int[] timepointIdsPartition, int[] setupIdsPartition) {
        int i;
        this.path = path;
        this.timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
        this.setupIdSequenceToPartition = new HashMap<Integer, Integer>();
        for (i = 0; i < timepointIdsSequence.length; ++i) {
            this.timepointIdSequenceToPartition.put(timepointIdsSequence[i], timepointIdsPartition[i]);
        }
        for (i = 0; i < setupIdsSequence.length; ++i) {
            this.setupIdSequenceToPartition.put(setupIdsSequence[i], setupIdsPartition[i]);
        }
    }

    public Partition(String path, Map<Integer, Integer> timepointIdSequenceToPartition, Map<Integer, Integer> setupIdSequenceToPartition) {
        this.path = path;
        this.timepointIdSequenceToPartition = Collections.unmodifiableMap(timepointIdSequenceToPartition);
        this.setupIdSequenceToPartition = Collections.unmodifiableMap(setupIdSequenceToPartition);
    }

    public String getPath() {
        return this.path;
    }

    public Map<Integer, Integer> getTimepointIdSequenceToPartition() {
        return this.timepointIdSequenceToPartition;
    }

    public Map<Integer, Integer> getSetupIdSequenceToPartition() {
        return this.setupIdSequenceToPartition;
    }

    public boolean contains(ViewId viewId) {
        return this.timepointIdSequenceToPartition.containsKey(viewId.getTimePointId()) && this.setupIdSequenceToPartition.containsKey(viewId.getViewSetupId());
    }

    public static ArrayList<Partition> split(List<TimePoint> timepoints, List<? extends BasicViewSetup> setups, int timepointsPerPartition, int setupsPerPartition, String basename) {
        int s;
        String partitionFilenameFormat = basename + "-%02d-%02d.h5";
        int numTimepoints = timepoints.size();
        int numSetups = setups.size();
        ArrayList<Integer> timepointSplits = new ArrayList<Integer>();
        timepointSplits.add(0);
        if (timepointsPerPartition > 0) {
            for (int t = timepointsPerPartition; t < numTimepoints; t += timepointsPerPartition) {
                timepointSplits.add(t);
            }
        }
        timepointSplits.add(numTimepoints);
        ArrayList timepointMaps = new ArrayList();
        for (int i = 0; i < timepointSplits.size() - 1; ++i) {
            HashMap<Integer, Integer> timepointIdSequenceToPartition = new HashMap<Integer, Integer>();
            for (int t = ((Integer)timepointSplits.get(i)).intValue(); t < (Integer)timepointSplits.get(i + 1); ++t) {
                int id = timepoints.get(t).getId();
                timepointIdSequenceToPartition.put(id, id);
            }
            timepointMaps.add(timepointIdSequenceToPartition);
        }
        ArrayList<Integer> setupSplits = new ArrayList<Integer>();
        setupSplits.add(0);
        if (setupsPerPartition > 0) {
            for (int s2 = setupsPerPartition; s2 < numSetups; s2 += setupsPerPartition) {
                setupSplits.add(s2);
            }
        }
        setupSplits.add(numSetups);
        ArrayList setupMaps = new ArrayList();
        for (int i = 0; i < setupSplits.size() - 1; ++i) {
            HashMap<Integer, Integer> setupIdSequenceToPartition = new HashMap<Integer, Integer>();
            for (s = ((Integer)setupSplits.get(i)).intValue(); s < (Integer)setupSplits.get(i + 1); ++s) {
                int id = setups.get(s).getId();
                setupIdSequenceToPartition.put(id, id);
            }
            setupMaps.add(setupIdSequenceToPartition);
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (int t = 0; t < timepointMaps.size(); ++t) {
            for (s = 0; s < setupMaps.size(); ++s) {
                String path = String.format(partitionFilenameFormat, t, s);
                partitions.add(new Partition(path, (Map)timepointMaps.get(t), (Map)setupMaps.get(s)));
            }
        }
        return partitions;
    }
}

