/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.Affine3DHelpers;
import bdv.util.Bounds;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerFrame;
import bdv.viewer.state.ViewerState;
import java.awt.Dimension;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.DiscreteFrequencyDistribution;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.util.LinAlgHelpers;
import net.imglib2.view.Views;

public class InitializeViewerState {
    public static void initTransform(AbstractViewerPanel viewer) {
        Dimension dim = viewer.getDisplayComponent().getSize();
        AffineTransform3D viewerTransform = InitializeViewerState.initTransform(dim.width, dim.height, false, viewer.state().snapshot());
        viewer.state().setViewerTransform(viewerTransform);
    }

    public static AffineTransform3D initTransform(int viewerWidth, int viewerHeight, boolean zoomedIn, bdv.viewer.ViewerState state) {
        int timepoint;
        AffineTransform3D viewerTransform = new AffineTransform3D();
        double cX = (double)viewerWidth / 2.0;
        double cY = (double)viewerHeight / 2.0;
        SourceAndConverter<?> current = state.getCurrentSource();
        if (current == null) {
            return viewerTransform;
        }
        Source<?> source = current.getSpimSource();
        if (!source.isPresent(timepoint = state.getCurrentTimepoint())) {
            return viewerTransform;
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(timepoint, 0, sourceTransform);
        RandomAccessibleInterval<?> sourceInterval = source.getSource(timepoint, 0);
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sZ0 = sourceInterval.min(2);
        double sZ1 = sourceInterval.max(2);
        double sX = (sX0 + sX1) / 2.0;
        double sY = (sY0 + sY1) / 2.0;
        double sZ = Math.round((sZ0 + sZ1) / 2.0);
        double[][] m = new double[3][4];
        double[] qSource = new double[4];
        double[] qViewer = new double[4];
        Affine3DHelpers.extractApproximateRotationAffine(sourceTransform, qSource, 2);
        LinAlgHelpers.quaternionInvert(qSource, qViewer);
        LinAlgHelpers.quaternionToR(qViewer, m);
        double[] centerSource = new double[]{sX, sY, sZ};
        double[] centerGlobal = new double[3];
        double[] translation = new double[3];
        sourceTransform.apply(centerSource, centerGlobal);
        LinAlgHelpers.quaternionApply(qViewer, centerGlobal, translation);
        LinAlgHelpers.scale(translation, -1.0, translation);
        LinAlgHelpers.setCol(3, translation, m);
        viewerTransform.set(m);
        double[] pSource = new double[]{sX1 + 0.5, sY1 + 0.5, sZ};
        double[] pGlobal = new double[3];
        double[] pScreen = new double[3];
        sourceTransform.apply(pSource, pGlobal);
        viewerTransform.apply(pGlobal, pScreen);
        double scaleX = cX / pScreen[0];
        double scaleY = cY / pScreen[1];
        double scale = zoomedIn ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
        viewerTransform.scale(scale);
        viewerTransform.set(viewerTransform.get(0, 3) + cX - 0.5, 0, 3);
        viewerTransform.set(viewerTransform.get(1, 3) + cY - 0.5, 1, 3);
        return viewerTransform;
    }

    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, ViewerFrame viewerFrame) {
        InitializeViewerState.initBrightness(cumulativeMinCutoff, cumulativeMaxCutoff, viewerFrame.getViewerPanel().state().snapshot(), viewerFrame.getConverterSetups());
    }

    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, bdv.viewer.ViewerState state, ConverterSetups converterSetups) {
        SourceAndConverter<?> current = state.getCurrentSource();
        if (current == null) {
            return;
        }
        Source<?> source = current.getSpimSource();
        int timepoint = state.getCurrentTimepoint();
        Bounds bounds = InitializeViewerState.estimateSourceRange(source, timepoint, cumulativeMinCutoff, cumulativeMaxCutoff);
        for (SourceAndConverter<?> s : state.getSources()) {
            ConverterSetup setup = converterSetups.getConverterSetup(s);
            setup.setDisplayRange(bounds.getMinBound(), bounds.getMaxBound());
        }
    }

    public static Bounds estimateSourceRange(Source<?> source, int timepoint, double cumulativeMinCutoff, double cumulativeMaxCutoff) {
        Object type = source.getType();
        if (type instanceof UnsignedShortType && source.isPresent(timepoint)) {
            int i;
            RandomAccessibleInterval<?> img = source.getSource(timepoint, source.getNumMipmapLevels() - 1);
            long z = (img.min(2) + img.max(2) + 1L) / 2L;
            int numBins = 6535;
            Histogram1d histogram = new Histogram1d(Views.hyperSlice(img, 2, z), new Real1dBinMapper(0.0, 65535.0, 6535L, false));
            DiscreteFrequencyDistribution dfd = histogram.dfd();
            long[] bin = new long[]{0L};
            double cumulative = 0.0;
            for (i = 0; i < 6535 && cumulative < cumulativeMinCutoff; cumulative += dfd.relativeFrequency(bin), ++i) {
                bin[0] = i;
            }
            int min = i * 65535 / 6535;
            while (i < 6535 && cumulative < cumulativeMaxCutoff) {
                bin[0] = i;
                cumulative += dfd.relativeFrequency(bin);
                ++i;
            }
            int max = i * 65535 / 6535;
            return new Bounds(min, max);
        }
        if (type instanceof UnsignedByteType) {
            return new Bounds(0.0, 255.0);
        }
        return new Bounds(0.0, 65535.0);
    }

    @Deprecated
    public static AffineTransform3D initTransform(int viewerWidth, int viewerHeight, boolean zoomedIn, ViewerState state) {
        return InitializeViewerState.initTransform(viewerWidth, viewerHeight, zoomedIn, state.getState());
    }

    @Deprecated
    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, ViewerState state, SetupAssignments setupAssignments) {
        InitializeViewerState.initBrightness(cumulativeMinCutoff, cumulativeMaxCutoff, (bdv.viewer.ViewerState)state.getState(), setupAssignments);
    }

    @Deprecated
    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, AbstractViewerPanel viewer, SetupAssignments setupAssignments) {
        InitializeViewerState.initBrightness(cumulativeMinCutoff, cumulativeMaxCutoff, viewer.state().snapshot(), setupAssignments);
    }

    @Deprecated
    public static void initBrightness(double cumulativeMinCutoff, double cumulativeMaxCutoff, bdv.viewer.ViewerState state, SetupAssignments setupAssignments) {
        SourceAndConverter<?> current = state.getCurrentSource();
        if (current == null) {
            return;
        }
        Source<?> source = current.getSpimSource();
        int timepoint = state.getCurrentTimepoint();
        Bounds bounds = InitializeViewerState.estimateSourceRange(source, timepoint, cumulativeMinCutoff, cumulativeMaxCutoff);
        MinMaxGroup minmax = setupAssignments.getMinMaxGroups().get(0);
        minmax.getMinBoundedValue().setCurrentValue(bounds.getMinBound());
        minmax.getMaxBoundedValue().setCurrentValue(bounds.getMaxBound());
    }
}

