/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.transformation;

import bdv.tools.transformation.ManualSourceTransforms;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.XmlHelpers;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoTransformedSources {
    public static final String SOURCETRANSFORMS_TAG = "ManualSourceTransforms";
    public static final String SOURCETRANSFORM_TAG = "SourceTransform";
    public static final String SOURCETRANSFORM_TYPE_ATTRIBUTE_NAME = "type";
    public static final String SOURCETRANSFORM_TYPE_VALUE_AFFINE = "affine";
    public static final String SOURCETRANSFORM_AFFINE_TAG = "affine";

    public String getTagName() {
        return SOURCETRANSFORMS_TAG;
    }

    public ManualSourceTransforms fromXml(Element elem) {
        ArrayList<AffineTransform3D> transforms = new ArrayList<AffineTransform3D>();
        for (Element t : elem.getChildren(SOURCETRANSFORM_TAG)) {
            transforms.add(this.fromXmlAffine(t));
        }
        return new ManualSourceTransforms(transforms);
    }

    public Element toXml(ManualSourceTransforms manualSourceTransforms) {
        Element elem = new Element(SOURCETRANSFORMS_TAG);
        List<AffineTransform3D> transforms = manualSourceTransforms.getTransforms();
        for (AffineTransform3D t : transforms) {
            elem.addContent((Content)this.toXmlAffine(t));
        }
        return elem;
    }

    protected AffineTransform3D fromXmlAffine(Element transform) {
        AffineTransform3D affine = XmlHelpers.getAffineTransform3D((Element)transform, (String)"affine");
        return affine;
    }

    protected Element toXmlAffine(AffineTransform3D transform) {
        Element elem = new Element(SOURCETRANSFORM_TAG);
        elem.setAttribute(SOURCETRANSFORM_TYPE_ATTRIBUTE_NAME, "affine");
        elem.addContent((Content)XmlHelpers.affineTransform3DElement((String)"affine", (AffineGet)transform));
        return elem;
    }
}

