/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.BigDataViewer;
import bdv.TransformEventHandler;
import bdv.cache.CacheControl;
import bdv.ui.BdvDefaultCards;
import bdv.ui.CardPanel;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.AWTUtils;
import bdv.viewer.ConverterSetups;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerPanel;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.MouseAndKeyHandler;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class ViewerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final ViewerPanel viewer;
    private final CardPanel cards;
    private final SplitPanel splitPanel;
    private final InputActionBindings keybindings;
    private final TriggerBehaviourBindings triggerbindings;
    private final Behaviours transformBehaviours;
    private final ConverterSetups setups;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;

    public ViewerFrame(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cache) {
        this(sources, numTimepoints, cache, new KeymapManager(BigDataViewer.configDir), new AppearanceManager(BigDataViewer.configDir), ViewerOptions.options());
    }

    public ViewerFrame(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cacheControl, KeymapManager keymapManager, AppearanceManager appearanceManager, ViewerOptions optional) {
        super("BigDataViewer", AWTUtils.getSuitableGraphicsConfiguration(AWTUtils.RGB_COLOR_MODEL));
        this.keymapManager = keymapManager;
        this.appearanceManager = appearanceManager;
        this.viewer = new ViewerPanel(sources, numTimepoints, cacheControl, optional);
        this.setups = new ConverterSetups(this.viewer.state());
        this.setups.listeners().add(s -> this.viewer.requestRepaint());
        this.keybindings = new InputActionBindings();
        this.triggerbindings = new TriggerBehaviourBindings();
        this.cards = new CardPanel();
        BdvDefaultCards.setup(this.cards, this.viewer, this.setups);
        this.splitPanel = new SplitPanel(this.viewer, this.cards);
        this.getRootPane().setDoubleBuffered(true);
        this.add((Component)this.splitPanel, "Center");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ViewerFrame.this.viewer.stop();
            }
        });
        SwingUtilities.replaceUIActionMap(this.viewer, this.keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap(this.viewer, 1, this.keybindings.getConcatenatedInputMap());
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        mouseAndKeyHandler.setInputMap(this.triggerbindings.getConcatenatedInputTriggerMap());
        mouseAndKeyHandler.setBehaviourMap(this.triggerbindings.getConcatenatedBehaviourMap());
        mouseAndKeyHandler.setKeypressManager(optional.values.getKeyPressedManager(), this.viewer.getDisplayComponent());
        this.viewer.getDisplay().addHandler(mouseAndKeyHandler);
        this.transformBehaviours = new Behaviours((InputTriggerAdder.Factory)optional.values.getInputTriggerConfig(), new String[]{"bdv"});
        this.transformBehaviours.install(this.triggerbindings, "transform");
        TransformEventHandler tfHandler = this.viewer.getTransformEventHandler();
        tfHandler.install(this.transformBehaviours);
    }

    public ViewerPanel getViewerPanel() {
        return this.viewer;
    }

    public CardPanel getCardPanel() {
        return this.cards;
    }

    public SplitPanel getSplitPanel() {
        return this.splitPanel;
    }

    public InputActionBindings getKeybindings() {
        return this.keybindings;
    }

    public TriggerBehaviourBindings getTriggerbindings() {
        return this.triggerbindings;
    }

    public Behaviours getTransformBehaviours() {
        return this.transformBehaviours;
    }

    public ConverterSetups getConverterSetups() {
        return this.setups;
    }

    public KeymapManager getKeymapManager() {
        return this.keymapManager;
    }

    public AppearanceManager getAppearanceManager() {
        return this.appearanceManager;
    }
}

