/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.SourceBounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.Interval;

class Tile {
    private final List<SourceBounds> bounds;
    private final List<SourceAndConverter<?>> alwaysVisibleSources;
    private final int tileMinX;
    private final int tileMinY;
    private final int tileMaxX;
    private final int tileMaxY;
    private List<SourceAndConverter<?>> sources;

    Tile(List<SourceBounds> bounds, List<SourceAndConverter<?>> alwaysVisibleSources, int tileMinX, int tileMinY, int tileMaxX, int tileMaxY) {
        this.bounds = bounds;
        this.alwaysVisibleSources = alwaysVisibleSources;
        this.tileMinX = tileMinX;
        this.tileMinY = tileMinY;
        this.tileMaxX = tileMaxX;
        this.tileMaxY = tileMaxY;
    }

    Tile(List<SourceBounds> bounds, List<SourceAndConverter<?>> alwaysVisibleSources, Interval interval) {
        this(bounds, alwaysVisibleSources, (int)interval.min(0), (int)interval.min(1), (int)interval.max(0), (int)interval.max(1));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TileSplit{");
        sb.append("(").append(this.tileMinX);
        sb.append(", ").append(this.tileMinY);
        sb.append(") -- (").append(this.tileMaxX);
        sb.append(", ").append(this.tileMaxY);
        sb.append("), ");
        sb.append("bounds=").append(this.bounds);
        sb.append('}');
        return sb.toString();
    }

    public List<SourceBounds> sourceBounds() {
        return this.bounds;
    }

    public List<SourceAndConverter<?>> alwaysVisibleSources() {
        return this.alwaysVisibleSources;
    }

    public List<SourceAndConverter<?>> sources() {
        if (this.sources == null) {
            ArrayList sources = new ArrayList(this.bounds.size() + this.alwaysVisibleSources.size());
            for (SourceBounds sourceBounds : this.bounds) {
                SourceAndConverter<?> source = sourceBounds.source();
                sources.add(source);
            }
            sources.addAll(this.alwaysVisibleSources);
            this.sources = sources;
        }
        return this.sources;
    }

    public int tileMinX() {
        return this.tileMinX;
    }

    public int tileMinY() {
        return this.tileMinY;
    }

    public int tileMaxX() {
        return this.tileMaxX;
    }

    public int tileMaxY() {
        return this.tileMaxY;
    }

    public int tileSizeX() {
        return this.tileMaxX - this.tileMinX + 1;
    }

    public int tileSizeY() {
        return this.tileMaxY - this.tileMinY + 1;
    }

    public int[] splitCandidates(int d) {
        int[] candidates = new int[2 * this.bounds.size()];
        int i = 0;
        if (d == 0) {
            for (SourceBounds bounds : this.bounds) {
                i = Tile.addIfInBounds(bounds.minX(), candidates, i, this.tileMinX, this.tileMaxX);
                i = Tile.addIfInBounds(bounds.maxX() + 1, candidates, i, this.tileMinX, this.tileMaxX);
            }
        } else {
            for (SourceBounds bounds : this.bounds) {
                i = Tile.addIfInBounds(bounds.minY(), candidates, i, this.tileMinY, this.tileMaxY);
                i = Tile.addIfInBounds(bounds.maxY() + 1, candidates, i, this.tileMinY, this.tileMaxY);
            }
        }
        int length = i;
        Arrays.sort(candidates, 0, length);
        int j = 0;
        for (i = 0; i < length; ++i) {
            int value = candidates[i];
            if (j != 0 && candidates[j - 1] == value) continue;
            candidates[j++] = value;
        }
        return Arrays.copyOf(candidates, j);
    }

    private static int addIfInBounds(int value, int[] splitCandidates, int i, int tileMin, int tileMax) {
        if (value <= tileMin || value > tileMax) {
            return i;
        }
        splitCandidates[i] = value;
        return i + 1;
    }
}

