/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render.awt;

import java.util.function.Supplier;

class TripleBuffer<T> {
    private T writable;
    private T readable;
    private T exchange;
    private boolean pending = false;
    private final Supplier<T> factory;

    public TripleBuffer(Supplier<T> factory) {
        this.factory = factory;
    }

    public TripleBuffer() {
        this(() -> null);
    }

    public synchronized T getWritableBuffer() {
        if (this.writable == null) {
            this.writable = this.factory.get();
        }
        return this.writable;
    }

    public synchronized void doneWriting() {
        this.doneWriting(this.writable);
    }

    public synchronized void doneWriting(T value) {
        this.writable = this.exchange;
        this.exchange = value;
        this.pending = true;
    }

    public synchronized ReadableBuffer<T> getReadableBuffer() {
        boolean updated = this.pending;
        if (this.pending) {
            T tmp = this.exchange;
            this.exchange = this.readable;
            this.readable = tmp;
            this.pending = false;
        }
        return new ReadableBuffer<T>(this.readable, updated);
    }

    public synchronized void clear() {
        this.writable = null;
        this.readable = null;
        this.exchange = null;
    }

    public static class ReadableBuffer<T> {
        private final T buffer;
        private final boolean updated;

        ReadableBuffer(T buffer, boolean updated) {
            this.buffer = buffer;
            this.updated = updated;
        }

        public T getBuffer() {
            return this.buffer;
        }

        public boolean isUpdated() {
            return this.updated;
        }
    }
}

