/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io.icns;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sc.fiji.io.icns.IOSupport;
import sc.fiji.io.icns.IconSuite;
import sc.fiji.io.icns.RunLengthEncoding;

public class IcnsCodec {
    private static final String ICNS = "icns";
    private static final String ICS_BW = "ics#";
    private static final int ICS_BW_SIZE = 16;
    private static final String ICN_BW = "ICN#";
    private static final int ICN_BW_SIZE = 32;
    private static final String SMALL_32_BIT_RGB = "is32";
    private static final String SMALL_8_BIT_MASK = "s8mk";
    static final int SMALL_SIZE = 16;
    private static final String LARGE_32_BIT_RGB = "il32";
    private static final String LARGE_8_BIT_MASK = "l8mk";
    static final int LARGE_SIZE = 32;
    private static final String HUGE_32_BIT_RGB = "ih32";
    private static final String HUGE_8_BIT_MASK = "h8mk";
    static final int HUGE_SIZE = 48;
    private static final String THUMBNAIL_32_BIT_RGB = "it32";
    private static final String THUMBNAIL_8_BIT_MASK = "t8mk";
    static final int THUMBNAIL_SIZE = 128;

    public void encode(IconSuite suite, OutputStream outputStream) throws IOException {
        byte[] small = this.encode32bitIcon(suite.getSmallIcon(), SMALL_32_BIT_RGB, SMALL_8_BIT_MASK);
        byte[] large = this.encode32bitIcon(suite.getLargeIcon(), LARGE_32_BIT_RGB, LARGE_8_BIT_MASK);
        byte[] huge = this.encode32bitIcon(suite.getHugeIcon(), HUGE_32_BIT_RGB, HUGE_8_BIT_MASK);
        byte[] thumbnail = this.encode32bitIcon(suite.getThumbnailIcon(), THUMBNAIL_32_BIT_RGB, 4, THUMBNAIL_8_BIT_MASK);
        byte[] icsBW = this.encodeIcsBW(suite);
        byte[] icnBW = this.encodeIcnBW(suite);
        int totalSize = icsBW.length + icnBW.length + small.length + huge.length + large.length + thumbnail.length;
        DataOutputStream stream = new DataOutputStream(outputStream);
        IOSupport.writeLiteralLongInt(stream, ICNS);
        IOSupport.writeLongInt(stream, totalSize + 8);
        stream.write(icsBW);
        stream.write(small);
        stream.write(icnBW);
        stream.write(large);
        stream.write(huge);
        stream.write(thumbnail);
    }

    private byte[] encodeIcsBW(IconSuite suite) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = this.encodeAsBWData(suite, 16, 16);
        IOSupport.writeLiteralLongInt(out, ICS_BW);
        IOSupport.writeLongInt(out, data.length + 8);
        out.write(data);
        return out.toByteArray();
    }

    private byte[] encodeIcnBW(IconSuite suite) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = this.encodeAsBWData(suite, 32, 32);
        IOSupport.writeLiteralLongInt(out, ICN_BW);
        IOSupport.writeLongInt(out, 2 * data.length + 8);
        out.write(data);
        out.write(data);
        return out.toByteArray();
    }

    private byte[] encodeAsBWData(IconSuite suite, int width, int height) {
        BufferedImage icon = suite.getBestMatchingIcon(width, height);
        if (icon == null) {
            return new byte[0];
        }
        BufferedImage scaledImage = new BufferedImage(width, height, 12);
        Graphics graphics = scaledImage.getGraphics();
        graphics.drawImage(icon, 0, 0, width, height, 0, 0, icon.getWidth(), icon.getHeight(), null);
        graphics.dispose();
        DataBufferByte dataBuffer = (DataBufferByte)scaledImage.getData().getDataBuffer();
        byte[] data = dataBuffer.getData();
        assert (data.length == width * height / 8) : "Incorrect data size [actual:" + data.length + ",expected:" + width * height / 8 + "]";
        return data;
    }

    private byte[] encode32bitIcon(BufferedImage image, String rgbHeader, String maskHeader) throws IOException {
        return this.encode32bitIcon(image, rgbHeader, 0, maskHeader);
    }

    private byte[] encode32bitIcon(BufferedImage image, String rgbHeader, int rgbPrefixSize, String maskHeader) throws IOException {
        if (image == null) {
            return new byte[0];
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bytesR = new byte[width * height];
        byte[] bytesG = new byte[width * height];
        byte[] bytesB = new byte[width * height];
        byte[] mask = new byte[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = image.getRGB(x, y);
                byte a = (byte)((pixel & 0xFF000000) >> 24);
                byte r = (byte)((pixel & 0xFF0000) >> 16);
                byte g = (byte)((pixel & 0xFF00) >> 8);
                byte b = (byte)(pixel & 0xFF);
                int pixelOffset = y * width + x;
                mask[pixelOffset] = a;
                bytesR[pixelOffset] = r;
                bytesG[pixelOffset] = g;
                bytesB[pixelOffset] = b;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] packedR = RunLengthEncoding.packIconData(bytesR);
        byte[] packedG = RunLengthEncoding.packIconData(bytesG);
        byte[] packedB = RunLengthEncoding.packIconData(bytesB);
        int packedLength = packedR.length + packedG.length + packedB.length;
        int resourceSize = rgbPrefixSize + packedLength + 8;
        IOSupport.writeLiteralLongInt(out, rgbHeader);
        IOSupport.writeLongInt(out, resourceSize);
        out.write(new byte[rgbPrefixSize]);
        out.write(packedR);
        out.write(packedG);
        out.write(packedB);
        IOSupport.writeLiteralLongInt(out, maskHeader);
        IOSupport.writeLongInt(out, mask.length + 8);
        out.write(mask);
        return out.toByteArray();
    }

    public IconSuite decode(InputStream inputStream) throws IOException {
        int elementSize;
        String header = IOSupport.readLiteralLongInt(inputStream);
        if (!header.equals(ICNS)) {
            throw new IOException("Unexpected header encountered: " + header);
        }
        int[] small = null;
        int[] large = null;
        int[] huge = null;
        int[] thumb = null;
        int fileSize = IOSupport.readLongInt(inputStream);
        for (int bytesLeft = fileSize - 8; bytesLeft > 0; bytesLeft -= elementSize) {
            byte[] elementData;
            String elementType = IOSupport.readLiteralLongInt(inputStream);
            elementSize = IOSupport.readLongInt(inputStream);
            int elementDataSize = elementSize - 8;
            if (elementType.equals(SMALL_32_BIT_RGB)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                small = this.decode32bitIcon(elementData, small, 16);
                continue;
            }
            if (elementType.equals(LARGE_32_BIT_RGB)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                large = this.decode32bitIcon(elementData, large, 32);
                continue;
            }
            if (elementType.equals(HUGE_32_BIT_RGB)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                huge = this.decode32bitIcon(elementData, huge, 48);
                continue;
            }
            if (elementType.equals(THUMBNAIL_32_BIT_RGB)) {
                IOSupport.skip(inputStream, 4L);
                elementData = new byte[elementDataSize - 4];
                IOSupport.readFully(inputStream, elementData);
                thumb = this.decode32bitIcon(elementData, thumb, 128);
                continue;
            }
            if (elementType.equals(SMALL_8_BIT_MASK)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                small = this.decode8bitMask(elementData, small, 16);
                continue;
            }
            if (elementType.equals(LARGE_8_BIT_MASK)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                large = this.decode8bitMask(elementData, large, 32);
                continue;
            }
            if (elementType.equals(HUGE_8_BIT_MASK)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                huge = this.decode8bitMask(elementData, huge, 48);
                continue;
            }
            if (elementType.equals(THUMBNAIL_8_BIT_MASK)) {
                elementData = new byte[elementDataSize];
                IOSupport.readFully(inputStream, elementData);
                thumb = this.decode8bitMask(elementData, thumb, 128);
                continue;
            }
            IOSupport.skip(inputStream, elementDataSize);
        }
        IconSuite suite = new IconSuite();
        if (small != null) {
            suite.setSmallIcon(this.createImage(16, small));
        }
        if (large != null) {
            suite.setLargeIcon(this.createImage(32, large));
        }
        if (huge != null) {
            suite.setHugeIcon(this.createImage(48, huge));
        }
        if (thumb != null) {
            suite.setThumbnailIcon(this.createImage(128, thumb));
        }
        return suite;
    }

    private BufferedImage createImage(int size, int[] pixels) {
        BufferedImage image = new BufferedImage(size, size, 2);
        image.setRGB(0, 0, size, size, pixels, 0, size);
        return image;
    }

    private int[] decode32bitIcon(byte[] packedData, int[] destination, int size) {
        int[] pixels;
        byte[] unpackedData;
        int nbPixels = size * size;
        if (packedData.length == nbPixels * 4) {
            unpackedData = packedData;
        } else {
            unpackedData = new byte[nbPixels * 3];
            RunLengthEncoding.unpackIconData(packedData, unpackedData);
        }
        if (destination == null) {
            pixels = new int[nbPixels];
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = -16777216;
            }
        } else {
            pixels = destination;
        }
        assert (pixels.length == size * size) : "Incorrect pixel buffer size";
        int unpackedIndex = 0;
        int i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | (unpackedData[unpackedIndex++] & 0xFF) << 16;
        }
        i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | (unpackedData[unpackedIndex++] & 0xFF) << 8;
        }
        i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] | unpackedData[unpackedIndex++] & 0xFF;
        }
        return pixels;
    }

    private int[] decode8bitMask(byte[] data, int[] destination, int size) {
        int arraySize = size * size;
        int[] pixels = destination == null ? new int[arraySize] : destination;
        assert (pixels.length == arraySize) : "Incorrect pixel buffer size [actual:" + pixels.length + ",expected:" + arraySize + "]";
        assert (data.length == arraySize) : "Incorrect data buffer size [actual:" + data.length + ",expected:" + arraySize + "]";
        for (int i = 0; i < pixels.length; ++i) {
            int n = i;
            pixels[n] = pixels[n] & 0xFFFFFF;
            int n2 = i;
            pixels[n2] = pixels[n2] | (data[i] & 0xFF) << 24;
        }
        return pixels;
    }
}

