/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import amira.AmiraTableEncoder;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.text.TextWindow;

public class AmiraMeshWriter_
implements PlugIn {
    public void run(String arg) {
        String title;
        Object frame;
        GenericDialog gd = new GenericDialog("Choose Window");
        int c = AmiraParameters.addWindowList((GenericDialog)gd, (String)"window", (boolean)false);
        if (c == 0) {
            IJ.error((String)"No window?");
            return;
        }
        if (c > 1) {
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
        }
        if ((frame = WindowManager.getImage((String)(title = gd.getNextChoice()))) == null) {
            frame = WindowManager.getFrame((String)title);
        } else {
            int type = frame.getType();
            if (type != 0 && type != 3) {
                IJ.error((String)"Invalid image type");
                return;
            }
        }
        if (frame == null) {
            IJ.error((String)"No window?");
            return;
        }
        AmiraMeshWriter_.writeImage(frame);
    }

    public static void writeImage(Object frame) {
        SaveDialog od = new SaveDialog("AmiraFile", null, ".am");
        String dir = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            IJ.error((String)"No name was chosen: not saved");
            return;
        }
        if (frame instanceof TextWindow) {
            TextWindow t = (TextWindow)frame;
            AmiraTableEncoder e = new AmiraTableEncoder(t);
            if (!e.write(dir + name)) {
                IJ.error((String)("Could not write to " + dir + name));
            }
            return;
        }
        AmiraMeshEncoder e = new AmiraMeshEncoder(dir + name);
        if (!e.open()) {
            IJ.error((String)("Could not write " + dir + name));
            return;
        }
        if (!e.write((ImagePlus)frame)) {
            IJ.error((String)("Error writing " + dir + name));
        }
    }
}

