/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Triangle_Algorithm
implements PlugInFilter {
    protected ImagePlus image;

    public void run(ImageProcessor ip) {
        int[] histogram = this.getHistogram(ip);
        int split = this.triangleAlgorithm(histogram);
        ip.setThreshold((double)split, 256.0, 0);
        this.image.updateAndDraw();
    }

    public int setup(String args, ImagePlus imp) {
        this.image = imp;
        return 129;
    }

    int[] getHistogram(ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        byte[] pixels = (byte[])ip.getPixels();
        int[] result = new int[256];
        for (int i = 0; i < w * h; ++i) {
            int n = pixels[i] & 0xFF;
            result[n] = result[n] + 1;
        }
        return result;
    }

    int triangleAlgorithm(int[] histogram) {
        int min = 0;
        int max = 0;
        for (int i = 1; i < histogram.length; ++i) {
            if (histogram[min] > histogram[i]) {
                min = i;
                continue;
            }
            if (histogram[max] >= histogram[i]) continue;
            max = i;
        }
        if (min == max) {
            return min;
        }
        double nx = histogram[max] - histogram[min];
        double ny = min - max;
        double d = Math.sqrt(nx * nx + ny * ny);
        nx /= d;
        ny /= d;
        d = nx * (double)min + ny * (double)histogram[min];
        int split = min;
        double splitDistance = 0.0;
        for (int i = min + 1; i <= max; ++i) {
            double newDistance = nx * (double)i + ny * (double)histogram[i] - d;
            if (!(newDistance > splitDistance)) continue;
            split = i;
            splitDistance = newDistance;
        }
        return split;
    }
}

