/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraMeshDecoder;
import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import events.RoiEvent;
import events.RoiListener;
import events.SliceEvent;
import events.SliceListener;
import events.SliceWatcher;
import gui.GuiBuilder;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oldsegmenters.ChoicesDialog;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.LabelThresholder_;
import oldsegmenters.SegmentatorModel;
import vib.SegmentationViewerCanvas;

public class Segmenter_
extends JFrame
implements PlugIn {
    private static final String SAVE_LABELS = "save labels";
    private static final String LABEL_CURRENT = "label current";
    private static final String THRESHOLD = "threshold";
    private static final String THRESHOLD_UNDO = "undo";
    private static final String INTERPOLATOR = "interpolate";
    private static final String DILATE = "dilate";
    private static final String ERODE = "erode";
    private static final String OPEN = "open";
    private static final String CLOSE = "close";
    private static final String CLEAN = "clean";
    JList labelList;
    DefaultListModel labelListModel;
    JSpinner minThreshold;
    JSpinner maxThreshold;
    JLabel markingLabel;

    public Segmenter_() {
        super("VIB Manual Segmenter");
        Controllor controllor = new Controllor();
        MacroInstaller installer = new MacroInstaller();
        installer.install("var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}");
        ImagePlus.addImageListener((ImageListener)controllor);
        for (Frame frame : ImageWindow.getFrames()) {
            if (!(frame instanceof ImageWindow)) continue;
            controllor.imageOpened(((ImageWindow)frame).getImagePlus());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.labelList = Segmenter_.addLabelList(this);
        this.labelListModel = (DefaultListModel)this.labelList.getModel();
        this.labelList.addListSelectionListener(controllor);
        this.markingLabel = new JLabel("current image: <no current image>");
        Box b = new Box(0);
        b.add(this.markingLabel);
        this.add(b);
        GuiBuilder.add2Command((Container)this, (String)LABEL_CURRENT, (String)LABEL_CURRENT, (String)SAVE_LABELS, (String)SAVE_LABELS, (ActionListener)controllor);
        this.minThreshold = GuiBuilder.addLabeledNumericSpinner((Container)this, (String)"min", (int)45, (int)0, (int)255, (ChangeListener)controllor);
        this.maxThreshold = GuiBuilder.addLabeledNumericSpinner((Container)this, (String)"max", (int)255, (int)0, (int)255, (ChangeListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)THRESHOLD, (String)THRESHOLD, (String)THRESHOLD_UNDO, (String)THRESHOLD_UNDO, (ActionListener)controllor);
        GuiBuilder.addCommand((Container)this, (String)INTERPOLATOR, (String)INTERPOLATOR, (ActionListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)DILATE, (String)DILATE, (String)ERODE, (String)ERODE, (ActionListener)controllor);
        GuiBuilder.add2Command((Container)this, (String)OPEN, (String)OPEN, (String)CLOSE, (String)CLOSE, (ActionListener)controllor);
        GuiBuilder.addCommand((Container)this, (String)CLEAN, (String)CLEAN, (ActionListener)controllor);
        this.pack();
    }

    public void run(String arg0) {
        this.setVisible(!this.isVisible());
    }

    public void clearLabelsList() {
        this.labelListModel.clear();
    }

    public void populateLabelList(AmiraParameters params) {
        this.clearLabelsList();
        if (params == null) {
            return;
        }
        for (int id = 0; id < params.getMaterialCount(); ++id) {
            this.labelListModel.addElement(params.getMaterial(id));
        }
    }

    public AmiraParameters.Material getCurrentMaterial() {
        int selectedIndex = this.labelList.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return (AmiraParameters.Material)this.labelListModel.get(selectedIndex);
    }

    private void threshold() {
        LabelThresholder_.min = ((SpinnerNumberModel)this.minThreshold.getModel()).getNumber().intValue();
        LabelThresholder_.max = ((SpinnerNumberModel)this.maxThreshold.getModel()).getNumber().intValue();
        IJ.runPlugIn((String)"LabelThresholder_", (String)"");
    }

    public static JList addLabelList(Container c) {
        DefaultListModel model = new DefaultListModel();
        JList list = new JList(model);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("labels..."), "North");
        JPanel controlPanel = new JPanel(new GridLayout(1, 2));
        panel.add(new JScrollPane(list));
        c.add(panel);
        return list;
    }

    private class Controllor
    implements ActionListener,
    ImageListener,
    WindowFocusListener,
    SliceListener,
    RoiListener,
    ListSelectionListener,
    ChangeListener {
        ImagePlus currentImage;

        private Controllor() {
        }

        public void saveLabelFile() {
            FileInfo info = this.currentImage.getOriginalFileInfo();
            if (info == null) {
                IJ.error((String)"There's no original file name associated with this image.");
                return;
            }
            String directory = info.directory;
            String fileName = info.fileName;
            String suggestedSaveFilename = fileName + ".labels";
            SaveDialog sd = new SaveDialog("Save label annotation as...", directory, suggestedSaveFilename, ".labels");
            if (sd.getFileName() == null) {
                return;
            }
            String savePath = sd.getDirectory() + sd.getFileName();
            File file = new File(savePath);
            if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save label annotation file...", (String)("The file " + savePath + " already exists.\nDo you want to replace it?"))) {
                return;
            }
            IJ.showStatus((String)("Saving label annotations to " + savePath));
            AmiraMeshEncoder e = new AmiraMeshEncoder(savePath);
            if (!e.open()) {
                IJ.error((String)("Could not write to " + savePath));
                return;
            }
            if (e.write(new SegmentatorModel(this.currentImage).getLabelImagePlus())) {
                IJ.showStatus((String)"Label file saved.");
            } else {
                IJ.error((String)("Error writing to: " + savePath));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(Segmenter_.SAVE_LABELS)) {
                this.saveLabelFile();
            } else if (e.getActionCommand().equals(Segmenter_.LABEL_CURRENT)) {
                this.labelCurrent();
            } else if (e.getActionCommand().equals(Segmenter_.THRESHOLD)) {
                Segmenter_.this.threshold();
            } else if (e.getActionCommand().equals(Segmenter_.THRESHOLD_UNDO)) {
                LabelThresholder_.rollback();
            } else if (e.getActionCommand().equals(Segmenter_.INTERPOLATOR)) {
                IJ.runPlugIn((String)"LabelInterpolator_", (String)"");
            } else if (e.getActionCommand().equals(Segmenter_.DILATE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.dilate((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmenter_.ERODE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                System.out.println("eroding");
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.erode((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmenter_.CLOSE)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.close((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmenter_.OPEN)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.open((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (e.getActionCommand().equals(Segmenter_.CLEAN)) {
                SegmentatorModel model = new SegmentatorModel(this.currentImage);
                if (model.getCurrentMaterial() != null) {
                    LabelBinaryOps.close((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    LabelBinaryOps.open((ImageProcessor)model.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), (Roi)this.currentImage.getRoi(), (byte)((byte)model.getCurrentMaterial().id));
                    model.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            }
            if (this.currentImage != null) {
                this.currentImage.updateAndDraw();
            }
        }

        private void loadDefaultMaterials() {
            Segmenter_.this.populateLabelList(AmiraParameters.defaultMaterials());
        }

        public void imageOpened(ImagePlus ip) {
            ip.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageClosed(ImagePlus ip) {
            ip.getWindow().removeWindowFocusListener((WindowFocusListener)this);
        }

        public void imageUpdated(ImagePlus ip) {
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            this.updateCurrent(IJ.getImage());
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        private void updateCurrent(ImagePlus newCurrent) {
            if (newCurrent == this.currentImage) {
                return;
            }
            if (this.currentImage != null) {
                new SliceWatcher(this.currentImage).removeSliceListener((SliceListener)this);
            }
            if (newCurrent == null) {
                Segmenter_.this.markingLabel.setText("current image: <no current image>");
            } else {
                Segmenter_.this.markingLabel.setText("current image: \"" + newCurrent.getTitle() + "\"");
                new SliceWatcher(newCurrent).addSliceListener((SliceListener)this);
                SegmentatorModel currentModel = new SegmentatorModel(newCurrent);
                AmiraParameters newMaterialParams = currentModel.getMaterialParams();
                Segmenter_.this.labelList.removeListSelectionListener(this);
                if (newMaterialParams == null) {
                    Segmenter_.this.clearLabelsList();
                } else {
                    Segmenter_.this.populateLabelList(newMaterialParams);
                }
                Segmenter_.this.labelList.addListSelectionListener(this);
            }
            this.currentImage = newCurrent;
        }

        public void labelCurrent() {
            if (this.currentImage == null) {
                IJ.error((String)"There's no current image.");
                return;
            }
            if (this.currentImage.getType() != 0) {
                IJ.error((String)"You can only label 8 bit images at the moment.");
                return;
            }
            FileInfo info = this.currentImage.getOriginalFileInfo();
            if (info == null) {
                IJ.error((String)"There's no original file name associated with this image. Please save it first.");
                return;
            }
            SegmentatorModel currentModel = new SegmentatorModel(this.currentImage);
            if (currentModel.getLabelImagePlus() != null) {
                IJ.error((String)("The current image (" + this.currentImage.getTitle() + ") already has a label field associated with it."));
                return;
            }
            ImagePlus labelImage = null;
            String directory = info.directory;
            String fileName = info.fileName;
            File possibleLoadFile = new File(directory, fileName + ".labels");
            if (possibleLoadFile.exists()) {
                AmiraMeshDecoder d;
                String[] choices = new String[]{"Load corresponding label file", "Start with an empty label field"};
                ChoicesDialog dialog = new ChoicesDialog((Frame)IJ.getInstance(), "Load default label file?", "There's a label file with the expected corresponding name to this file: '" + possibleLoadFile.getName() + "'.\nDo you want to load it, or start again with an empty label field?", choices);
                if (dialog.optionChosen(0) && (d = new AmiraMeshDecoder()).open(possibleLoadFile.getPath())) {
                    labelImage = new ImagePlus();
                    FileInfo fi = new FileInfo();
                    fi.fileName = possibleLoadFile.getName();
                    fi.directory = possibleLoadFile.getParent();
                    labelImage.setFileInfo(fi);
                    labelImage.setStack("labels in " + possibleLoadFile.getName(), d.getStack());
                    d.parameters.setParameters(labelImage);
                }
            }
            if (labelImage == null) {
                labelImage = IJ.createImage((String)("labels for " + this.currentImage.getTitle()), (String)"8-bit", (int)this.currentImage.getWidth(), (int)this.currentImage.getHeight(), (int)this.currentImage.getStackSize());
                labelImage.setProperty("Info", (Object)AmiraParameters.defaultMaterialsString);
            }
            AmiraParameters parameters = new AmiraParameters(labelImage);
            Segmenter_.this.labelList.removeListSelectionListener(this);
            Segmenter_.this.populateLabelList(parameters);
            Segmenter_.this.labelList.addListSelectionListener(this);
            labelImage.getProcessor().setColorModel(parameters.getColorModel());
            currentModel.setLabelImagePlus(labelImage);
            SegmentationViewerCanvas canvas = new SegmentationViewerCanvas(this.currentImage, labelImage);
            currentModel.setLabelCanvas(canvas);
            if (this.currentImage.getStackSize() > 1) {
                new StackWindow(this.currentImage, (ImageCanvas)canvas);
            } else {
                new ImageWindow(this.currentImage, (ImageCanvas)canvas);
            }
            new SliceWatcher(this.currentImage).addSliceListener((SliceListener)this);
            IJ.runPlugIn((String)"ij.plugin.LutLoader", (String)"grays");
            this.currentImage.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void sliceNumberChanged(SliceEvent e) {
            LabelThresholder_.commit();
        }

        public void roiChanged(RoiEvent e) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            new SegmentatorModel(this.currentImage).setCurrentMaterial(Segmenter_.this.getCurrentMaterial());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if ((e.getSource().equals(Segmenter_.this.minThreshold) || e.getSource().equals(Segmenter_.this.maxThreshold)) && this.currentImage.getRoi() != null) {
                LabelThresholder_.rollback();
                Segmenter_.this.threshold();
            }
        }
    }
}

