/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class EditAmiraParameters_
implements PlugIn,
ActionListener,
TextListener {
    GenericDialog gd;
    Choice windowList;
    TextField keyField;
    TextField valueField;

    public void run(String arg) {
        this.gd = new GenericDialog("Parameters");
        AmiraParameters.addWindowList((GenericDialog)this.gd, (String)"window", (boolean)true);
        this.gd.addStringField("key", "");
        this.gd.addStringField("value", "");
        Vector v = this.gd.getChoices();
        this.windowList = (Choice)v.get(0);
        v = this.gd.getStringFields();
        this.keyField = (TextField)v.get(0);
        this.valueField = (TextField)v.get(1);
        this.keyField.addActionListener(this);
        this.keyField.addTextListener(this);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        String title = this.gd.getNextChoice();
        String key = this.gd.getNextString();
        String value = this.gd.getNextString();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\"') continue;
            value = value.substring(0, i) + "\\" + value.substring(i);
            ++i;
        }
        value = "\"" + value + "\"";
        ImagePlus img = WindowManager.getImage((String)title);
        if (img != null) {
            AmiraParameters p = new AmiraParameters(img);
            p.put(key, (Object)value);
            p.setParameters(img);
            return;
        }
        Frame frame = WindowManager.getFrame((String)title);
        if (frame == null || !(frame instanceof AmiraTable)) {
            IJ.error((String)("Invalid window: " + title));
            return;
        }
        AmiraTable table = (AmiraTable)frame;
        table.getProperties().put(key, value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkForValue();
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.checkForValue();
    }

    void checkForValue() {
        AmiraParameters p;
        int index = this.windowList.getSelectedIndex();
        String title = this.windowList.getItem(index);
        ImagePlus img = WindowManager.getImage((String)title);
        if (img != null) {
            p = new AmiraParameters(img);
        } else {
            AmiraTable table = (AmiraTable)WindowManager.getFrame((String)title);
            p = new AmiraParameters(table.getProperties());
        }
        String key = this.keyField.getText();
        Object o = p.get(key);
        if (o instanceof String) {
            String value = (String)o;
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            this.valueField.setText(value);
        }
    }
}

