/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import vib.InterpolatedImage;

public class Relabel_
implements PlugInFilter,
ActionListener {
    ImagePlus image;
    GenericDialog gd;
    String[] materialList;

    public void run(ImageProcessor ip) {
        if (!AmiraParameters.isAmiraLabelfield((ImagePlus)this.image)) {
            IJ.error((String)"No labelfield!");
            return;
        }
        AmiraParameters params = new AmiraParameters(this.image);
        this.materialList = params.getMaterialList();
        this.gd = new GenericDialog("Relabel Parameters");
        for (int i = 0; i < this.materialList.length; ++i) {
            this.gd.addChoice(this.materialList[i] + ":", this.materialList, this.materialList[i]);
        }
        Button switchSides = new Button("Switch sides");
        switchSides.addActionListener(this);
        Panel panel = new Panel();
        panel.add(switchSides);
        this.gd.addPanel(panel);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return;
        }
        int[] mapping = new int[this.materialList.length];
        for (int i = 0; i < this.materialList.length; ++i) {
            mapping[i] = this.gd.getNextChoiceIndex();
        }
        InterpolatedImage ii = new InterpolatedImage(this.image);
        for (int k = 0; k < ii.d; ++k) {
            for (int j = 0; j < ii.h; ++j) {
                for (int i = 0; i < ii.w; ++i) {
                    int v = ii.getNoInterpol(i, j, k);
                    ii.set(i, j, k, mapping[v]);
                }
            }
            IJ.showProgress((int)(k + 1), (int)ii.d);
        }
        this.image.updateAndDraw();
    }

    public int getOppositeMaterial(int index) {
        String to;
        String m = this.materialList[index];
        if (m.endsWith("_r")) {
            to = "l";
        } else if (m.endsWith("_l")) {
            to = "r";
        } else {
            return -1;
        }
        to = m.substring(0, m.length() - 1) + to;
        for (int i = 0; i < this.materialList.length; ++i) {
            if (!this.materialList[i].equals(to)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Vector v = this.gd.getChoices();
        for (int i = 0; i < this.materialList.length; ++i) {
            Choice c = (Choice)v.get(i);
            int oppositeIndex = this.getOppositeMaterial(c.getSelectedIndex());
            if (oppositeIndex < 0) continue;
            c.select(oppositeIndex);
        }
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 3;
    }
}

