/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.ScaleOffset;

public class Normalizer
implements Enhancement {
    private final ScaleOffset scaleOffset;
    private final double minimum;
    private final double range;

    public static Normalizer createFromVariable(VariableDS var) {
        try {
            Array arr = var.read();
            DataType type = var.getDataType();
            return Normalizer.createFromArray(arr, type);
        }
        catch (IOException e) {
            return new Normalizer(0.0, 1.0, var.getDataType());
        }
    }

    public static Normalizer createFromArray(Array arr, DataType type) {
        SummaryStatistics statistics = Normalizer.calculationHelper(arr);
        if (statistics.getMax() - statistics.getMin() == 0.0) {
            return new Normalizer(0.0, 1.0, type);
        }
        return new Normalizer(statistics.getMin(), statistics.getMax() - statistics.getMin(), type);
    }

    private Normalizer(double minimum, double range, DataType type) {
        this.minimum = minimum;
        this.range = range;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("offset", minimum);
        props.put("scale", 1.0 / range);
        props.put("dtype", (Object)type);
        this.scaleOffset = new ScaleOffset(props);
    }

    private static SummaryStatistics calculationHelper(Array arr) {
        SummaryStatistics sumStat = new SummaryStatistics();
        IndexIterator iterArr = arr.getIndexIterator();
        while (iterArr.hasNext()) {
            Number value = (Number)iterArr.getObjectNext();
            if (Double.isNaN(value.doubleValue())) continue;
            sumStat.addValue(value.doubleValue());
        }
        return sumStat;
    }

    public Array convert(Array arr) {
        return this.scaleOffset.applyScaleOffset(arr);
    }

    @Override
    public double convert(double val) {
        return this.scaleOffset.applyScaleOffset(val);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getRange() {
        return this.range;
    }
}

