/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;

@BuiltinFunction(value={"split/1"})
public class SplitFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        args.get(0).apply(scope, in, sep -> {
            if (!in.isTextual() || !sep.isTextual()) {
                throw new JsonQueryTypeException("split input and separator must be strings");
            }
            ArrayNode row = scope.getObjectMapper().createArrayNode();
            for (String seg : Strings.split(in.asText(), sep.asText())) {
                row.add((JsonNode)new TextNode(seg));
            }
            output.emit((JsonNode)row, null);
        });
    }
}

