/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.binaryop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.internal.tree.binaryop.AlternativeOperatorExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.BooleanAndExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.BooleanOrExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.DivideExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.MinusExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.ModuloExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.MultiplyExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.PlusExpression;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.Assignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexAlternativeAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexDivideAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexMinusAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexModuloAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexMultiplyAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.ComplexPlusAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.assignment.UpdateAssignment;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareGreaterTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareLessEqualTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareLessTest;
import net.thisptr.jackson.jq.internal.tree.binaryop.comparison.CompareNotEqualTest;

public abstract class BinaryOperatorExpression
implements Expression {
    protected Expression lhs;
    protected Expression rhs;
    private String image;

    public BinaryOperatorExpression(Expression lhs, Expression rhs, String image) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.image = image;
    }

    public String toString() {
        return String.format("(%s %s %s)", this.lhs, this.image, this.rhs);
    }

    public static Expression buildTree(List<Expression> exprs, List<Operator> operators, Version version) {
        if (exprs.size() != operators.size() + 1) {
            throw new IllegalArgumentException();
        }
        Stack<Expression> stackExprs = new Stack<Expression>();
        Stack<Operator> stackOperators = new Stack<Operator>();
        Iterator<Expression> iterExpr = exprs.iterator();
        Iterator<Operator> iterOperator = operators.iterator();
        stackExprs.push(iterExpr.next());
        while (iterExpr.hasNext()) {
            Operator op1 = iterOperator.next();
            while (!stackOperators.isEmpty()) {
                Operator op2 = (Operator)((Object)stackOperators.peek());
                if (op1.precedence <= op2.precedence && (op1.precedence != op2.precedence || op1.associativity != Operator.Associativity.LEFT)) break;
                Operator op = (Operator)((Object)stackOperators.pop());
                Expression rhs = (Expression)stackExprs.pop();
                Expression lhs = (Expression)stackExprs.pop();
                stackExprs.push(op.buildTree(lhs, rhs, version));
            }
            stackOperators.push(op1);
            stackExprs.push(iterExpr.next());
        }
        while (!stackOperators.isEmpty()) {
            Operator op = (Operator)((Object)stackOperators.pop());
            Expression rhs = (Expression)stackExprs.pop();
            Expression lhs = (Expression)stackExprs.pop();
            stackExprs.push(op.buildTree(lhs, rhs, version));
        }
        return (Expression)stackExprs.get(0);
    }

    public static enum Operator {
        ASSIGN("=", 6, Associativity.RIGHT, Assignment.class),
        UDPATE("|=", 6, Associativity.RIGHT, UpdateAssignment.class),
        DEFAULT_EQUAL("//=", 6, Associativity.RIGHT, ComplexAlternativeAssignment.class),
        PLUS_EQUAL("+=", 6, Associativity.RIGHT, ComplexPlusAssignment.class),
        MINUS_EQUAL("-=", 6, Associativity.RIGHT, ComplexMinusAssignment.class),
        TIMES_EQUAL("*=", 6, Associativity.RIGHT, ComplexMultiplyAssignment.class),
        DIVIDE_EQUAL("/=", 6, Associativity.RIGHT, ComplexDivideAssignment.class),
        MODULO_EQUAL("%=", 6, Associativity.RIGHT, ComplexModuloAssignment.class),
        DEFAULT("//", 5, Associativity.LEFT, AlternativeOperatorExpression.class),
        OR("or", 4, Associativity.LEFT, BooleanOrExpression.class),
        AND("and", 4, Associativity.LEFT, BooleanAndExpression.class),
        LESS_EQUAL("<=", 3, Associativity.LEFT, CompareLessEqualTest.class),
        LESS("<", 3, Associativity.LEFT, CompareLessTest.class),
        GREATER_EQUAL(">=", 3, Associativity.LEFT, CompareGreaterEqualTest.class),
        GREATER(">", 3, Associativity.LEFT, CompareGreaterTest.class),
        EQUAL("==", 3, Associativity.LEFT, CompareEqualTest.class),
        NOT_EQUAL("!=", 3, Associativity.LEFT, CompareNotEqualTest.class),
        PLUS("+", 2, Associativity.LEFT, PlusExpression.class),
        MINUS("-", 2, Associativity.LEFT, MinusExpression.class),
        MODULO("%", 1, Associativity.LEFT, ModuloExpression.class),
        DIVIDE("/", 1, Associativity.LEFT, DivideExpression.class),
        TIMES("*", 1, Associativity.LEFT, MultiplyExpression.class);

        public final String image;
        public final int precedence;
        public final Associativity associativity;
        public final Class<? extends BinaryOperatorExpression> clazz;
        public final Constructor<? extends BinaryOperatorExpression> constructor;
        public final boolean versionAware;
        private static Map<String, Operator> lookup;

        private Operator(String image, int precedence, Associativity associativity, Class<? extends BinaryOperatorExpression> clazz) {
            boolean versionAware;
            Constructor<? extends BinaryOperatorExpression> ctor;
            this.image = image;
            this.precedence = precedence;
            this.associativity = associativity;
            this.clazz = clazz;
            try {
                try {
                    ctor = clazz.getConstructor(Expression.class, Expression.class, Version.class);
                    versionAware = true;
                }
                catch (NoSuchMethodException e) {
                    ctor = clazz.getConstructor(Expression.class, Expression.class);
                    versionAware = false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.constructor = ctor;
            this.versionAware = versionAware;
        }

        public static Operator fromImage(String image) {
            Operator op = lookup.get(image);
            if (op == null) {
                throw new IllegalArgumentException();
            }
            return op;
        }

        public Expression buildTree(Expression lhs, Expression rhs, Version version) {
            try {
                if (this.versionAware) {
                    return this.constructor.newInstance(lhs, rhs, version);
                }
                return this.constructor.newInstance(lhs, rhs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static {
            lookup = new HashMap<String, Operator>();
            for (Operator op : Operator.values()) {
                lookup.put(op.image, op);
            }
        }

        public static enum Associativity {
            LEFT,
            RIGHT;

        }
    }
}

