/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class LogStream
extends PrintStream {
    private static String outPrefix = "out> ";
    private static String errPrefix = "err >";
    private static PrintStream originalSystemOut = null;
    private static PrintStream originalSystemErr = null;
    private static PrintStream temporarySystemOut = null;
    private static PrintStream temporarySystemErr = null;
    private final String endOfLineSystem = System.getProperty("line.separator");
    private final String endOfLineShort = String.format("\n", new Object[0]);
    private final ByteArrayOutputStream byteStream = (ByteArrayOutputStream)this.out;
    private final String prefix;

    public static void redirectSystem(boolean redirect) {
        if (redirect) {
            LogStream.redirectSystem();
        } else {
            LogStream.revertSystem();
        }
    }

    public static void redirectSystem() {
        LogStream.redirectSystemOut(outPrefix);
        LogStream.redirectSystemErr(errPrefix);
    }

    public static void redirectSystemOut(String prefix) {
        if (originalSystemOut == null) {
            originalSystemOut = System.out;
            temporarySystemOut = new LogStream(prefix);
            System.setOut(temporarySystemOut);
        }
    }

    public static void redirectSystemErr(String prefix) {
        if (originalSystemErr == null) {
            originalSystemErr = System.err;
            temporarySystemErr = new LogStream(prefix);
            System.setErr(temporarySystemErr);
        }
    }

    public static PrintStream getCurrentOutStream() {
        return temporarySystemOut;
    }

    public static PrintStream getCurrentErrStream() {
        return temporarySystemErr;
    }

    public static void revertSystem() {
        LogStream.revertSystemOut();
        LogStream.revertSystemErr();
    }

    public static void revertSystemOut() {
        if (originalSystemOut != null && temporarySystemOut != null) {
            temporarySystemOut.flush();
            temporarySystemOut.close();
            System.setOut(originalSystemOut);
            originalSystemOut = null;
            temporarySystemOut = null;
        }
    }

    public static void revertSystemErr() {
        if (originalSystemErr != null && temporarySystemErr != null) {
            temporarySystemErr.flush();
            temporarySystemErr.close();
            System.setErr(originalSystemErr);
            originalSystemErr = null;
            temporarySystemErr = null;
        }
    }

    public LogStream() {
        super(new ByteArrayOutputStream());
        this.prefix = "";
    }

    private LogStream(String prefix) {
        super(new ByteArrayOutputStream());
        this.prefix = prefix == null ? "" : prefix;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        String msg = new String(b, off, len);
        if (msg.equals(this.endOfLineSystem) || msg.equals(this.endOfLineShort)) {
            this.ejectBuffer();
        } else {
            this.byteStream.write(b, off, len);
            if (msg.endsWith(this.endOfLineSystem) || msg.endsWith(this.endOfLineShort)) {
                this.ejectBuffer();
            }
        }
    }

    @Override
    public void write(int b) {
        this.byteStream.write(b);
    }

    @Override
    public void flush() {
        String msg;
        if (this.byteStream.size() > 0 && ((msg = this.byteStream.toString()).endsWith(this.endOfLineSystem) || msg.endsWith(this.endOfLineShort))) {
            this.ejectBuffer();
        }
        super.flush();
    }

    @Override
    public void close() {
        super.close();
    }

    private void ejectBuffer() {
        IJ.log(this.prefix + this.byteStream.toString());
        this.byteStream.reset();
    }
}

