/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.filter.EDM;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextField;
import java.util.Vector;

public class RoiEnlarger
implements PlugIn,
DialogListener {
    private static final String DISTANCE_KEY = "enlarger.distance";
    private static final String USE_PIXELS_KEY = "enlarger.pixels";
    private double defaultDistance = Prefs.get("enlarger.distance", 15.0);
    private boolean defaultUsePixels = Prefs.get("enlarger.pixels", false);
    private Calibration cal;
    private Label unitsLabel;

    @Override
    public void run(String arg) {
        Roi roi2;
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        if (roi == null || roi.isLine()) {
            IJ.error("Enlarge", "This command requires an area selection");
            return;
        }
        if (!imp.okToDeleteRoi()) {
            return;
        }
        double n = this.showDialog(imp, this.defaultDistance);
        if (Double.isNaN(n)) {
            return;
        }
        Prefs.set(DISTANCE_KEY, this.defaultDistance);
        Prefs.set(USE_PIXELS_KEY, this.defaultUsePixels);
        Roi roi3 = roi2 = Math.abs(n) < 256.0 ? RoiEnlarger.enlarge255(roi, n) : RoiEnlarger.enlarge(roi, n);
        if (roi2 != null) {
            imp.setRoi(roi2);
            Roi.setPreviousRoi(roi);
            this.defaultDistance = n;
        }
        int pixels = (int)Math.round(n);
        Recorder.recordCall("RoiEnlarger.enlarge(imp, " + pixels + ");");
    }

    public static void enlarge(ImagePlus imp, int pixels) {
        Roi roi2;
        Roi roi = imp.getRoi();
        if (roi == null || roi.isLine() || roi instanceof PointRoi) {
            return;
        }
        Roi roi3 = roi2 = Math.abs(pixels) < 256 ? RoiEnlarger.enlarge255(roi, pixels) : RoiEnlarger.enlarge(roi, (double)pixels);
        if (roi2 != null) {
            imp.setRoi(roi2);
        }
    }

    public double showDialog(ImagePlus imp, double pixels) {
        this.cal = imp.getCalibration();
        boolean scaled = this.cal.scaled();
        double pixelWidth = this.cal.pixelWidth;
        boolean xyScaleDifferent = scaled && this.cal.pixelWidth != this.cal.pixelHeight;
        boolean usePixels = this.defaultUsePixels;
        double n = pixels;
        int decimalPlaces = 0;
        if (scaled && !usePixels) {
            decimalPlaces = RoiEnlarger.getDecimalPlaces(pixelWidth, n *= pixelWidth);
        }
        GenericDialog gd = new GenericDialog("Enlarge Selection");
        gd.addNumericField("Enlarge by", n, decimalPlaces);
        String units = scaled && !usePixels ? this.cal.getUnits() + "       " : "pixels ";
        gd.addToSameRow();
        gd.addMessage(units.replace('\n', ' '));
        this.unitsLabel = (Label)gd.getMessage();
        if (scaled) {
            gd.setInsets(0, 20, 0);
            gd.addCheckbox("Pixel units", usePixels);
        }
        gd.setInsets(10, 0, 0);
        gd.addMessage("Enter negative number to shrink", null, Color.darkGray);
        if (xyScaleDifferent) {
            gd.setInsets(5, 0, 0);
            gd.addMessage(" \n ", null, Color.RED);
        }
        gd.addDialogListener(this);
        if (xyScaleDifferent && Macro.getOptions() == null) {
            this.updateWarning(gd);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return Double.NaN;
        }
        n = gd.getNextNumber();
        if (scaled) {
            usePixels = gd.getNextBoolean();
        }
        this.defaultDistance = pixels = usePixels ? n : n / pixelWidth;
        this.defaultUsePixels = usePixels;
        return pixels;
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        boolean usePixels;
        Vector checkboxes = gd.getCheckboxes();
        Checkbox usePixelsCbx = checkboxes == null ? null : (Checkbox)checkboxes.get(0);
        double n = gd.getNextNumber();
        boolean bl = usePixels = this.cal.scaled() ? gd.getNextBoolean() : true;
        if (e != null && e.getSource() == usePixelsCbx) {
            boolean xyScaleDifferent;
            double pixelWidth = this.cal.pixelWidth;
            int decimalPlaces = 0;
            if (usePixels) {
                n /= pixelWidth;
            } else {
                decimalPlaces = RoiEnlarger.getDecimalPlaces(pixelWidth, n *= pixelWidth);
            }
            TextField numberField = (TextField)gd.getNumericFields().get(0);
            numberField.setText(IJ.d2s(n, decimalPlaces));
            if (this.unitsLabel != null) {
                this.unitsLabel.setText(usePixels ? "pixels" : this.cal.getUnits());
            }
            boolean bl2 = xyScaleDifferent = this.cal.scaled() && this.cal.pixelWidth != this.cal.pixelHeight;
            if (xyScaleDifferent && usePixelsCbx != null) {
                this.updateWarning(gd);
            }
        }
        return !gd.invalidNumber();
    }

    private void updateWarning(GenericDialog gd) {
        Checkbox usePixelsCbx = (Checkbox)gd.getCheckboxes().get(0);
        MultiLineLabel warningLabel = (MultiLineLabel)gd.getMessage();
        boolean showWarning = !usePixelsCbx.getState();
        warningLabel.setText(showWarning ? "WARNING: x & y scales differ\nConversion to pixels uses x scale" : " \n ");
    }

    private static int getDecimalPlaces(double pixelWidth, double number) {
        if (number == (double)((int)number) || pixelWidth == 1.0) {
            return 0;
        }
        int decimalPlaces = (int)(-Math.log10(pixelWidth) + 1.9);
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        return decimalPlaces;
    }

    public static Roi enlarge(Roi roi, double pixels) {
        if (pixels == 0.0) {
            return roi;
        }
        int type = roi.getType();
        int n = (int)Math.round(pixels);
        if (type == 0 || type == 1) {
            return RoiEnlarger.enlargeRectOrOval(roi, n);
        }
        if (n < 0) {
            return RoiEnlarger.shrink(roi, -n);
        }
        Rectangle bounds = roi.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        ByteProcessor ip = new ByteProcessor(width += 2 * n + 2, height += 2 * n + 2);
        ip.invert();
        roi.setLocation(n + 1, n + 1);
        ip.setColor(0);
        ip.fill(roi);
        ((ImageProcessor)ip).setThreshold(0.0, 0.0, 2);
        Roi roi2 = new ThresholdToSelection().convert(ip);
        Rectangle bounds2 = roi2.getBounds();
        int xoffset = bounds2.x - (n + 1);
        int yoffset = bounds2.y - (n + 1);
        roi.setLocation(bounds.x, bounds.y);
        FloatProcessor edm = new EDM().makeFloatEDM(ip, 0, false);
        edm.setThreshold(0.0, n, 2);
        roi2 = new ThresholdToSelection().convert(edm);
        if (roi2 == null) {
            return roi;
        }
        roi2.copyAttributes(roi);
        roi2.setLocation(bounds.x - n + xoffset, bounds.y - n + yoffset);
        if (roi.getStroke() != null) {
            roi2.setStroke(roi.getStroke());
        }
        return roi2;
    }

    private static Roi enlargeRectOrOval(Roi roi, int n) {
        Rectangle bounds = roi.getBounds();
        bounds.x -= n;
        bounds.y -= n;
        bounds.width += 2 * n;
        bounds.height += 2 * n;
        if (bounds.width <= 0 || bounds.height <= 0) {
            return roi;
        }
        Roi roi2 = null;
        roi2 = roi.getType() == 0 ? new Roi(bounds.x, bounds.y, bounds.width, bounds.height) : new OvalRoi(bounds.x, bounds.y, bounds.width, bounds.height);
        roi2.copyAttributes(roi);
        return roi2;
    }

    private static Roi shrink(Roi roi, int n) {
        Rectangle bounds = roi.getBounds();
        int width = bounds.width + 2;
        int height = bounds.height + 2;
        ByteProcessor ip = new ByteProcessor(width, height);
        roi.setLocation(1, 1);
        ip.setColor(255);
        ip.fill(roi);
        roi.setLocation(bounds.x, bounds.y);
        FloatProcessor edm = new EDM().makeFloatEDM(ip, 0, false);
        edm.setThreshold(n + 1, 3.4028234663852886E38, 2);
        Roi roi2 = new ThresholdToSelection().convert(edm);
        if (roi2 == null) {
            return roi;
        }
        Rectangle bounds2 = roi2.getBounds();
        if (bounds2.width <= 0 && bounds2.height <= 0) {
            return roi;
        }
        roi2.copyAttributes(roi);
        roi2.setLocation(bounds.x + bounds2.x - 1, bounds.y + bounds2.y - 1);
        return roi2;
    }

    public static Roi enlarge255(Roi roi, double pixels) {
        if (pixels == 0.0) {
            return roi;
        }
        int type = roi.getType();
        int n = (int)Math.round(pixels);
        if (type == 0 || type == 1) {
            return RoiEnlarger.enlargeRectOrOval(roi, n);
        }
        if (n < 0) {
            return RoiEnlarger.shrink255(roi, -n);
        }
        Rectangle bounds = roi.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        ByteProcessor ip = new ByteProcessor(width += 2 * n + 2, height += 2 * n + 2);
        ip.invert();
        roi.setLocation(n + 1, n + 1);
        ip.setColor(0);
        ip.fill(roi);
        ((ImageProcessor)ip).setThreshold(0.0, 0.0, 2);
        Roi roi2 = new ThresholdToSelection().convert(ip);
        Rectangle bounds2 = roi2.getBounds();
        int xoffset = bounds2.x - (n + 1);
        int yoffset = bounds2.y - (n + 1);
        roi.setLocation(bounds.x, bounds.y);
        boolean bb = Prefs.blackBackground;
        Prefs.blackBackground = true;
        new EDM().toEDM(ip);
        Prefs.blackBackground = bb;
        ((ImageProcessor)ip).setThreshold(0.0, n, 2);
        roi2 = new ThresholdToSelection().convert(ip);
        if (roi2 == null) {
            return roi;
        }
        roi2.copyAttributes(roi);
        roi2.setLocation(bounds.x - n + xoffset, bounds.y - n + yoffset);
        if (roi.getStroke() != null) {
            roi2.setStroke(roi.getStroke());
        }
        return roi2;
    }

    private static Roi shrink255(Roi roi, int n) {
        Rectangle bounds = roi.getBounds();
        int width = bounds.width + 2;
        int height = bounds.height + 2;
        ByteProcessor ip = new ByteProcessor(width, height);
        roi.setLocation(1, 1);
        ip.setColor(255);
        ip.fill(roi);
        roi.setLocation(bounds.x, bounds.y);
        boolean bb = Prefs.blackBackground;
        Prefs.blackBackground = true;
        new EDM().toEDM(ip);
        Prefs.blackBackground = bb;
        ((ImageProcessor)ip).setThreshold(n + 1, 255.0, 2);
        Roi roi2 = new ThresholdToSelection().convert(ip);
        if (roi2 == null) {
            return roi;
        }
        Rectangle bounds2 = roi2.getBounds();
        if (bounds2.width <= 0 && bounds2.height <= 0) {
            return roi;
        }
        roi2.copyAttributes(roi);
        roi2.setLocation(bounds.x + bounds2.x - 1, bounds.y + bounds2.y - 1);
        return roi2;
    }
}

