/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.Blitter;
import ij.process.ByteBlitter;
import ij.process.ByteProcessor;
import ij.process.ColorBlitter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.Date;

public class SurfacePlotter
implements PlugIn {
    static final int fontSize = 14;
    static int plotWidth = 350;
    static int polygonMultiplier = 100;
    static boolean oneToOne;
    static boolean firstTime;
    static boolean showWireframe;
    static boolean showGrayscale;
    static boolean showAxis;
    static boolean whiteBackground;
    static boolean blackFill;
    static boolean smooth;
    ImagePlus img;
    int[] x;
    int[] y;
    boolean invertedLut;
    double angleInDegrees = 35.0;
    double angle = this.angleInDegrees / 360.0 * 2.0 * Math.PI;
    double angle2InDegrees = 15.0;
    double angle2 = this.angle2InDegrees / 360.0 * 2.0 * Math.PI;
    double yinc2 = Math.sin(this.angle2);
    double p1x;
    double p1y;
    double p2x;
    double p2y;
    double p3x;
    double p3y;
    LookUpTable lut;

    @Override
    public void run(String arg) {
        this.img = WindowManager.getCurrentImage();
        if (this.img == null) {
            IJ.noImage();
            return;
        }
        if (this.img.getType() == 4) {
            IJ.error("Surface Plotter", "Grayscale or pseudo-color image required");
            return;
        }
        this.invertedLut = this.img.getProcessor().isInvertedLut();
        if (firstTime) {
            if (this.invertedLut) {
                whiteBackground = true;
            }
            firstTime = false;
        }
        if (!this.showDialog()) {
            return;
        }
        int stackFlags = IJ.setupDialog(this.img, 0);
        if (stackFlags == 4096) {
            return;
        }
        Date start = new Date();
        this.lut = this.img.createLut();
        if (stackFlags == 32 && this.img.getStack().getSize() > 1) {
            ImageStack stackSource = this.img.getStack();
            ImageProcessor ip = stackSource.getProcessor(1);
            ImageProcessor plot = this.makeSurfacePlot(ip);
            ImageStack stack = new ImageStack(plot.getWidth(), plot.getHeight());
            stack.setColorModel(plot.getColorModel());
            for (int i = 1; i <= stackSource.getSize(); ++i) {
                stack.addSlice(null, plot.duplicate().getPixels());
            }
            stack.setPixels(plot.getPixels(), 1);
            ImagePlus plots = new ImagePlus("Surface Plot", stack);
            plots.show();
            for (int i = 2; i <= stackSource.getSize(); ++i) {
                IJ.showStatus("Drawing slice " + i + "... (" + 100 * (i - 1) / stackSource.getSize() + "% done)");
                ip = stackSource.getProcessor(i);
                plot = this.makeSurfacePlot(ip);
                ImageWindow win = plots.getWindow();
                if (win == null || !win.isClosed()) {
                    stack.setPixels(plot.getPixels(), i);
                    plots.setSlice(i);
                    continue;
                }
                break;
            }
        } else {
            ImageProcessor plot = this.makeSurfacePlot(this.img.getProcessor());
            new ImagePlus("Surface Plot", plot).show();
        }
        Date end = new Date();
        long lstart = start.getTime();
        long lend = end.getTime();
        long difference = lend - lstart;
        IJ.register(SurfacePlotter.class);
        IJ.showStatus("Done in " + difference + " msec.");
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Surface Plotter");
        gd.addNumericField("Polygon Multiplier (10-200%):", polygonMultiplier, 0);
        gd.addCheckbox("Draw_Wireframe", showWireframe);
        gd.addCheckbox("Shade", showGrayscale);
        gd.addCheckbox("Draw_Axis", showAxis);
        gd.addCheckbox("Source Background is Lighter", whiteBackground);
        gd.addCheckbox("Fill Plot Background with Black", blackFill);
        gd.addCheckbox("One Polygon Per Line", oneToOne);
        gd.addCheckbox("Smooth", smooth);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        polygonMultiplier = (int)gd.getNextNumber();
        showWireframe = gd.getNextBoolean();
        showGrayscale = gd.getNextBoolean();
        showAxis = gd.getNextBoolean();
        whiteBackground = gd.getNextBoolean();
        blackFill = gd.getNextBoolean();
        oneToOne = gd.getNextBoolean();
        smooth = gd.getNextBoolean();
        if (showWireframe && !showGrayscale) {
            blackFill = false;
        }
        if (polygonMultiplier > 400) {
            polygonMultiplier = 400;
        }
        if (polygonMultiplier < 10) {
            polygonMultiplier = 10;
        }
        return true;
    }

    public ImageProcessor makeSurfacePlot(ImageProcessor ip) {
        ip = ip.duplicate();
        Rectangle roi = this.img.getProcessor().getRoi();
        ip.setRoi(roi);
        if (!(ip instanceof ByteProcessor)) {
            ip.setMinAndMax(this.img.getProcessor().getMin(), this.img.getProcessor().getMax());
            ip = ip.convertToByte(true);
            ip.setRoi(roi);
        }
        double angle = this.angleInDegrees / 360.0 * 2.0 * Math.PI;
        int polygons = (int)((double)plotWidth * ((double)polygonMultiplier / 100.0) / 4.0);
        if (oneToOne) {
            polygons = roi.height;
        }
        double xinc = 0.8 * (double)plotWidth * Math.sin(angle) / (double)polygons;
        double yinc = 0.8 * (double)plotWidth * Math.cos(angle) / (double)polygons;
        IJ.showProgress(0.01);
        ip.setInterpolate(!oneToOne);
        ip = ip.resize(plotWidth, polygons);
        int width = ip.getWidth();
        int height = ip.getHeight();
        double min = ip.getMin();
        double max = ip.getMax();
        if (this.invertedLut) {
            ip.invert();
        }
        if (whiteBackground) {
            ip.invert();
        }
        if (smooth) {
            ip.smooth();
        }
        this.x = new int[width + 2];
        this.y = new int[width + 2];
        double xstart = 10.0;
        if (xinc < 0.0) {
            xstart += Math.abs(xinc) * (double)polygons;
        }
        ByteProcessor ipProfile = new ByteProcessor(width, (int)(256.0 + (double)width * this.yinc2));
        ipProfile.setValue(255.0);
        ipProfile.fill();
        double ystart = this.yinc2 * (double)width;
        int ybase = (int)(ystart + 0.5);
        int windowWidth = (int)((double)plotWidth + (double)polygons * Math.abs(xinc) + 20.0);
        int windowHeight = (int)((double)ipProfile.getHeight() + (double)polygons * yinc + 10.0);
        if (showAxis) {
            windowWidth += 80;
            windowHeight += 20;
            this.p1x = xstart += 70.0;
            this.p1y = (ystart += 10.0) + 255.0;
            this.p2x = xstart + xinc * (double)height;
            this.p2y = this.p1y + yinc * (double)height;
            this.p3x = this.p2x + (double)width - 1.0;
            this.p3y = this.p2y - this.yinc2 * (double)width;
        }
        if (showGrayscale) {
            int[] column = new int[255];
            for (int row = 0; row < 255; ++row) {
                int v = whiteBackground ? row : 255 - row;
                column[row] = v;
            }
            int base = ipProfile.getHeight() - 255;
            for (int col = 0; col < width; ++col) {
                ipProfile.putColumn(col, base - (int)(this.yinc2 * (double)col + 0.5), column, 255);
            }
        } else {
            ipProfile.setValue(254.0);
            ipProfile.fill();
        }
        ipProfile.snapshot();
        ImageProcessor ip2 = new ByteProcessor(windowWidth, windowHeight);
        if (showGrayscale) {
            ip2.setColorModel(ip.getColorModel());
            if (this.invertedLut) {
                ip2.invertLut();
            }
            this.fixLut(ip2);
        }
        if (!blackFill) {
            ip2.setValue(255.0);
        } else {
            ip2.setValue(0.0);
        }
        ip2.fill();
        for (int row = 0; row < height; ++row) {
            double[] profile = ip.getLine(0.0, row, width - 1, row);
            this.clearAboveProfile(ipProfile, profile, width, this.yinc2);
            int ixstart = (int)(xstart + 0.5);
            int iystart = (int)(ystart + 0.5);
            ip2.copyBits(ipProfile, ixstart, iystart - ybase, 2);
            ipProfile.reset();
            if (showWireframe) {
                ip2.setValue(0.0);
                double ydelta = 0.0;
                ip2.moveTo(ixstart, (int)(ystart + 255.5 - profile[0]));
                for (int i = 1; i < width; ++i) {
                    ip2.lineTo(ixstart + i, (int)(ystart + 255.5 - (profile[i] + (ydelta += this.yinc2))));
                }
                ip2.drawLine(ixstart, iystart + 255, ixstart + width - 1, (int)(ystart + 255.5 - ydelta));
                ip2.drawLine(ixstart, iystart + 255 - (int)(profile[0] + 0.5), ixstart, iystart + 255);
                ip2.drawLine(ixstart + width - 1, (int)(ystart + 255.5 - ydelta), ixstart + width - 1, (int)(ystart + 255.5 - (profile[width - 1] + ydelta)));
            }
            xstart += xinc;
            ystart += yinc;
            if (row % 10 != 0) continue;
            IJ.showProgress((double)row / (double)height);
        }
        IJ.showProgress(1.0);
        if (this.invertedLut) {
            ip.invert();
            ip.invertLut();
        }
        if (whiteBackground) {
            ip.invert();
        }
        if (showAxis) {
            if (!this.lut.isGrayscale() && showGrayscale) {
                ip2 = ip2.convertToRGB();
            }
            this.drawAndLabelAxis(ip, ip2, roi);
        }
        if (this.img.getStackSize() == 1) {
            ip2 = this.trimPlot(ip2, ybase);
        }
        return ip2;
    }

    void drawAndLabelAxis(ImageProcessor ip, ImageProcessor ip2, Rectangle roi) {
        double max;
        double min;
        ip2.setFont(new Font("SansSerif", 0, 14));
        if (!blackFill) {
            ip2.setColor(Color.black);
        } else {
            ip2.setColor(Color.white);
        }
        ip2.setAntialiasedText(true);
        Calibration cal = this.img.getCalibration();
        String s = cal.getValueUnit();
        if (s.equals("Gray Value")) {
            s = "";
        }
        int w = ip2.getFontMetrics().stringWidth(s);
        this.drawAxis(ip2, (int)this.p1x, (int)this.p1y - 255, (int)this.p1x, (int)this.p1y, s, 10, -1, 0, 1);
        if (this.img.getBitDepth() == 8) {
            min = 0.0;
            max = 255.0;
        } else {
            min = this.img.getProcessor().getMin();
            max = this.img.getProcessor().getMax();
        }
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
        }
        ip2.setAntialiasedText(true);
        s = String.valueOf((double)Math.round(max * 10.0) / 10.0);
        w = ip.getFontMetrics().stringWidth(s);
        int h = ip.getFontMetrics().getHeight();
        ip2.drawString(s, (int)this.p1x - 18 - w, (int)this.p1y - 255 + h / 2);
        s = String.valueOf((double)Math.round(min * 10.0) / 10.0);
        w = ip2.getFontMetrics().stringWidth(s);
        ip2.drawString(s, (int)this.p1x - 18 - w, (int)this.p1y + h / 2);
        boolean unitsMatch = cal.getXUnit().equals(cal.getYUnit());
        String xunits = unitsMatch ? cal.getUnits() : cal.getYUnit();
        s = (double)Math.round((double)roi.height * cal.pixelHeight * 10.0) / 10.0 + " " + xunits;
        w = ip2.getFontMetrics().stringWidth(s);
        this.drawAxis(ip2, (int)this.p1x, (int)this.p1y, (int)this.p2x, (int)this.p2y, s, 10, -1, 1, 1);
        String yunits = unitsMatch ? cal.getUnits() : cal.getXUnit();
        s = (double)Math.round((double)roi.width * cal.pixelWidth * 10.0) / 10.0 + " " + yunits;
        w = ip2.getFontMetrics().stringWidth(s);
        this.drawAxis(ip2, (int)this.p2x, (int)this.p2y, (int)this.p3x, (int)this.p3y, s, 10, 1, -1, 1);
    }

    void drawAxis(ImageProcessor ip, int x1, int y1, int x2, int y2, String label, int offset, int offsetXDirection, int offsetYDirection, int labelSide) {
        if (blackFill) {
            ip.setColor(Color.white);
        } else {
            ip.setColor(Color.black);
        }
        double m = -((double)(y2 - y1)) / (double)(x2 - x1);
        if (m == 0.0) {
            m = 1.0E-4;
        }
        double mTangent = -1.0 / m;
        double theta = Math.atan(mTangent);
        int dy = -offsetXDirection * (int)(7.0 * Math.sin(theta));
        int dx = -offsetXDirection * (int)(7.0 * Math.cos(theta));
        ip.drawLine(x1 += offsetXDirection * (int)((double)offset * Math.cos(theta)), y1 += offsetYDirection * (int)((double)offset * Math.sin(theta)), x2 += offsetXDirection * (int)((double)offset * Math.cos(theta)), y2 += offsetYDirection * (int)((double)offset * Math.sin(theta)));
        ip.drawLine(x1, y1, x1 + dx, y1 - dy);
        ip.drawLine(x2, y2, x2 + dx, y2 - dy);
        ImageProcessor ipText = this.drawString(ip, label, (int)(Math.atan(m) / 2.0 / Math.PI * 360.0));
        if (blackFill) {
            ipText.invert();
        }
        Blitter b = ip instanceof ByteProcessor ? new ByteBlitter((ByteProcessor)ip) : new ColorBlitter((ColorProcessor)ip);
        Color c = blackFill ? Color.black : Color.white;
        b.setTransparentColor(c);
        int xloc = (x1 + x2) / 2 - ipText.getWidth() / 2 + offsetXDirection * labelSide * (int)(15.0 * Math.cos(theta));
        int yloc = (y1 + y2) / 2 - ipText.getHeight() / 2 + offsetYDirection * labelSide * (int)(15.0 * Math.sin(theta));
        b.copyBits(ipText, xloc, yloc, 2);
    }

    ImageProcessor drawString(ImageProcessor ip, String s, int a) {
        int w = ip.getFontMetrics().stringWidth(s);
        int h = ip.getFontMetrics().getHeight();
        double r = Math.sqrt(w / 2 * (w / 2) + h / 2 * (h / 2));
        double aR = (double)a / 360.0 * 2.0 * Math.PI;
        double aBaseR = Math.acos((double)(w / 2) / r);
        int ipW = (int)Math.abs(r * Math.cos(aBaseR + aR));
        int ipH = (int)Math.abs(r * Math.sin(aBaseR + aR));
        if ((int)Math.abs(r * Math.cos(-aBaseR + aR)) > ipW) {
            ipW = (int)Math.abs(r * Math.cos(-aBaseR + aR));
        }
        if ((int)Math.abs(r * Math.sin(-aBaseR + aR)) > ipH) {
            ipH = (int)Math.abs(r * Math.sin(-aBaseR + aR));
        }
        ipH *= 2;
        int tW = w;
        if ((ipW *= 2) > w) {
            tW = ipW;
        }
        ImageProcessor ipText = new ByteProcessor(tW, ipH);
        ipText.setFont(new Font("SansSerif", 0, 14));
        ((ImageProcessor)ipText).setColor(Color.white);
        ipText.fill();
        ((ImageProcessor)ipText).setColor(Color.black);
        ipText.setAntialiasedText(true);
        ipText.drawString(s, tW / 2 - w / 2, ipH / 2 + h / 2);
        ipText.setInterpolate(true);
        ((ImageProcessor)ipText).rotate(-a);
        ipText.setRoi(tW / 2 - ipW / 2, 0, ipW, ipH);
        ipText = ((ImageProcessor)ipText).crop();
        return ipText;
    }

    void clearAboveProfile(ImageProcessor ipProfile, double[] profile, int width, double yinc2) {
        byte[] pixels = (byte[])ipProfile.getPixels();
        double ydelta = 0.0;
        int height = ipProfile.getHeight();
        for (int x = 0; x < width; ++x) {
            int top = height - (int)(profile[x] + (ydelta += yinc2));
            int y = 0;
            int index = x;
            while (y < top) {
                pixels[index] = -1;
                ++y;
                index += width;
            }
        }
    }

    ImageProcessor trimPlot(ImageProcessor plot, int maxTrim) {
        int background = plot.getPixel(0, 0);
        int width = plot.getWidth();
        int height = plot.getHeight();
        int trim = maxTrim - 5;
        block0: for (int y = 0; y < maxTrim - 5; ++y) {
            for (int x = 0; x < width; ++x) {
                if (plot.getPixel(x, y) == background) continue;
                trim = y - 5;
                break block0;
            }
        }
        if (trim > 10) {
            plot.setRoi(0, trim, width, height - trim);
            plot = plot.crop();
        }
        return plot;
    }

    void fixLut(ImageProcessor ip) {
        if (!this.lut.isGrayscale() && this.lut.getMapSize() == 256) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                for (int x = 0; x < ip.getWidth(); ++x) {
                    if (ip.getPixelValue(x, y) == 0.0f) {
                        ip.putPixelValue(x, y, 1.0);
                        continue;
                    }
                    if (ip.getPixelValue(x, y) != 255.0f) continue;
                    ip.putPixelValue(x, y, 254.0);
                }
            }
            byte[] rLUT = this.lut.getReds();
            byte[] gLUT = this.lut.getGreens();
            byte[] bLUT = this.lut.getBlues();
            rLUT[0] = 0;
            gLUT[0] = 0;
            bLUT[0] = 0;
            rLUT[255] = -1;
            gLUT[255] = -1;
            bLUT[255] = -1;
            ip.setColorModel(new IndexColorModel(8, 256, rLUT, gLUT, bLUT));
        }
    }

    static {
        firstTime = true;
        showWireframe = false;
        showGrayscale = true;
        showAxis = true;
        whiteBackground = false;
        blackFill = false;
        smooth = true;
    }
}

