/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.frame.ColorCanvas;
import ij.plugin.frame.ColorGenerator;
import ij.plugin.frame.PlugInDialog;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import javax.swing.BoxLayout;

public class ColorPicker
extends PlugInDialog {
    public static int ybase = 2;
    private int colorWidth = 22;
    private int colorHeight = 16;
    private int columns = 5;
    private int rows = 20;
    private static final String LOC_KEY = "cp.loc";
    private static ColorPicker instance;
    private ColorGenerator cg;
    private Canvas colorCanvas;
    TextField colorField;

    public ColorPicker() {
        super("CP");
        if (instance != null) {
            instance.toFront();
            return;
        }
        double scale = Prefs.getGuiScale();
        instance = this;
        WindowManager.addWindow(this);
        int width = (int)((double)(this.columns * this.colorWidth) * scale);
        int height = (int)((double)(this.rows * this.colorHeight + ybase) * scale);
        this.addKeyListener(IJ.getInstance());
        this.setLayout(new BorderLayout());
        this.cg = new ColorGenerator(width, height, new int[width * height]);
        this.cg.drawColors(this.colorWidth, this.colorHeight, this.columns, this.rows);
        this.colorCanvas = new ColorCanvas(width, height, this, this.cg, scale);
        Panel panel = new Panel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.colorCanvas);
        String hexColor = Colors.colorToString(Toolbar.getForegroundColor());
        this.colorField = new TextField(hexColor + " ", 7);
        this.colorField.setEditable(false);
        this.colorField.select(hexColor.length(), hexColor.length());
        GUI.scale(this.colorField);
        panel.add(this.colorField);
        this.add(panel);
        this.setResizable(false);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.centerOnImageJScreen(this);
        }
        this.show();
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        IJ.notifyEventListeners(2);
    }

    public static void update() {
        ColorPicker cp = instance;
        if (cp != null && cp.colorCanvas != null) {
            cp.cg.refreshBackground(false);
            cp.cg.refreshForeground(false);
            cp.colorCanvas.repaint();
            cp.colorField.setText(Colors.colorToString(Toolbar.getForegroundColor()));
        }
    }
}

