/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassLoaderPlus
extends URLClassLoader {
    protected static Set<ClassLoader> frozen = new HashSet<ClassLoader>();
    protected static Map<URLClassLoader, List<URL>> urlsMap = new HashMap<URLClassLoader, List<URL>>();
    protected static Method addURL;
    private static Pattern versionPattern;

    public static URLClassLoader getInImageJDirectory(URLClassLoader classLoader, String ... relativePaths) {
        try {
            File directory = new File(ClassLoaderPlus.getImageJDir());
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>(relativePaths.length);
            for (String path : relativePaths) {
                ClassLoaderPlus.discoverDependencies(new File(directory, path), urls);
            }
            return ClassLoaderPlus.get(classLoader, urls.toArray(new URL[urls.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Uh oh: " + e.getMessage());
        }
    }

    private static void discoverDependencies(File jarFile, Set<URL> result) {
        File versioned = ClassLoaderPlus.getPossiblyVersionedFile(jarFile);
        if (!versioned.exists()) {
            return;
        }
        try {
            URL url = versioned.toURI().toURL();
            if (result.contains(url)) {
                return;
            }
            result.add(url);
            Manifest manifest = new JarFile(versioned).getManifest();
            if (manifest == null) {
                return;
            }
            String classPath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH);
            if (classPath == null) {
                return;
            }
            File directory = jarFile.getParentFile();
            if (directory == null) {
                directory = jarFile.getAbsoluteFile().getParentFile();
            }
            for (String path : classPath.split(" +")) {
                ClassLoaderPlus.discoverDependencies(new File(directory, path), result);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static URLClassLoader get(URLClassLoader classLoader, File ... files) {
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
            return ClassLoaderPlus.get(classLoader, urls);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Uh oh: " + e.getMessage());
        }
    }

    public static URLClassLoader get(URLClassLoader classLoader, URL ... urls) {
        if (classLoader == null) {
            ClassLoader currentClassLoader = ClassLoaderPlus.class.getClassLoader();
            if (currentClassLoader instanceof URLClassLoader) {
                classLoader = (URLClassLoader)currentClassLoader;
            } else {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (contextClassLoader instanceof URLClassLoader) {
                    classLoader = (URLClassLoader)contextClassLoader;
                }
            }
        }
        if (classLoader == null) {
            return new ClassLoaderPlus(urls);
        }
        for (URL url : urls) {
            ClassLoaderPlus.add(classLoader, url);
        }
        return classLoader;
    }

    public static URLClassLoader getRecursivelyInImageJDirectory(URLClassLoader classLoader, String ... relativePaths) {
        return ClassLoaderPlus.getRecursivelyInImageJDirectory(classLoader, false, relativePaths);
    }

    public static URLClassLoader getRecursivelyInImageJDirectory(URLClassLoader classLoader, boolean onlyJars, String ... relativePaths) {
        try {
            File directory = new File(ClassLoaderPlus.getImageJDir());
            File[] files = new File[relativePaths.length];
            for (int i = 0; i < files.length; ++i) {
                classLoader = ClassLoaderPlus.getRecursively(classLoader, onlyJars, new File(directory, relativePaths[i]));
            }
            return classLoader;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Uh oh: " + e.getMessage());
        }
    }

    public static URLClassLoader getRecursively(URLClassLoader classLoader, File directory) {
        return ClassLoaderPlus.getRecursively(classLoader, false, directory);
    }

    public static URLClassLoader getRecursively(URLClassLoader classLoader, boolean onlyJars, File directory) {
        try {
            File[] list;
            if (!onlyJars) {
                classLoader = ClassLoaderPlus.get(classLoader, directory);
            }
            if ((list = directory.listFiles()) != null) {
                Pattern pattern = Pattern.compile("(batik|jython|jython-standalone|jruby)(-[0-9].*)?\\.jar");
                Arrays.sort(list, new FatJarFileComparator(pattern));
                for (File file : list) {
                    if (file.isDirectory()) {
                        classLoader = ClassLoaderPlus.getRecursively(classLoader, onlyJars, file);
                        continue;
                    }
                    if (!file.getName().endsWith(".jar")) continue;
                    classLoader = ClassLoaderPlus.get(classLoader, file);
                }
            }
            return classLoader;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Uh oh: " + e.getMessage());
        }
    }

    public ClassLoaderPlus() {
        this(new URL[0]);
    }

    public ClassLoaderPlus(URL ... urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append("(");
        for (URL url : this.getURLs()) {
            builder.append(" ").append(url.toString());
        }
        builder.append(" )");
        return builder.toString();
    }

    public static void addInImageJDirectory(URLClassLoader classLoader, String relativePath) {
        try {
            ClassLoaderPlus.add(classLoader, new File(ClassLoaderPlus.getImageJDir(), relativePath));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Uh oh: " + e.getMessage());
        }
    }

    public static void add(URLClassLoader classLoader, String path) throws MalformedURLException {
        ClassLoaderPlus.add(classLoader, new File(path));
    }

    public static void add(URLClassLoader classLoader, File file) throws MalformedURLException {
        ClassLoaderPlus.add(classLoader, file.toURI().toURL());
    }

    public static void add(URLClassLoader classLoader, URL url) {
        List<URL> urls = urlsMap.get(classLoader);
        if (urls == null) {
            urls = new ArrayList<URL>();
            urlsMap.put(classLoader, urls);
        }
        urls.add(url);
        if (!frozen.contains(classLoader)) {
            if (classLoader instanceof ClassLoaderPlus) {
                ((ClassLoaderPlus)classLoader).addURL(url);
            } else {
                try {
                    if (addURL == null) {
                        addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        addURL.setAccessible(true);
                    }
                    addURL.invoke((Object)classLoader, url);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
    }

    public static void freeze(ClassLoader classLoader) {
        frozen.add(classLoader);
    }

    public static String getClassPath(ClassLoader classLoader) {
        List<URL> urls = urlsMap.get(classLoader);
        if (urls == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (URL url : urls) {
            if (!url.getProtocol().equals("file")) continue;
            builder.append(sep).append(url.getPath());
            sep = File.pathSeparator;
        }
        return builder.toString();
    }

    public static String getImageJDir() throws ClassNotFoundException {
        String path = System.getProperty("ij.dir");
        if (path != null) {
            return path;
        }
        String prefix = "file:";
        String suffix = "/jars/imagej-launcher.jar!/imagej/ClassLoaderPlus.class";
        path = Class.forName("net.imagej.launcher.ClassLoaderPlus").getResource("ClassLoaderPlus.class").getPath();
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.endsWith("/jars/imagej-launcher.jar!/imagej/ClassLoaderPlus.class")) {
            path = path.substring(0, path.length() - "/jars/imagej-launcher.jar!/imagej/ClassLoaderPlus.class".length());
        }
        return path;
    }

    public static String getJarPath(ClassLoader classLoader, String className) {
        try {
            int bang;
            Class<?> clazz = classLoader.loadClass(className);
            String path = clazz.getResource("/" + className.replace('.', '/') + ".class").getPath();
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if ((bang = path.indexOf("!/")) > 0) {
                path = path.substring(0, bang);
            }
            return path;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static File getPossiblyVersionedFile(File file) {
        String baseName;
        if (file.exists()) {
            return file;
        }
        Matcher matcher = versionPattern.matcher(file.getName());
        if (matcher.matches()) {
            baseName = matcher.group(1);
        } else if (file.getName().endsWith(".jar")) {
            baseName = file.getName().substring(0, file.getName().length() - 4);
        } else {
            return file;
        }
        File[] list = file.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(baseName)) {
                    return false;
                }
                Matcher matcher = versionPattern.matcher(name);
                return matcher.matches() && matcher.group(1).equals(baseName);
            }
        });
        if (list == null || list.length < 1) {
            return file;
        }
        if (list.length == 1) {
            return list[0];
        }
        int newest = 0;
        System.err.println("Warning: " + file.getName() + " matched multiple versions:");
        for (int i = 0; i < list.length; ++i) {
            System.err.println("\t" + list[i].getName());
            if (i <= 0 || list[newest].lastModified() >= list[i].lastModified()) continue;
            newest = i;
        }
        System.err.println("Picking " + list[newest]);
        return list[newest];
    }

    static {
        versionPattern = Pattern.compile("(.+?)(-\\d+(\\.\\d+)+[a-z]?(-[A-Za-z0-9.]+|\\.GA)*)(\\.jar)");
    }

    public static final class FatJarFileComparator
    implements Comparator<File> {
        private final Pattern pattern;

        private FatJarFileComparator(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public int compare(File a, File b) {
            return (this.pattern.matcher(a.getName()).matches() ? 1 : 0) - (this.pattern.matcher(b.getName()).matches() ? 1 : 0);
        }
    }
}

