/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.qr;

import org.ejml.UtilEjml;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.SpecializedOps_FDRM;
import org.ejml.dense.row.decomposition.TriangularSolver_FDRM;
import org.ejml.dense.row.linsol.LinearSolverAbstract_FDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;

public class LinearSolverQr_FDRM
extends LinearSolverAbstract_FDRM {
    private QRDecomposition<FMatrixRMaj> decomposer;
    protected int maxRows = -1;
    protected int maxCols = -1;
    protected FMatrixRMaj Q;
    protected FMatrixRMaj R;
    private FMatrixRMaj Y;
    private FMatrixRMaj Z;

    public LinearSolverQr_FDRM(QRDecomposition<FMatrixRMaj> decomposer) {
        this.decomposer = decomposer;
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
        this.Q = new FMatrixRMaj(maxRows, maxRows);
        this.R = new FMatrixRMaj(maxRows, maxCols);
        this.Y = new FMatrixRMaj(maxRows, 1);
        this.Z = new FMatrixRMaj(maxRows, 1);
    }

    public boolean setA(FMatrixRMaj A) {
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this._setA(A);
        if (!this.decomposer.decompose((Matrix)A)) {
            return false;
        }
        this.Q.reshape(this.numRows, this.numRows, false);
        this.R.reshape(this.numRows, this.numCols, false);
        this.decomposer.getQ((Matrix)this.Q, false);
        this.decomposer.getR((Matrix)this.R, false);
        return true;
    }

    public double quality() {
        return SpecializedOps_FDRM.qualityTriangular((FMatrixD1)this.R);
    }

    public void solve(FMatrixRMaj B, FMatrixRMaj X) {
        UtilEjml.checkReshapeSolve((int)this.numRows, (int)this.numCols, (ReshapeMatrix)B, (ReshapeMatrix)X);
        int BnumCols = B.numCols;
        this.Y.reshape(this.numRows, 1, false);
        this.Z.reshape(this.numRows, 1, false);
        for (int colB = 0; colB < BnumCols; ++colB) {
            int i;
            for (i = 0; i < this.numRows; ++i) {
                this.Y.data[i] = B.get(i, colB);
            }
            CommonOps_FDRM.multTransA(this.Q, this.Y, this.Z);
            TriangularSolver_FDRM.solveU(this.R.data, this.Z.data, this.numCols);
            for (i = 0; i < this.numCols; ++i) {
                X.set(i, colB, this.Z.data[i]);
            }
        }
    }

    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public QRDecomposition<FMatrixRMaj> getDecomposition() {
        return this.decomposer;
    }

    public QRDecomposition<FMatrixRMaj> getDecomposer() {
        return this.decomposer;
    }

    public FMatrixRMaj getQ() {
        return this.Q;
    }

    public FMatrixRMaj getR() {
        return this.R;
    }
}

