/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.ViewId;

public class ViewRegistrations {
    private Map<ViewId, ViewRegistration> registrations;

    public ViewRegistrations(Map<ViewId, ViewRegistration> registrations) {
        this.registrations = registrations;
    }

    public ViewRegistrations(Collection<ViewRegistration> registrations) {
        this.registrations = new HashMap<ViewId, ViewRegistration>();
        for (ViewRegistration reg : registrations) {
            this.registrations.put(reg, reg);
        }
    }

    public Map<ViewId, ViewRegistration> getViewRegistrations() {
        return this.registrations;
    }

    public List<ViewRegistration> getViewRegistrationsOrdered() {
        ArrayList<ViewRegistration> list = new ArrayList<ViewRegistration>(this.registrations.values());
        Collections.sort(list);
        return list;
    }

    public ViewRegistration getViewRegistration(int timepointId, int setupId) {
        return this.getViewRegistration(new ViewId(timepointId, setupId));
    }

    public ViewRegistration getViewRegistration(ViewId viewId) {
        return this.registrations.get(viewId);
    }

    protected void setViewRegistrations(Map<ViewId, ViewRegistration> registrations) {
        this.registrations = registrations;
    }

    protected ViewRegistrations() {
    }
}

