/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

class ConvertFloatUtils {
    ConvertFloatUtils() {
    }

    public static void copyFromToMultithreaded(RandomAccessible<? extends RealType<?>> source, RandomAccessibleInterval<? extends RealType<?>> destination) {
        IntervalView sourceInterval = Views.interval(source, destination);
        RealType s = (RealType)Util.getTypeFromInterval((Interval)sourceInterval);
        RealType d = (RealType)Util.getTypeFromInterval(destination);
        Converter copy = RealTypeConverters.getConverter((RealType)s, (RealType)d);
        LoopBuilder.setImages((RandomAccessibleInterval)sourceInterval, destination).multiThreaded().forEachPixel((arg_0, arg_1) -> ((Converter)copy).convert(arg_0, arg_1));
    }

    public static void normalize(IterableInterval<FloatType> img) {
        float[] minmax = ConvertFloatUtils.getMinMax(img);
        float min = minmax[0];
        float max = minmax[1];
        float scale = (float)(1.0 / (double)(max - min));
        for (FloatType t : img) {
            t.set((t.get() - min) * scale);
        }
    }

    public static RandomAccessibleInterval<FloatType> convertNormalize(RandomAccessibleInterval<FloatType> img) {
        float[] minmax = ConvertFloatUtils.getMinMax((IterableInterval<FloatType>)Views.iterable(img));
        float min = minmax[0];
        float max = minmax[1];
        float scale = (float)(1.0 / (double)(max - min));
        return Converters.convert(img, (i, o) -> o.set((i.get() - min) * scale), (Type)new FloatType());
    }

    private static float[] getMinMax(IterableInterval<FloatType> img) {
        float currentMax;
        float currentMin = currentMax = ((FloatType)img.firstElement()).get();
        for (FloatType t : img) {
            float f = t.get();
            if (f > currentMax) {
                currentMax = f;
                continue;
            }
            if (!(f < currentMin)) continue;
            currentMin = f;
        }
        return new float[]{currentMin, currentMax};
    }
}

