/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.SpimDataIOException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.XmlIoEntity;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.TimePointsPattern;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoTimePoints
extends XmlIoSingleton<TimePoints> {
    public XmlIoTimePoints() {
        super("Timepoints", TimePoints.class);
        this.handledTags.add("Timepoint");
        this.handledTags.add("first");
        this.handledTags.add("last");
        this.handledTags.add("integerpattern");
    }

    public Element toXml(TimePoints timepoints) {
        Element elem = super.toXml();
        if (timepoints instanceof TimePointsPattern) {
            this.toXmlPattern((TimePointsPattern)timepoints, elem);
        } else if (!this.toXmlTryRange(timepoints, elem)) {
            this.toXmlList(timepoints, elem);
        }
        return elem;
    }

    @Override
    public TimePoints fromXml(Element elem) throws SpimDataException {
        TimePoints timepoints = (TimePoints)super.fromXml(elem);
        String type = elem.getAttributeValue("type");
        if ("pattern".equals(type)) {
            return this.fromXmlPattern(elem);
        }
        if ("range".equals(type)) {
            this.fromXmlRange(timepoints, elem);
        } else if ("list".equals(type)) {
            this.fromXmlList(timepoints, elem);
        } else {
            throw new IllegalArgumentException("unknown Timepoints type " + type);
        }
        return timepoints;
    }

    protected void toXmlPattern(TimePointsPattern timepoints, Element elem) {
        elem.setAttribute("type", "pattern");
        elem.addContent((Content)XmlHelpers.textElement("integerpattern", timepoints.getPattern()));
    }

    protected TimePointsPattern fromXmlPattern(Element elem) throws SpimDataIOException {
        String integerPattern = XmlHelpers.getText(elem, "integerpattern");
        try {
            return new TimePointsPattern(integerPattern);
        }
        catch (ParseException e) {
            throw new SpimDataIOException("cannot parse <Timepoints> pattern: " + integerPattern, e);
        }
    }

    protected boolean toXmlTryRange(TimePoints timepoints, Element elem) {
        try {
            ArrayList<TimePoint> tps = new ArrayList<TimePoint>(timepoints.getTimePoints().values());
            Entity.sortById(tps);
            Iterator<TimePoint> iter = tps.iterator();
            TimePoint tp = iter.next();
            String name = tp.getName();
            int first = Integer.parseInt(name);
            if (!Integer.toString(first).equals(name) || first != tp.getId()) {
                return false;
            }
            int previous = first;
            int last = first;
            while (iter.hasNext()) {
                tp = iter.next();
                name = tp.getName();
                last = Integer.parseInt(name);
                if (!Integer.toString(last).equals(name) || last != tp.getId() || last != previous + 1) {
                    return false;
                }
                previous = last;
            }
            elem.setAttribute("type", "range");
            elem.addContent((Content)XmlHelpers.intElement("first", first));
            elem.addContent((Content)XmlHelpers.intElement("last", last));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected void fromXmlRange(TimePoints timepoints, Element elem) {
        int first = XmlHelpers.getInt(elem, "first");
        int last = XmlHelpers.getInt(elem, "last");
        HashMap<Integer, TimePoint> map = new HashMap<Integer, TimePoint>();
        for (int t = first; t <= last; ++t) {
            map.put(t, new TimePoint(t));
        }
        timepoints.setTimePoints(map);
    }

    protected void toXmlList(TimePoints timepoints, Element elem) {
        elem.setAttribute("type", "list");
        XmlIoEntity<TimePoint> io = new XmlIoEntity<TimePoint>("Timepoint", TimePoint.class);
        ArrayList<TimePoint> tps = new ArrayList<TimePoint>(timepoints.getTimePoints().values());
        Entity.sortById(tps);
        for (TimePoint tp : tps) {
            elem.addContent((Content)io.toXml(tp));
        }
    }

    protected void fromXmlList(TimePoints timepoints, Element elem) throws SpimDataException {
        XmlIoEntity<TimePoint> io = new XmlIoEntity<TimePoint>("Timepoint", TimePoint.class);
        HashMap<Integer, TimePoint> map = new HashMap<Integer, TimePoint>();
        for (Element c : elem.getChildren("Timepoint")) {
            TimePoint tp = io.fromXml(c);
            map.put(tp.getId(), tp);
        }
        timepoints.setTimePoints(map);
    }
}

