/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.pointdescriptor.similarity;

import java.util.ArrayList;
import mpicbg.models.PointMatch;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;

public class ManhattanDistance
implements SimilarityMeasure {
    @Override
    public double getSimilarity(ArrayList<PointMatch> matches) {
        int numDimensions = matches.get(0).getP1().getL().length;
        double difference = 0.0;
        for (PointMatch match : matches) {
            double[] t1 = match.getP2().getW();
            double[] t2 = match.getP1().getW();
            for (int d = 0; d < numDimensions; ++d) {
                difference += Math.abs(t1[d] - t2[d]);
            }
        }
        return difference / (double)numDimensions;
    }
}

