/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion.entropy;

import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;

public class EntropyFloatArray3D {
    public final float[] preComputed;
    public final int[] absFreq;
    public boolean outOfImageX;
    public boolean outOfImageY;
    public boolean outOfImageZ;
    public final Image<FloatType> img;
    public final int histogramBins;
    public final int windowSizeX;
    public final int windowSizeY;
    public final int windowSizeZ;
    public final float size;
    public final int windowSizeXHalf;
    public final int windowSizeYHalf;
    public final int windowSizeZHalf;
    final LocalizableByDimCursor3D<FloatType> cIn;
    final LocalizableByDimCursor3D<FloatType> cOut;
    private float entropy;
    private int x;
    private int y;
    private int z;

    public final float getEntropy() {
        return this.entropy;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final void close() {
        this.cIn.close();
        this.cOut.close();
    }

    public EntropyFloatArray3D(float stepSize, Image<FloatType> img, LocalizableByDimCursor3D<FloatType> cIn, LocalizableByDimCursor3D<FloatType> cOut, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ, int x, int y, int z) {
        this.absFreq = new int[histogramBins];
        this.img = img;
        this.cIn = cIn;
        this.cOut = cOut;
        this.histogramBins = histogramBins;
        this.windowSizeX = windowSizeX % 2 == 0 ? windowSizeX + 1 : windowSizeX;
        this.windowSizeY = windowSizeY % 2 == 0 ? windowSizeY + 1 : windowSizeY;
        this.windowSizeZ = windowSizeZ % 2 == 0 ? windowSizeZ + 1 : windowSizeZ;
        this.size = this.windowSizeX * this.windowSizeY * this.windowSizeZ;
        this.windowSizeXHalf = this.windowSizeX / 2;
        this.windowSizeYHalf = this.windowSizeY / 2;
        this.windowSizeZHalf = this.windowSizeZ / 2;
        this.outOfImageZ = z - this.windowSizeZHalf < 0 || z + this.windowSizeZHalf >= img.getDimension(2);
        this.outOfImageY = y - this.windowSizeYHalf < 0 || y + this.windowSizeYHalf >= img.getDimension(1);
        this.outOfImageX = x - this.windowSizeXHalf < 0 || x + this.windowSizeXHalf >= img.getDimension(0);
        this.preComputed = this.preComputeProbabilities(stepSize);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Image<FloatType> computeEntropy(Image<FloatType> image, ContainerFactory entropyType, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ) {
        float maxEntropy = EntropyFloatArray3D.getMaxEntropy(histogramBins);
        ImageFactory factory = new ImageFactory((Type)new FloatType(), entropyType);
        Image entropy = factory.createImage(image.getDimensions(), "Entropy of " + image.getName());
        LocalizableByDimCursor3D it = (LocalizableByDimCursor3D)entropy.createLocalizableByDimCursor();
        EntropyFloatArray3D entropyObject = EntropyFloatArray3D.initEntropy(image, histogramBins, windowSizeX, windowSizeY, windowSizeZ, 0, 0, 0);
        boolean directionZ = true;
        int directionY = 1;
        int directionX = 1;
        for (int z = 0; z < image.getDimension(2); ++z) {
            for (int y = 0; y < image.getDimension(1); ++y) {
                for (int x = 0; x < image.getDimension(0); ++x) {
                    if (x != 0) {
                        entropyObject.updateEntropyX(directionX);
                    }
                    it.setPosition(entropyObject.getX(), entropyObject.getY(), entropyObject.getZ());
                    ((FloatType)it.getType()).set(entropyObject.getEntropy() / maxEntropy);
                }
                directionX *= -1;
                if (y == image.getDimension(1) - 1) continue;
                entropyObject.updateEntropyY(directionY);
            }
            directionY *= -1;
            if (z == image.getDimension(2) - 1) continue;
            entropyObject.updateEntropyZ(1);
        }
        entropyObject.cIn.close();
        entropyObject.cOut.close();
        return entropy;
    }

    public static EntropyFloatArray3D initEntropy(Image<FloatType> img, int histogramBins, int windowSizeX, int windowSizeY, int windowSizeZ, int x, int y, int z) {
        int bin;
        int xs;
        int ys;
        int zs;
        LocalizableByDimCursor3D cIn = (LocalizableByDimCursor3D)img.createLocalizableByDimCursor();
        LocalizableByDimCursor3D cOut = (LocalizableByDimCursor3D)img.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory());
        EntropyFloatArray3D entropyObject = new EntropyFloatArray3D(0.001f, img, (LocalizableByDimCursor3D<FloatType>)cIn, (LocalizableByDimCursor3D<FloatType>)cOut, histogramBins, windowSizeX, windowSizeY, windowSizeZ, x, y, z);
        if (!(entropyObject.outOfImageX || entropyObject.outOfImageY || entropyObject.outOfImageZ)) {
            for (zs = z - entropyObject.windowSizeZHalf; zs <= z + entropyObject.windowSizeZHalf; ++zs) {
                for (ys = y - entropyObject.windowSizeYHalf; ys <= y + entropyObject.windowSizeYHalf; ++ys) {
                    for (xs = x - entropyObject.windowSizeXHalf; xs <= x + entropyObject.windowSizeXHalf; ++xs) {
                        cIn.moveTo(xs, ys, zs);
                        bin = (int)(((FloatType)cIn.getType()).get() * (float)histogramBins);
                        if (bin >= histogramBins) {
                            bin = histogramBins - 1;
                        }
                        if (bin < 0) {
                            bin = 0;
                        }
                        int n = bin;
                        entropyObject.absFreq[n] = entropyObject.absFreq[n] + 1;
                    }
                }
            }
        } else {
            for (zs = z - entropyObject.windowSizeZHalf; zs <= z + entropyObject.windowSizeZHalf; ++zs) {
                for (ys = y - entropyObject.windowSizeYHalf; ys <= y + entropyObject.windowSizeYHalf; ++ys) {
                    for (xs = x - entropyObject.windowSizeXHalf; xs <= x + entropyObject.windowSizeXHalf; ++xs) {
                        cOut.moveTo(xs, ys, zs);
                        bin = (int)(((FloatType)cOut.getType()).get() * (float)histogramBins);
                        if (bin >= histogramBins) {
                            bin = histogramBins - 1;
                        }
                        if (bin < 0) {
                            bin = 0;
                        }
                        int n = bin;
                        entropyObject.absFreq[n] = entropyObject.absFreq[n] + 1;
                    }
                }
            }
        }
        entropyObject.entropy = 0.0f;
        for (int bin2 = 0; bin2 < histogramBins; ++bin2) {
            if (entropyObject.absFreq[bin2] <= 0) continue;
            float prob = (float)entropyObject.absFreq[bin2] / entropyObject.size;
            entropyObject.entropy = (float)((double)entropyObject.entropy - (double)prob * (Math.log(prob) / Math.log(2.0)));
        }
        return entropyObject;
    }

    public static float getMaxEntropy(int bins) {
        return (float)(Math.log(bins) / Math.log(2.0));
    }

    private final float getEntropyValue(float probability, float[] preComputed) {
        int index = (int)(probability * (float)(preComputed.length - 2)) + 1;
        return preComputed[index];
    }

    private final float[] preComputeProbabilities(float stepSize) {
        float[] tmp = new float[Math.round(1.0f / stepSize) + 2];
        for (int i = 0; i < tmp.length - 2; ++i) {
            double prob = ((float)i * stepSize + (float)(i + 1) * stepSize) / 2.0f;
            tmp[i + 1] = (float)(prob * (Math.log(prob) / Math.log(2.0)));
        }
        tmp[0] = tmp[1];
        tmp[tmp.length - 1] = tmp[tmp.length - 2];
        return tmp;
    }

    private final void updateEntropyValue() {
        this.entropy = 0.0f;
        for (int bin : this.absFreq) {
            if (bin <= 0) continue;
            this.entropy -= this.getEntropyValue((float)bin / this.size, this.preComputed);
        }
    }

    private static final void updateBinNegative(int[] absFreq, int histogramBins, int x, int y, int z, LocalizableByDimCursor3D<FloatType> c) {
        c.moveTo(x, y, z);
        int bin = (int)(((FloatType)c.getType()).get() * (float)histogramBins);
        if (bin >= histogramBins) {
            bin = histogramBins - 1;
        }
        if (bin < 0) {
            bin = 0;
        }
        int n = bin;
        absFreq[n] = absFreq[n] - 1;
    }

    private static final void updateBinPositive(int[] absFreq, int histogramBins, int x, int y, int z, LocalizableByDimCursor3D<FloatType> c) {
        c.moveTo(x, y, z);
        int bin = (int)(((FloatType)c.getType()).get() * (float)histogramBins);
        if (bin >= histogramBins) {
            bin = histogramBins - 1;
        }
        if (bin < 0) {
            bin = 0;
        }
        int n = bin;
        absFreq[n] = absFreq[n] + 1;
    }

    public void updateEntropyX(int direction) {
        int xs1 = this.x - direction * this.windowSizeXHalf;
        this.x += direction;
        int xs2 = this.x + direction * this.windowSizeXHalf;
        for (int zs = this.z - this.windowSizeZHalf; zs <= this.z + this.windowSizeZHalf; ++zs) {
            for (int ys = this.y - this.windowSizeYHalf; ys <= this.y + this.windowSizeYHalf; ++ys) {
                EntropyFloatArray3D.updateBinNegative(this.absFreq, this.histogramBins, xs1, ys, zs, this.cOut);
                EntropyFloatArray3D.updateBinPositive(this.absFreq, this.histogramBins, xs2, ys, zs, this.cOut);
            }
        }
        this.updateEntropyValue();
    }

    public void updateEntropyY(int direction) {
        int ys1 = this.y - direction * this.windowSizeYHalf;
        this.y += direction;
        int ys2 = this.y + direction * this.windowSizeYHalf;
        for (int zs = this.z - this.windowSizeZHalf; zs <= this.z + this.windowSizeZHalf; ++zs) {
            for (int xs = this.x - this.windowSizeXHalf; xs <= this.x + this.windowSizeXHalf; ++xs) {
                EntropyFloatArray3D.updateBinNegative(this.absFreq, this.histogramBins, xs, ys1, zs, this.cOut);
                EntropyFloatArray3D.updateBinPositive(this.absFreq, this.histogramBins, xs, ys2, zs, this.cOut);
            }
        }
        this.updateEntropyValue();
    }

    public void updateEntropyZ(int direction) {
        int zs1 = this.z - direction * this.windowSizeZHalf;
        this.z += direction;
        int zs2 = this.z + direction * this.windowSizeZHalf;
        for (int ys = this.y - this.windowSizeYHalf; ys <= this.y + this.windowSizeYHalf; ++ys) {
            for (int xs = this.x - this.windowSizeXHalf; xs <= this.x + this.windowSizeXHalf; ++xs) {
                EntropyFloatArray3D.updateBinNegative(this.absFreq, this.histogramBins, xs, ys, zs1, this.cOut);
                EntropyFloatArray3D.updateBinPositive(this.absFreq, this.histogramBins, xs, ys, zs2, this.cOut);
            }
        }
        this.updateEntropyValue();
    }
}

