/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.vis3d;

import java.util.ArrayList;
import java.util.Random;
import mpicbg.spim.registration.ViewDataBeads;
import spim.vecmath.Color3f;
import spim.vecmath.Point3f;
import spim.vecmath.Transform3D;
import spim.vecmath.Vector3f;

public class VisualizationFunctions {
    public static final boolean storeBeadPosition = true;

    public static Color3f getRandomPastellColor(float lowerBorder) {
        return VisualizationFunctions.getRandomPastellColor(System.currentTimeMillis(), lowerBorder);
    }

    public static Color3f getRandomColor() {
        return VisualizationFunctions.getRandomColor(System.nanoTime());
    }

    public static Color3f getRandomColor(long seed) {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Random rnd = new Random(seed);
        return new Color3f(rnd.nextFloat(), rnd.nextFloat(), rnd.nextFloat());
    }

    public static Color3f getRandomPastellColor(long seed, float lowerBorder) {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Random rnd = new Random(seed);
        return new Color3f(rnd.nextFloat() * (1.0f - lowerBorder) + lowerBorder, rnd.nextFloat() * (1.0f - lowerBorder) + lowerBorder, rnd.nextFloat() * (1.0f - lowerBorder) + lowerBorder);
    }

    public static ArrayList<Point3f> makeArrow(Point3f from, Point3f to, float arrowHeadAngle, float arrowHeadLength) {
        Vector3f a;
        Vector3f v = new Vector3f(to);
        v.sub(from);
        v.normalize();
        Vector3f x = new Vector3f(1.0f, 0.0f, 0.0f);
        float length = v.dot(x);
        if ((double)length > 0.9999 && (double)length < 1.0001) {
            a = new Vector3f(0.0f, 1.0f, 0.0f);
        } else {
            Vector3f tmp = new Vector3f(v);
            tmp.scale(x.dot(v));
            a = new Vector3f(x);
            a.sub(tmp);
        }
        Vector3f b = new Vector3f();
        b.cross(a, v);
        ArrayList<Point3f> arrowList = new ArrayList<Point3f>();
        arrowList.add(from);
        arrowList.add(to);
        VisualizationFunctions.computeArrowLines(arrowList, to, v, a, b, arrowHeadAngle, arrowHeadLength);
        return arrowList;
    }

    protected static void computeArrowLines(ArrayList<Point3f> list, Point3f to, Vector3f v, Vector3f a, Vector3f b, float arrowHeadAngle, float arrowHeadLength) {
        Vector3f a1 = new Vector3f(a);
        Vector3f b1 = new Vector3f(b);
        Vector3f v1 = new Vector3f(v);
        a1.scale((float)Math.sin(arrowHeadAngle));
        b1.scale((float)Math.sin(arrowHeadAngle));
        v1.scale((float)Math.cos(arrowHeadAngle));
        a1.scale(arrowHeadLength);
        b1.scale(arrowHeadLength);
        v1.scale(arrowHeadLength);
        Point3f arrow = new Point3f(to);
        arrow.sub(v1);
        arrow.sub(a1);
        list.add(to);
        list.add(arrow);
        arrow = new Point3f(to);
        arrow.sub(v1);
        arrow.add(a1);
        list.add(to);
        list.add(arrow);
        arrow = new Point3f(to);
        arrow.sub(v1);
        arrow.add(b1);
        list.add(to);
        list.add(arrow);
        arrow = new Point3f(to);
        arrow.sub(v1);
        arrow.sub(b1);
        list.add(to);
        list.add(arrow);
    }

    public static ArrayList<Point3f> getTransformedBoundingBox(ViewDataBeads view) {
        ArrayList<Point3f> boundingBox = new ArrayList<Point3f>();
        Transform3D transformation = view.getTransform3D();
        int[] imageSize = view.getImageSize();
        Point3f from = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f to = new Point3f(view.getImageSize()[0], 0.0f, 0.0f);
        view.getTransform3D().transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], 0.0f, 0.0f);
        to = new Point3f(imageSize[0], imageSize[1], 0.0f);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], imageSize[1], 0.0f);
        to = new Point3f(0.0f, imageSize[1], 0.0f);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(0.0f, imageSize[1], 0.0f);
        to = new Point3f(0.0f, 0.0f, 0.0f);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(0.0f, 0.0f, imageSize[2]);
        to = new Point3f(imageSize[0], 0.0f, imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], 0.0f, imageSize[2]);
        to = new Point3f(imageSize[0], imageSize[1], imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], imageSize[1], imageSize[2]);
        to = new Point3f(0.0f, imageSize[1], imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(0.0f, imageSize[1], imageSize[2]);
        to = new Point3f(0.0f, 0.0f, imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(0.0f, 0.0f, 0.0f);
        to = new Point3f(0.0f, 0.0f, imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], 0.0f, 0.0f);
        to = new Point3f(imageSize[0], 0.0f, imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(imageSize[0], imageSize[1], 0.0f);
        to = new Point3f(imageSize[0], imageSize[1], imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        from = new Point3f(0.0f, imageSize[1], 0.0f);
        to = new Point3f(0.0f, imageSize[1], imageSize[2]);
        transformation.transform(from);
        transformation.transform(to);
        boundingBox.add(from);
        boundingBox.add(to);
        return boundingBox;
    }

    public static ArrayList<Point3f> getBoundingBox(ViewDataBeads view) {
        int[] to = view.getImageSize();
        int[] fr = view.getImageSizeOffset();
        return VisualizationFunctions.getBoundingBox(fr, to);
    }

    public static ArrayList<Point3f> getBoundingBox(int[] fr, int[] to) {
        ArrayList<Point3f> boundingBox = new ArrayList<Point3f>();
        for (int d = 0; d < to.length; ++d) {
            int n = d;
            to[n] = to[n] + fr[d];
        }
        boundingBox.add(new Point3f(fr[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(to[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(to[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(to[0], to[1], fr[2]));
        boundingBox.add(new Point3f(to[0], to[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], to[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], to[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], fr[1], to[2]));
        boundingBox.add(new Point3f(to[0], fr[1], to[2]));
        boundingBox.add(new Point3f(to[0], fr[1], to[2]));
        boundingBox.add(new Point3f(to[0], to[1], to[2]));
        boundingBox.add(new Point3f(to[0], to[1], to[2]));
        boundingBox.add(new Point3f(fr[0], to[1], to[2]));
        boundingBox.add(new Point3f(fr[0], to[1], to[2]));
        boundingBox.add(new Point3f(fr[0], fr[1], to[2]));
        boundingBox.add(new Point3f(fr[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], fr[1], to[2]));
        boundingBox.add(new Point3f(to[0], fr[1], fr[2]));
        boundingBox.add(new Point3f(to[0], fr[1], to[2]));
        boundingBox.add(new Point3f(to[0], to[1], fr[2]));
        boundingBox.add(new Point3f(to[0], to[1], to[2]));
        boundingBox.add(new Point3f(fr[0], to[1], fr[2]));
        boundingBox.add(new Point3f(fr[0], to[1], to[2]));
        return boundingBox;
    }

    public static ArrayList<Point3f> getBoundingBox(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        ArrayList<Point3f> boundingBox = new ArrayList<Point3f>();
        boundingBox.add(new Point3f(minX, minY, minZ));
        boundingBox.add(new Point3f(maxX, minY, minZ));
        boundingBox.add(new Point3f(maxX, minY, minZ));
        boundingBox.add(new Point3f(maxX, maxY, minZ));
        boundingBox.add(new Point3f(maxX, maxY, minZ));
        boundingBox.add(new Point3f(minX, maxY, minZ));
        boundingBox.add(new Point3f(minX, maxY, minZ));
        boundingBox.add(new Point3f(minX, minY, minZ));
        boundingBox.add(new Point3f(minX, minY, maxZ));
        boundingBox.add(new Point3f(maxX, minY, maxZ));
        boundingBox.add(new Point3f(maxX, minY, maxZ));
        boundingBox.add(new Point3f(maxX, maxY, maxZ));
        boundingBox.add(new Point3f(maxX, maxY, maxZ));
        boundingBox.add(new Point3f(minX, maxY, maxZ));
        boundingBox.add(new Point3f(minX, maxY, maxZ));
        boundingBox.add(new Point3f(minX, minY, maxZ));
        boundingBox.add(new Point3f(minX, minY, minZ));
        boundingBox.add(new Point3f(minX, minY, maxZ));
        boundingBox.add(new Point3f(maxX, minY, minZ));
        boundingBox.add(new Point3f(maxX, minY, maxZ));
        boundingBox.add(new Point3f(maxX, maxY, minZ));
        boundingBox.add(new Point3f(maxX, maxY, maxZ));
        boundingBox.add(new Point3f(minX, maxY, minZ));
        boundingBox.add(new Point3f(minX, maxY, maxZ));
        return boundingBox;
    }
}

