/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataRetrieve;
import mpicbg.spim.io.IOFunctions;
import ome.units.quantity.Length;
import spim.fiji.datasetmanager.SlideBook6Image;
import spim.fiji.spimdata.imgloaders.LegacySlideBook6ImgLoader;

public class SlideBook6MetaData {
    private SlideBook6Image[] captures;
    private int pixelType = -1;
    private int bytesPerPixel = -1;
    private String pixelTypeString = "";
    private boolean isLittleEndian;
    private IFormatReader r = null;

    public int numCaptures() {
        return this.captures.length;
    }

    public String imageName(int i) {
        return this.captures[i].name;
    }

    public int numChannels(int i) {
        return this.captures[i].channels.length;
    }

    public int numAngles(int i) {
        return this.captures[i].angles.length;
    }

    public int numTimepoints(int i) {
        return this.captures[i].numT;
    }

    public String objective(int i) {
        return this.captures[i].objective;
    }

    public double calX(int i) {
        return this.captures[i].calX;
    }

    public double calY(int i) {
        return this.captures[i].calY;
    }

    public double calZ(int i) {
        return this.captures[i].calZ;
    }

    public String[] channels(int i) {
        return this.captures[i].channels;
    }

    public String[] angles(int i) {
        return this.captures[i].angles;
    }

    public int[] imageSize(int i) {
        return this.captures[i].imageSize;
    }

    public int pixelType() {
        return this.pixelType;
    }

    public int bytesPerPixel() {
        return this.bytesPerPixel;
    }

    public String pixelTypeString() {
        return this.pixelTypeString;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public IFormatReader getReader() {
        return this.r;
    }

    public boolean loadMetaData(File sldFile) {
        return this.loadMetaData(sldFile, false);
    }

    public boolean loadMetaData(File sldFile, boolean keepFileOpen) {
        IFormatReader r = LegacySlideBook6ImgLoader.instantiateImageReader();
        if (!LegacySlideBook6ImgLoader.createOMEXMLMetadata(r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            IOFunctions.println("Creating MetaDataStore failed. Stopping");
            return false;
        }
        try {
            r.setId(sldFile.getAbsolutePath());
            this.pixelType = r.getPixelType();
            this.bytesPerPixel = FormatTools.getBytesPerPixel((int)this.pixelType);
            this.pixelTypeString = FormatTools.getPixelTypeString((int)this.pixelType);
            this.isLittleEndian = r.isLittleEndian();
            if (this.pixelType != 3) {
                IOFunctions.println("SlideBook6MetaData.loadMetaData(): PixelType " + this.pixelTypeString + " not supported yet. Please send me an email about this: stephan.preibisch@gmx.de - stopping.");
                r.close();
                return false;
            }
        }
        catch (Exception e) {
            IOFunctions.println("File '" + sldFile.getAbsolutePath() + "' could not be opened: " + e);
            IOFunctions.println("Stopping");
            e.printStackTrace();
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        Hashtable metaData = r.getGlobalMetadata();
        int numCaptures = r.getSeriesCount();
        this.captures = new SlideBook6Image[numCaptures];
        boolean printMetadata = false;
        try {
            for (int i = 0; i < this.captures.length; ++i) {
                r.setSeries(i);
                this.captures[i] = new SlideBook6Image();
                MetadataRetrieve retrieve = (MetadataRetrieve)r.getMetadataStore();
                int w = r.getSizeX();
                int h = r.getSizeY();
                int d = r.getSizeZ();
                this.captures[i].imageSize = new int[]{w, h, d};
                this.captures[i].numT = r.getSizeT();
                this.captures[i].name = retrieve.getImageName(i);
                try {
                    this.captures[i].objective = retrieve.getObjectiveSettingsID(i);
                }
                catch (Exception e) {
                    IOFunctions.println("An error occured parsing the objective used: " + e + "\n. Proceeding.");
                    this.captures[i].objective = "Unknown Objective";
                    printMetadata = true;
                }
                try {
                    this.captures[i].channels = new String[r.getSizeC()];
                    for (int c = 0; c < r.getSizeC(); ++c) {
                        this.captures[i].channels[c] = retrieve.getChannelName(i, c);
                    }
                }
                catch (Exception e) {
                    IOFunctions.println("An error occured parsing the channels: " + e + "\n. Proceeding.");
                    for (int c = 0; c < r.getSizeC(); ++c) {
                        this.captures[i].channels[c] = String.valueOf(c);
                    }
                    printMetadata = true;
                }
                try {
                    String info = retrieve.getImageDescription(i);
                    if (info.indexOf("stage") != -1) {
                        this.captures[i].stageScan = true;
                    }
                }
                catch (Exception e) {
                    IOFunctions.println("An error occured parsing the info text for 'stage': " + e + "\n. Proceeding.");
                    printMetadata = true;
                }
                try {
                    float cal = 0.0f;
                    Length f = retrieve.getPixelsPhysicalSizeX(0);
                    if (f != null) {
                        cal = f.value().floatValue();
                    }
                    if (cal == 0.0f) {
                        cal = 1.0f;
                        IOFunctions.println("SlideBook6: Warning, calibration for dimension X seems corrupted, setting to 1.");
                    }
                    this.captures[i].calX = cal;
                    f = retrieve.getPixelsPhysicalSizeY(0);
                    if (f != null) {
                        cal = f.value().floatValue();
                    }
                    if (cal == 0.0f) {
                        cal = 1.0f;
                        IOFunctions.println("SlideBook6: Warning, calibration for dimension Y seems corrupted, setting to 1.");
                    }
                    this.captures[i].calY = cal;
                    f = retrieve.getPixelsPhysicalSizeZ(0);
                    if (f != null) {
                        cal = f.value().floatValue();
                    }
                    if (cal == 0.0f) {
                        cal = 1.0f;
                        IOFunctions.println("SlideBook6: Warning, calibration for dimension Z seems corrupted, setting to 1.");
                    }
                    this.captures[i].calZ = cal;
                    continue;
                }
                catch (Exception e) {
                    IOFunctions.println("An error occured parsing the calibration: " + e + "\n. Proceeding.");
                    this.captures[i].calZ = 1.0;
                    this.captures[i].calY = 1.0;
                    this.captures[i].calX = 1.0;
                    printMetadata = true;
                }
            }
        }
        catch (Exception e) {
            IOFunctions.println("An error occured parsing the main meta data: " + e + ". Stopping.");
            e.printStackTrace();
            SlideBook6MetaData.printMetaData(r);
            try {
                r.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        if (printMetadata) {
            SlideBook6MetaData.printMetaData(r);
        }
        if (!keepFileOpen) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.r = r;
        }
        return true;
    }

    private static void printMetaData(IFormatReader r) {
        SlideBook6MetaData.printMetaData(r.getGlobalMetadata());
    }

    private static void printMetaData(Hashtable<String, Object> metaData) {
        ArrayList<String> entries = new ArrayList<String>();
        for (String s : metaData.keySet()) {
            entries.add("'" + s + "': " + metaData.get(s));
        }
        Collections.sort(entries);
        for (String s : entries) {
            System.out.println(s);
        }
    }
}

