/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.apply;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewSetup;

public class ModelLink {
    final Set<TimePoint> ts = new HashSet<TimePoint>();
    final Set<Channel> cs = new HashSet<Channel>();
    final Set<Illumination> is = new HashSet<Illumination>();
    final Set<Angle> as = new HashSet<Angle>();
    final List<ViewDescription> vds = new ArrayList<ViewDescription>();
    double[] model;
    String modelDesc;

    public ModelLink(ViewDescription vd) {
        this.add(vd);
    }

    public List<ViewDescription> viewDescriptions() {
        return this.vds;
    }

    public double[] model() {
        return this.model;
    }

    public String modelDescription() {
        return this.modelDesc;
    }

    public Set<Angle> angles() {
        return this.as;
    }

    public void setModel(double[] model, String modelDesc) {
        this.model = model;
        this.modelDesc = modelDesc;
    }

    public void add(ViewDescription vd) {
        if (vd == null) {
            return;
        }
        this.ts.add(vd.getTimePoint());
        this.cs.add(((ViewSetup)vd.getViewSetup()).getChannel());
        this.is.add(((ViewSetup)vd.getViewSetup()).getIllumination());
        this.as.add(((ViewSetup)vd.getViewSetup()).getAngle());
        this.vds.add(vd);
    }

    public String dialogName() {
        String s = "";
        s = s + (this.ts.size() > 1 ? "all_timepoints" : "timepoint_" + this.ts.iterator().next().getName());
        s = s + (this.cs.size() > 1 ? "_all_channels" : "_channel_" + this.cs.iterator().next().getName());
        s = s + (this.is.size() > 1 ? "_all_illuminations" : "_illumination_" + this.is.iterator().next().getName());
        s = s + (this.as.size() > 1 ? "_all_angles" : "_angle_" + this.as.iterator().next().getName());
        return s;
    }
}

