/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import java.util.ArrayList;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.iterator.LocalizingZeroMinIntervalIterator;
import net.imglib2.util.Util;
import spim.process.cuda.Block;
import spim.process.cuda.BlockGenerator;

public class BlockGeneratorFixedSizePrecise
implements BlockGenerator<Block> {
    final long[] blockSize;

    public BlockGeneratorFixedSizePrecise(long[] blockSize) {
        this.blockSize = blockSize;
    }

    public Block[] divideIntoBlocks(long[] imgSize, long[] kernelSize) {
        int numDimensions = imgSize.length;
        long[] effectiveSizeGeneral = new long[numDimensions];
        long[] effectiveLocalOffset = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            effectiveSizeGeneral[d] = this.blockSize[d] - kernelSize[d] + 1L;
            if (effectiveSizeGeneral[d] <= 0L) {
                IOFunctions.println("Blocksize in dimension " + d + " (" + this.blockSize[d] + ") is smaller than the kernel (" + kernelSize[d] + ") which results in an negative effective size: " + effectiveSizeGeneral[d] + ". Quitting.");
                return null;
            }
            effectiveLocalOffset[d] = kernelSize[d] / 2L;
        }
        long[] numBlocks = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            numBlocks[d] = imgSize[d] / effectiveSizeGeneral[d];
            if (imgSize[d] % effectiveSizeGeneral[d] == 0L) continue;
            int n = d;
            numBlocks[n] = numBlocks[n] + 1L;
        }
        System.out.println("imgSize " + Util.printCoordinates((long[])imgSize));
        System.out.println("kernelSize " + Util.printCoordinates((long[])kernelSize));
        System.out.println("blockSize " + Util.printCoordinates((long[])this.blockSize));
        System.out.println("numBlocks " + Util.printCoordinates((long[])numBlocks));
        IOFunctions.println("effectiveSize of blocks" + Util.printCoordinates((long[])effectiveSizeGeneral));
        System.out.println("effectiveLocalOffset " + Util.printCoordinates((long[])effectiveLocalOffset));
        LocalizingZeroMinIntervalIterator cursor = new LocalizingZeroMinIntervalIterator(numBlocks);
        ArrayList<Block> blockList = new ArrayList<Block>();
        int[] currentBlock = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(currentBlock);
            long[] offset = new long[numDimensions];
            long[] effectiveOffset = new long[numDimensions];
            long[] effectiveSize = (long[])effectiveSizeGeneral.clone();
            for (int d = 0; d < numDimensions; ++d) {
                effectiveOffset[d] = (long)currentBlock[d] * effectiveSize[d];
                offset[d] = effectiveOffset[d] - kernelSize[d] / 2L;
                if (effectiveOffset[d] + effectiveSize[d] <= imgSize[d]) continue;
                effectiveSize[d] = imgSize[d] - effectiveOffset[d];
            }
            blockList.add(new Block(this.blockSize, offset, effectiveSize, effectiveOffset, effectiveLocalOffset, true));
        }
        Block[] blocks = new Block[blockList.size()];
        for (int i = 0; i < blockList.size(); ++i) {
            blocks[i] = (Block)blockList.get(i);
        }
        return blocks;
    }
}

