/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

import mpicbg.imglib.util.Util;
import spim.process.cuda.CUDASeparableConvolution;

public class CUDASeparableConvolutionFunctions {
    static final int[] supportedKernelSizes = new int[]{7, 15, 31, 63, 127};
    final CUDASeparableConvolution cuda;
    final int cudaDeviceId;

    public CUDASeparableConvolutionFunctions(CUDASeparableConvolution cuda, int cudaDeviceId) {
        this.cuda = cuda;
        this.cudaDeviceId = cudaDeviceId;
    }

    public boolean gauss(float[] img, int[] dim, double sigma) {
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigma, OutOfBounds.EXTEND_BORDER_PIXELS, 0.0f, this.cuda, this.cudaDeviceId);
    }

    public boolean gauss(float[] img, int[] dim, double[] sigma) {
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigma, OutOfBounds.EXTEND_BORDER_PIXELS, 0.0f, this.cuda, this.cudaDeviceId);
    }

    public boolean gauss(float[] img, int[] dim, float[] sigma) {
        double[] sigmaD = new double[sigma.length];
        for (int d = 0; d < sigmaD.length; ++d) {
            sigmaD[d] = sigma[d];
        }
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigmaD, OutOfBounds.EXTEND_BORDER_PIXELS, 0.0f, this.cuda, this.cudaDeviceId);
    }

    public boolean gauss(float[] img, int[] dim, double sigma, OutOfBounds oobs, float oobsValue) {
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigma, oobs, oobsValue, this.cuda, this.cudaDeviceId);
    }

    public boolean gauss(float[] img, int[] dim, double[] sigma, OutOfBounds oobs, float oobsValue) {
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigma, oobs, oobsValue, this.cuda, this.cudaDeviceId);
    }

    public static final boolean gauss(float[] img, int[] dim, double sigma, OutOfBounds oobs, float oobsValue, CUDASeparableConvolution cuda, int cudaDeviceId) {
        if (dim == null || dim.length == 0 || dim.length > 3) {
            return false;
        }
        double[] sigmas = new double[dim.length];
        for (int d = 0; d < dim.length; ++d) {
            sigmas[d] = sigma;
        }
        return CUDASeparableConvolutionFunctions.gauss(img, dim, sigmas, oobs, oobsValue, cuda, cudaDeviceId);
    }

    public static final boolean gauss(float[] img, int[] dim, double[] sigma, OutOfBounds oobs, float oobsValue, CUDASeparableConvolution cuda, int cudaDeviceId) {
        float[] kernelY;
        float[] kernelZ;
        float[] kernelX;
        int h;
        int d;
        int w;
        if (dim == null || img == null || sigma == null) {
            System.out.println("Input(s) are null.");
            return false;
        }
        int n = dim.length;
        if (sigma.length != n || n > 3 || n == 0) {
            System.out.println("Inputs inconsistent or wrong dimensionality.");
            return false;
        }
        float[][] kernelsCUDA = CUDASeparableConvolutionFunctions.getCUDAKernels(sigma, supportedKernelSizes);
        int size = kernelsCUDA[0].length;
        if (n == 1) {
            w = dim[0];
            d = 1;
            h = 1;
            kernelX = kernelsCUDA[0];
            kernelZ = null;
            kernelY = null;
        } else if (n == 2) {
            w = dim[0];
            h = dim[1];
            d = 1;
            kernelX = kernelsCUDA[0];
            kernelY = kernelsCUDA[1];
            kernelZ = null;
        } else {
            w = dim[0];
            h = dim[1];
            d = dim[2];
            kernelX = kernelsCUDA[0];
            kernelY = kernelsCUDA[1];
            kernelZ = kernelsCUDA[2];
        }
        switch (size) {
            case 7: {
                cuda.convolve_7(img, kernelX, kernelY, kernelZ, w, h, d, kernelX != null, kernelY != null, kernelZ != null, oobs.ordinal(), oobsValue, cudaDeviceId);
                break;
            }
            case 15: {
                cuda.convolve_15(img, kernelX, kernelY, kernelZ, w, h, d, kernelX != null, kernelY != null, kernelZ != null, oobs.ordinal(), oobsValue, cudaDeviceId);
                break;
            }
            case 31: {
                cuda.convolve_31(img, kernelX, kernelY, kernelZ, w, h, d, kernelX != null, kernelY != null, kernelZ != null, oobs.ordinal(), oobsValue, cudaDeviceId);
                break;
            }
            case 63: {
                cuda.convolve_63(img, kernelX, kernelY, kernelZ, w, h, d, kernelX != null, kernelY != null, kernelZ != null, oobs.ordinal(), oobsValue, cudaDeviceId);
                break;
            }
            case 127: {
                cuda.convolve_127(img, kernelX, kernelY, kernelZ, w, h, d, kernelX != null, kernelY != null, kernelZ != null, oobs.ordinal(), oobsValue, cudaDeviceId);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static float[][] getCUDAKernels(double[] sigma, int[] supportedKernelSizes) {
        int n = sigma.length;
        double[][] kernels = new double[n][];
        int maxLength = -1;
        for (int d = 0; d < n; ++d) {
            kernels[d] = Util.createGaussianKernel1DDouble((double)sigma[d], (boolean)true);
            maxLength = Math.max(maxLength, kernels[d].length);
        }
        int size = Integer.MAX_VALUE;
        for (int s : supportedKernelSizes) {
            if (maxLength > s) continue;
            size = Math.min(s, size);
        }
        if (size == Integer.MAX_VALUE) {
            System.out.println("Kernel bigger than maximally supported size. Quitting.");
            return null;
        }
        float[][] kernelsCUDA = new float[kernels.length][];
        for (int d = 0; d < kernels.length; ++d) {
            kernelsCUDA[d] = CUDASeparableConvolutionFunctions.getFloatKernelPadded(kernels[d], size);
        }
        return kernelsCUDA;
    }

    public static float[] getFloatKernelPadded(double[] kernel, int size) {
        if (kernel.length > size) {
            return null;
        }
        float[] k = new float[size];
        int s = (size - kernel.length) / 2;
        for (int i = 0; i < kernel.length; ++i) {
            k[s + i] = (float)kernel[i];
        }
        return k;
    }

    public static enum OutOfBounds {
        ZERO,
        VALUE,
        EXTEND_BORDER_PIXELS;

    }
}

