/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.Threads;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.ImagePortion;

public class FusionHelper {
    private FusionHelper() {
    }

    public static String getIllumName(List<Illumination> illumsToProcess) {
        String illumName = "_Ill" + illumsToProcess.get(0).getName();
        for (int i = 1; i < illumsToProcess.size(); ++i) {
            illumName = illumName + "," + illumsToProcess.get(i).getName();
        }
        return illumName;
    }

    public static String getAngleName(List<Angle> anglesToProcess) {
        String angleName = "_Ang" + anglesToProcess.get(0).getName();
        for (int i = 1; i < anglesToProcess.size(); ++i) {
            angleName = angleName + "," + anglesToProcess.get(i).getName();
        }
        return angleName;
    }

    public static final boolean intersects(double x, double y, double z, long sx, long sy, long sz) {
        return x >= 0.0 && y >= 0.0 && z >= 0.0 && x < (double)sx && y < (double)sy && z < (double)sz;
    }

    public static final ArrayList<ViewDescription> assembleInputData(SpimData2 spimData, TimePoint timepoint, Channel channel, List<ViewId> viewIdsToProcess) {
        ArrayList<ViewDescription> inputData = new ArrayList<ViewDescription>();
        for (ViewId viewId : viewIdsToProcess) {
            ViewDescription vd = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
            if (!vd.isPresent() || vd.getTimePointId() != timepoint.getId() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != channel.getId()) continue;
            spimData.getViewRegistrations().getViewRegistration(viewId).updateModel();
            inputData.add(vd);
        }
        return inputData;
    }

    public static <T extends RealType<T>> float[] minMax(RandomAccessibleInterval<T> img) {
        final IterableInterval iterable = Views.iterable(img);
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(iterable.size(), Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<float[]>(){

                @Override
                public float[] call() throws Exception {
                    float min = Float.MAX_VALUE;
                    float max = -3.4028235E38f;
                    Cursor c = iterable.cursor();
                    c.jumpFwd(portion.getStartPosition());
                    for (long j = 0L; j < portion.getLoopSize(); ++j) {
                        float v = ((RealType)c.next()).getRealFloat();
                        min = Math.min(min, v);
                        max = Math.max(max, v);
                    }
                    return new float[]{min, max};
                }
            });
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        try {
            List futures = taskExecutor.invokeAll(tasks);
            for (Future future : futures) {
                float[] minmax = (float[])future.get();
                min = Math.min(min, minmax[0]);
                max = Math.max(max, minmax[1]);
            }
        }
        catch (Exception e) {
            IOFunctions.println("Failed to compute min/max: " + e);
            e.printStackTrace();
            return null;
        }
        taskExecutor.shutdown();
        return new float[]{min, max};
    }

    public static boolean normalizeImage(RandomAccessibleInterval<FloatType> img) {
        float[] minmax = FusionHelper.minMax(img);
        float min = minmax[0];
        float max = minmax[1];
        return FusionHelper.normalizeImage(img, min, max);
    }

    public static boolean normalizeImage(RandomAccessibleInterval<FloatType> img, final float min, float max) {
        final float diff = max - min;
        if (Float.isNaN(diff) || Float.isInfinite(diff) || diff == 0.0f) {
            IOFunctions.println("Cannot normalize image, min=" + min + "  + max=" + max);
            return false;
        }
        final IterableInterval iterable = Views.iterable(img);
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(iterable.size(), Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<2> tasks = new ArrayList<2>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Cursor c = iterable.cursor();
                    c.jumpFwd(portion.getStartPosition());
                    for (long j = 0L; j < portion.getLoopSize(); ++j) {
                        FloatType t = (FloatType)c.next();
                        float norm = (t.get() - min) / diff;
                        t.set(norm);
                    }
                    return "";
                }
            });
        }
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to compute min/max: " + e);
            e.printStackTrace();
            return false;
        }
        taskExecutor.shutdown();
        return true;
    }

    public static final Vector<ImagePortion> divideIntoPortions(long imageSize, int numPortions) {
        long threadChunkSize = imageSize / (long)numPortions;
        long threadChunkMod = imageSize % (long)numPortions;
        Vector<ImagePortion> portions = new Vector<ImagePortion>();
        for (int portionID = 0; portionID < numPortions; ++portionID) {
            long startPosition = (long)portionID * threadChunkSize;
            long loopSize = portionID == numPortions - 1 ? threadChunkSize + threadChunkMod : threadChunkSize;
            portions.add(new ImagePortion(startPosition, loopSize));
        }
        return portions;
    }
}

