/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import spim.Threads;
import spim.fiji.spimdata.SpimData2;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.weightedavg.ProcessFusion;
import spim.process.fusion.weightedavg.ProcessParalellPortion;
import spim.process.fusion.weightedavg.ProcessParalellPortionWeight;
import spim.process.fusion.weightedavg.ProcessParalellPortionWeights;

public class ProcessParalell
extends ProcessFusion {
    public ProcessParalell(SpimData2 spimData, List<ViewId> viewIdsToProcess, BoundingBoxGUI bb, boolean useBlending, boolean useContentBased) {
        super(spimData, viewIdsToProcess, bb, useBlending, useContentBased);
    }

    @Override
    public <T extends RealType<T> & NativeType<T>> Img<T> fuseStack(T type, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, TimePoint timepoint, Channel channel) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Reserving memory for fused image.");
        ArrayList<ViewDescription> inputData = FusionHelper.assembleInputData(this.spimData, timepoint, channel, this.viewIdsToProcess);
        if (inputData.size() == 0) {
            return null;
        }
        Img fusedImg = this.bb.getImgFactory(type).create(this.bb.getDimensions(), type);
        if (fusedImg == null) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): WeightedAverageFusion: Cannot create output image.");
            return null;
        }
        ArrayList imgs = new ArrayList();
        for (int i = 0; i < inputData.size(); ++i) {
            ViewDescription vd = inputData.get(i);
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Requesting Img from ImgLoader (tp=" + vd.getTimePointId() + ", setup=" + vd.getViewSetupId() + ")");
            imgs.add(ProcessParalell.getImage(type, this.spimData, (ViewId)vd, false));
        }
        ArrayList<ArrayList<RealRandomAccessible<FloatType>>> weights = new ArrayList<ArrayList<RealRandomAccessible<FloatType>>>();
        for (int i = 0; i < inputData.size(); ++i) {
            weights.add(this.getAllWeights((RandomAccessibleInterval)imgs.get(i), inputData.get(i), (ImgLoader)((SequenceDescription)this.spimData.getSequenceDescription()).getImgLoader()));
        }
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(fusedImg.size(), Threads.numThreads() * 4);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList tasks = new ArrayList();
        if (((ArrayList)weights.get(0)).size() == 0) {
            for (ImagePortion portion : portions) {
                tasks.add(new ProcessParalellPortion(portion, imgs, interpolatorFactory, this.getTransforms(inputData), fusedImg, this.bb));
            }
        } else if (((ArrayList)weights.get(0)).size() > 1) {
            for (ImagePortion portion : portions) {
                tasks.add(new ProcessParalellPortionWeights(portion, imgs, weights, interpolatorFactory, this.getTransforms(inputData), fusedImg, this.bb));
            }
        } else {
            ArrayList<RealRandomAccessible<FloatType>> singleWeight = new ArrayList<RealRandomAccessible<FloatType>>();
            for (int i = 0; i < inputData.size(); ++i) {
                singleWeight.add((RealRandomAccessible<FloatType>)((ArrayList)weights.get(i)).get(0));
            }
            for (ImagePortion portion : portions) {
                tasks.add(new ProcessParalellPortionWeight(portion, imgs, singleWeight, interpolatorFactory, this.getTransforms(inputData), fusedImg, this.bb));
            }
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting fusion process.");
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Failed to compute fusion: " + e);
            e.printStackTrace();
            return null;
        }
        taskExecutor.shutdown();
        return fusedImg;
    }
}

