/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration;

import fiji.util.node.Leaf;
import mpicbg.models.Point;
import net.imglib2.util.Util;

public class Detection
extends Point
implements Leaf<Detection> {
    private static final long serialVersionUID = -1512879446587557778L;
    protected final int id;
    protected double weight;
    protected boolean useW = false;
    protected double distance = -1.0;
    protected boolean isUsed = false;

    public Detection(int id, double[] location) {
        super(location);
        this.id = id;
    }

    public Detection(int id, double[] location, double weight) {
        super(location);
        this.id = id;
        this.weight = weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getId() {
        return this.id;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean equals(Detection otherDetection) {
        if (this.useW) {
            for (int d = 0; d < 3; ++d) {
                if (this.w[d] == otherDetection.w[d]) continue;
                return false;
            }
        } else {
            for (int d = 0; d < 3; ++d) {
                if (this.l[d] == otherDetection.l[d]) continue;
                return false;
            }
        }
        return true;
    }

    public void setW(double[] wn) {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = wn[i];
        }
    }

    public void resetW() {
        for (int i = 0; i < this.w.length; ++i) {
            this.w[i] = this.l[i];
        }
    }

    public double getDistance(Point point2) {
        double distance = 0.0;
        double[] a = this.getL();
        double[] b = point2.getW();
        for (int i = 0; i < this.getL().length; ++i) {
            double tmp = a[i] - b[i];
            distance += tmp * tmp;
        }
        return Math.sqrt(distance);
    }

    public boolean isLeaf() {
        return true;
    }

    public float distanceTo(Detection o) {
        double x = o.get(0) - this.get(0);
        double y = o.get(1) - this.get(1);
        double z = o.get(2) - this.get(2);
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public void setUseW(boolean useW) {
        this.useW = useW;
    }

    public boolean getUseW() {
        return this.useW;
    }

    public float get(int k) {
        if (this.useW) {
            return (float)this.w[k];
        }
        return (float)this.l[k];
    }

    public int getNumDimensions() {
        return 3;
    }

    public String toString() {
        String desc = "Detection " + this.getId() + " l" + Util.printCoordinates((double[])this.getL()) + "; w" + Util.printCoordinates((double[])this.getW());
        return desc;
    }

    public Detection[] createArray(int n) {
        return new Detection[n];
    }
}

