/*
 * Decompiled with CFR 0.152.
 */
package fiji.denoise;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class ROF_Denoise
implements PlugInFilter {
    protected ImagePlus image;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 8;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("ROF Denoise");
        gd.addNumericField("Theta", 25.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float theta = (float)gd.getNextNumber();
        ImageStack stack = this.image.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ROF_Denoise.denoise((FloatProcessor)stack.getProcessor(slice), theta);
        }
        this.image.updateAndDraw();
    }

    public static void denoise(FloatProcessor ip, float theta) {
        ROF_Denoise.denoise(ip, theta, 1.0f, 0.25f, 5);
    }

    public static void denoise(FloatProcessor ip, float theta, float g, float dt, int iterations) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        float[] pixels = (float[])ip.getPixels();
        float[] u = new float[w * h];
        float[] p = new float[w * h * 2];
        float[] d = new float[w * h * 2];
        float[] du = new float[w * h * 2];
        float[] div_p = new float[w * h];
        for (int iteration = 0; iteration < iterations; ++iteration) {
            int i;
            int j;
            for (int i2 = 0; i2 < w; ++i2) {
                for (int j2 = 1; j2 < h - 1; ++j2) {
                    div_p[i2 + w * j2] = p[i2 + w * j2] - p[i2 + w * (j2 - 1)];
                }
                div_p[i2] = p[i2];
                div_p[i2 + w * (h - 1)] = -p[i2 + w * (h - 1)];
            }
            for (j = 0; j < h; ++j) {
                for (i = 1; i < w - 1; ++i) {
                    int n = i + w * j;
                    div_p[n] = div_p[n] + (p[i + w * (j + h)] - p[i - 1 + w * (j + h)]);
                }
                div_p[w * j] = p[w * (j + h)];
                div_p[w - 1 + w * j] = -p[w - 1 + w * (j + h)];
            }
            for (j = 0; j < h; ++j) {
                for (i = 0; i < w; ++i) {
                    u[i + w * j] = pixels[i + w * j] - theta * div_p[i + w * j];
                }
            }
            for (j = 0; j < h; ++j) {
                for (i = 0; i < w; ++i) {
                    if (i < w - 1) {
                        du[i + w * (j + h)] = u[i + 1 + w * j] - u[i + w * j];
                    }
                    if (j >= h - 1) continue;
                    du[i + w * j] = u[i + w * (j + 1)] - u[i + w * j];
                }
            }
            for (j = 0; j < h; ++j) {
                for (i = 0; i < w; ++i) {
                    float du1 = du[i + w * j];
                    float du2 = du[i + w * (j + h)];
                    d[i + w * j] = 1.0f + dt / theta / g * Math.abs((float)Math.sqrt(du1 * du1 + du2 * du2));
                    d[i + w * (j + h)] = 1.0f + dt / theta / g * Math.abs((float)Math.sqrt(du1 * du1 + du2 * du2));
                    p[i + w * j] = (p[i + w * j] - dt / theta * du[i + w * j]) / d[i + w * j];
                    p[i + w * (j + h)] = (p[i + w * (j + h)] - dt / theta * du[i + w * (j + h)]) / d[i + w * (j + h)];
                }
            }
        }
        System.arraycopy(u, 0, pixels, 0, w * h);
    }
}

