/*
 * Decompiled with CFR 0.152.
 */
package fiji.drawing;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Linear_Gradient
implements PlugInFilter {
    ImagePlus image;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 16;
    }

    public void run(ImageProcessor ip) {
        Roi roi;
        block5: {
            block4: {
                roi = this.image.getRoi();
                if (roi == null) break block4;
                if (roi.getType() == 5) break block5;
            }
            IJ.error((String)"Need a linear selection");
            return;
        }
        Line line = (Line)roi;
        if (line.getLength() == 0.0) {
            IJ.error((String)"Line too short");
            return;
        }
        int from = Toolbar.getBackgroundColor().getRGB();
        int to = Toolbar.getForegroundColor().getRGB();
        Linear_Gradient.makeLinearGradient(ip, from, to, line);
        this.image.updateAndDraw();
    }

    public static void makeLinearGradient(ImageProcessor ip, int fromColor, int toColor, Line line) {
        double length = line.getLength();
        int w = ip.getWidth();
        int h = ip.getHeight();
        int[] pixels = (int[])ip.getPixels();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double scalar = ((double)i - line.x1d) * (line.x2d - line.x1d) + ((double)j - line.y1d) * (line.y2d - line.y1d);
                pixels[i + j * w] = Linear_Gradient.getColor(fromColor, toColor, scalar / length / length);
            }
        }
    }

    static int getByte(int from, int to, double factor, int shift) {
        from = from >> shift & 0xFF;
        to = to >> shift & 0xFF;
        int value = (int)Math.round((double)from + factor * (double)(to - from));
        return Math.min(255, Math.max(0, value)) << shift;
    }

    static int getColor(int from, int to, double factor) {
        return Linear_Gradient.getByte(from, to, factor, 0) | Linear_Gradient.getByte(from, to, factor, 8) | Linear_Gradient.getByte(from, to, factor, 16);
    }
}

