/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.localization;

import net.imglib2.Localizable;
import net.imglib2.algorithm.localization.Observation;
import net.imglib2.algorithm.localization.StartPointEstimator;

public class MLEllipticGaussianEstimator
implements StartPointEstimator {
    private final double[] sigmas;
    private final int nDims;
    private final long[] span;

    public MLEllipticGaussianEstimator(double[] typicalSigmas) {
        this.sigmas = typicalSigmas;
        this.nDims = this.sigmas.length;
        this.span = new long[this.nDims];
        for (int i = 0; i < this.nDims; ++i) {
            this.span[i] = (long)Math.ceil(2.0 * this.sigmas[i]) + 1L;
        }
    }

    public String toString() {
        return "Maximum-likelihood estimator for orthogonal elliptic gaussian peaks";
    }

    @Override
    public long[] getDomainSpan() {
        return this.span;
    }

    @Override
    public double[] initializeFit(Localizable point, Observation data) {
        int j;
        double[] start_param = new double[2 * this.nDims + 1];
        double[][] X = data.X;
        double[] I = data.I;
        double[] X_sum = new double[this.nDims];
        for (int j2 = 0; j2 < this.nDims; ++j2) {
            X_sum[j2] = 0.0;
            for (int i = 0; i < X.length; ++i) {
                int n = j2;
                X_sum[n] = X_sum[n] + X[i][j2] * I[i];
            }
        }
        double I_sum = 0.0;
        double max_I = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < X.length; ++i) {
            I_sum += I[i];
            if (!(I[i] > max_I)) continue;
            max_I = I[i];
        }
        start_param[this.nDims] = max_I;
        for (j = 0; j < this.nDims; ++j) {
            start_param[j] = X_sum[j] / I_sum;
        }
        for (j = 0; j < this.nDims; ++j) {
            double C = 0.0;
            for (int i = 0; i < X.length; ++i) {
                double dx = X[i][j] - start_param[j];
                C += I[i] * dx * dx;
            }
            start_param[this.nDims + j + 1] = 1.0 / (C /= I_sum) / 2.0;
        }
        return start_param;
    }
}

