/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.pde.ExplicitDiffusionScheme2D;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class NonNegativityDiffusionScheme2D<T extends RealType<T>>
extends ExplicitDiffusionScheme2D<T> {
    private static final float DEFAULT_DT = 0.15f;
    private float dt;

    public NonNegativityDiffusionScheme2D(Img<T> input, Img<FloatType> D, float dt) {
        super(input, (RandomAccessibleInterval<FloatType>)D);
        this.dt = dt;
    }

    public NonNegativityDiffusionScheme2D(Img<T> input, Img<FloatType> D) {
        this(input, D, 0.15f);
    }

    public NonNegativityDiffusionScheme2D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory, float dt) {
        super(input, D, imgFactory);
        this.dt = dt;
    }

    public NonNegativityDiffusionScheme2D(RandomAccessibleInterval<T> input, RandomAccessibleInterval<FloatType> D, ImgFactory<FloatType> imgFactory) {
        this(input, D, imgFactory, 0.15f);
    }

    @Override
    protected final float diffusionScheme(float[] U, float[][] D) {
        float Icp = (U[5] - U[0]) * (D[2][2] + D[2][0] - (Math.abs(D[1][5]) + Math.abs(D[1][0]))) / 2.0f;
        float Imc = (U[7] - U[0]) * (D[0][2] + D[0][0] - (Math.abs(D[1][7]) + Math.abs(D[1][0]))) / 2.0f;
        float Ipc = (U[3] - U[0]) * (D[0][1] + D[0][0] - (Math.abs(D[1][3]) + Math.abs(D[1][0]))) / 2.0f;
        float Icm = (U[1] - U[0]) * (D[2][1] + D[2][0] - (Math.abs(D[1][1]) + Math.abs(D[1][0]))) / 2.0f;
        float Imp = (U[6] - U[0]) * (Math.abs(D[1][6]) - D[1][6] + Math.abs(D[1][0]) - D[1][0]) / 4.0f;
        float Ipp = (U[4] - U[0]) * (Math.abs(D[1][4]) + D[1][4] + Math.abs(D[1][0]) + D[1][0]) / 4.0f;
        float Imm = (U[8] - U[0]) * (Math.abs(D[1][8]) + D[1][8] + Math.abs(D[1][0]) + D[1][0]) / 4.0f;
        float Ipm = (U[2] - U[0]) * (Math.abs(D[1][2]) - D[1][2] + Math.abs(D[1][0]) - D[1][0]) / 4.0f;
        return this.dt * (Icm + Ipm + Ipc + Ipp + Icp + Imp + Imc + Imm);
    }
}

