/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import com.formdev.flatlaf.util.UIScale;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ij.IJ;
import ij.ImageJ;
import ij.gui.ProgressBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.imglib2.util.Pair;
import org.janelia.saalfeldlab.n5.CachedGsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.CompressionAdapter;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.ui.DataSelection;
import org.janelia.saalfeldlab.n5.ui.ImprovedFormattedTextField;
import org.janelia.saalfeldlab.n5.ui.N5DatasetTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ui.N5MetadataTranslationPanel;
import org.janelia.saalfeldlab.n5.ui.N5SpatialKeySpecDialog;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.ui.NodePopupMenu;
import org.janelia.saalfeldlab.n5.ui.TranslationResultPanel;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.StorageFormat;
import org.janelia.saalfeldlab.n5.universe.metadata.N5GenericSingleScaleMetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.translation.TranslatedN5Reader;
import se.sawano.java.text.AlphanumericComparator;

public class DatasetSelectorDialog {
    private N5DatasetDiscoverer datasetDiscoverer;
    private Consumer<DataSelection> okCallback;
    private JFrame dialog;
    private ImprovedFormattedTextField containerPathText;
    private JCheckBox virtualBox;
    private JCheckBox cropBox;
    private JTree containerTree;
    private JButton browseBtn;
    private JButton detectBtn;
    private JLabel messageLabel;
    private JButton okBtn;
    private JButton cancelBtn;
    private DefaultTreeModel treeModel;
    private String lastBrowsePath;
    private Function<String, N5Reader> n5Fun;
    private final Function<String, String> pathFun;
    private N5Reader n5;
    private boolean virtualOption = false;
    private boolean cropOption = false;
    private Thread loaderThread;
    private ExecutorService loaderExecutor;
    private Future<N5TreeNode> parserFuture;
    private final String initialContainerPath;
    private Consumer<String> containerPathUpdateCallback;
    private Consumer<Void> cancelCallback;
    private Predicate<N5TreeNode> n5NodeFilter;
    private Predicate<N5Metadata> selectionFilter;
    private TreeCellRenderer treeRenderer;
    private final N5MetadataParser<?>[] groupParsers;
    private final N5MetadataParser<?>[] parsers;
    private N5SwingTreeNode rootNode;
    private N5SpatialKeySpecDialog spatialMetaSpec;
    private N5MetadataTranslationPanel translationPanel;
    private TranslationResultPanel translationResultPanel;
    private ExecutorService parseExec;
    private ProgressBar ijProgressBar;
    private boolean detectCalled;
    private final AlphanumericComparator comp = new AlphanumericComparator(Collator.getInstance());
    private static final int DEFAULT_OUTER_PAD = 8;
    private static final int DEFAULT_BUTTON_PAD = 3;
    private static final int DEFAULT_MID_PAD = 5;

    public DatasetSelectorDialog(Function<String, N5Reader> n5Fun, Function<String, String> pathFun, String initialContainerPath, N5MetadataParser<?>[] groupParsers, N5MetadataParser<?> ... parsers) {
        this.n5Fun = n5Fun;
        this.pathFun = pathFun;
        this.initialContainerPath = initialContainerPath;
        this.parsers = parsers;
        this.groupParsers = groupParsers;
        this.spatialMetaSpec = new N5SpatialKeySpecDialog();
        this.translationPanel = new N5MetadataTranslationPanel();
        this.translationResultPanel = new TranslationResultPanel();
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.ijProgressBar = ij.getProgressBar();
        }
        this.detectCalled = false;
    }

    public DatasetSelectorDialog(Function<String, N5Reader> n5Fun, Function<String, String> pathFun, N5MetadataParser<?>[] groupParsers, N5MetadataParser<?> ... parsers) {
        this(n5Fun, pathFun, "", groupParsers, parsers);
    }

    public DatasetSelectorDialog(Function<String, N5Reader> n5Fun, N5MetadataParser<?>[] groupParsers, N5MetadataParser<?> ... parsers) {
        this(n5Fun, (String x) -> "", groupParsers, parsers);
    }

    public DatasetSelectorDialog(N5Reader n5, N5MetadataParser<?>[] groupParsers, N5MetadataParser<?> ... parsers) {
        this.n5 = n5;
        this.pathFun = x -> "";
        this.initialContainerPath = "";
        this.parsers = parsers;
        this.groupParsers = groupParsers;
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            this.ijProgressBar = ij.getProgressBar();
        }
        this.detectCalled = false;
    }

    public N5MetadataTranslationPanel getTranslationPanel() {
        return this.translationPanel;
    }

    public TranslationResultPanel getTranslationResultPanel() {
        return this.translationResultPanel;
    }

    public void setLoaderExecutor(ExecutorService loaderExecutor) {
        this.loaderExecutor = loaderExecutor;
    }

    public void setTreeRenderer(TreeCellRenderer treeRenderer) {
        this.treeRenderer = treeRenderer;
    }

    public void setRecursiveFilterCallback(Predicate<N5TreeNode> n5NodeFilter) {
        this.n5NodeFilter = n5NodeFilter;
    }

    public void setSelectionFilter(Predicate<N5Metadata> selectionFilter) {
        this.selectionFilter = selectionFilter;
    }

    public void setCancelCallback(Consumer<Void> cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    public void setContainerPathUpdateCallback(Consumer<String> containerPathUpdateCallback) {
        this.containerPathUpdateCallback = containerPathUpdateCallback;
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public void setVirtualOption(boolean arg) {
        this.virtualOption = arg;
    }

    public void setCropOption(boolean arg) {
        this.cropOption = arg;
    }

    public boolean getCropOption() {
        return this.cropOption;
    }

    public boolean isCropSelected() {
        return this.cropOption && this.cropBox.isSelected();
    }

    public boolean isVirtual() {
        return this.virtualBox != null && this.virtualBox.isSelected();
    }

    public N5Reader getN5Reader() {
        return this.n5;
    }

    public String getN5RootPath() {
        return this.containerPathText.getText().trim();
    }

    public void setLoaderThread(Thread loaderThread) {
        this.loaderThread = loaderThread;
    }

    public void run(Consumer<DataSelection> okCallback) {
        this.okCallback = okCallback;
        this.dialog = this.buildDialog();
        if (this.n5 == null) {
            this.browseBtn.addActionListener(e -> this.openContainer(this.n5Fun, this::openBrowseDialog));
            this.detectBtn.addActionListener(e -> this.openContainer(this.n5Fun, () -> this.getN5RootPath(), this.pathFun));
        }
        this.okBtn.addActionListener(e -> this.ok());
        this.okBtn.registerKeyboardAction(a -> this.ok(), "n5_open_button", KeyStroke.getKeyStroke(10, 0, true), 2);
        this.cancelBtn.addActionListener(e -> this.cancel());
        this.dialog.setVisible(true);
    }

    private JFrame buildDialog() {
        int OUTER_PAD = 8;
        int BUTTON_PAD = 3;
        int MID_PAD = 5;
        int frameSizeX = UIScale.scale((int)600);
        int frameSizeY = UIScale.scale((int)400);
        this.dialog = new JFrame("Open N5");
        this.dialog.setPreferredSize(new Dimension(frameSizeX, frameSizeY));
        this.dialog.setMinimumSize(this.dialog.getPreferredSize());
        Container pane = this.dialog.getContentPane();
        JTabbedPane tabs = new JTabbedPane();
        pane.add(tabs);
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridBagLayout());
        tabs.addTab("Main", panel);
        tabs.addTab("Spatial Metadata", this.spatialMetaSpec.buildPanel());
        tabs.addTab("Metadata Translation", this.translationPanel.buildPanel());
        tabs.addTab("Translation Result", this.translationResultPanel.buildPanel());
        this.containerPathText = new ImprovedFormattedTextField(new UriValidator(), (Object)this.initialContainerPath);
        this.containerPathText.setPreferredSize(new Dimension(frameSizeX / 3, this.containerPathText.getPreferredSize().height));
        this.containerPathText.addActionListener(e -> this.openContainer(this.n5Fun, () -> this.getN5RootPath(), this.pathFun));
        GridBagConstraints ctxt = new GridBagConstraints();
        ctxt.gridx = 0;
        ctxt.gridy = 0;
        ctxt.gridwidth = 3;
        ctxt.gridheight = 1;
        ctxt.weightx = 1.0;
        ctxt.weighty = 0.0;
        ctxt.fill = 2;
        ctxt.insets = new Insets(8, 8, 5, 3);
        panel.add((Component)this.containerPathText, ctxt);
        this.browseBtn = new JButton("Browse");
        GridBagConstraints cbrowse = new GridBagConstraints();
        cbrowse.gridx = 3;
        cbrowse.gridy = 0;
        cbrowse.gridwidth = 1;
        cbrowse.gridheight = 1;
        cbrowse.weightx = 0.0;
        cbrowse.weighty = 0.0;
        cbrowse.fill = 2;
        cbrowse.insets = new Insets(8, 3, 5, 3);
        panel.add((Component)this.browseBtn, cbrowse);
        this.detectBtn = new JButton("Detect datasets");
        GridBagConstraints cdetect = new GridBagConstraints();
        cdetect.gridx = 4;
        cdetect.gridy = 0;
        cdetect.gridwidth = 2;
        cdetect.gridheight = 1;
        cdetect.weightx = 0.0;
        cdetect.weighty = 0.0;
        cdetect.fill = 2;
        cdetect.insets = new Insets(8, 3, 5, 8);
        panel.add((Component)this.detectBtn, cdetect);
        GridBagConstraints ctree = new GridBagConstraints();
        ctree.gridx = 0;
        ctree.gridy = 1;
        ctree.gridwidth = 6;
        ctree.gridheight = 3;
        ctree.weightx = 1.0;
        ctree.weighty = 1.0;
        ctree.ipadx = 0;
        ctree.ipady = 0;
        ctree.insets = new Insets(0, 8, 0, 8);
        ctree.fill = 1;
        this.treeModel = new DefaultTreeModel(null);
        this.containerTree = new JTree(this.treeModel);
        this.containerTree.setMinimumSize(new Dimension(550, 230));
        this.containerTree.getSelectionModel().setSelectionMode(4);
        N5IjTreeSelectionListener treeSelectionListener = new N5IjTreeSelectionListener(this.containerTree.getSelectionModel());
        treeSelectionListener.setSelectionFilter(this.selectionFilter);
        this.containerTree.addTreeSelectionListener(treeSelectionListener);
        if (this.treeRenderer != null) {
            this.containerTree.setCellRenderer(this.treeRenderer);
        }
        JScrollPane treeScroller = new JScrollPane(this.containerTree);
        treeScroller.setViewportView(this.containerTree);
        treeScroller.setVerticalScrollBarPolicy(20);
        panel.add((Component)treeScroller, ctree);
        GridBagConstraints cbot = new GridBagConstraints();
        cbot.gridx = 0;
        cbot.gridy = 4;
        cbot.gridwidth = 1;
        cbot.gridheight = 1;
        cbot.weightx = 0.0;
        cbot.weighty = 0.0;
        cbot.insets = new Insets(8, 8, 8, 8);
        cbot.anchor = 10;
        if (this.virtualOption) {
            JPanel virtPanel = new JPanel();
            this.virtualBox = new JCheckBox();
            JLabel virtLabel = new JLabel("Open as virtual");
            virtPanel.add(this.virtualBox);
            virtPanel.add(virtLabel);
            panel.add((Component)virtPanel, cbot);
        }
        if (this.cropOption) {
            JPanel cropPanel = new JPanel();
            this.cropBox = new JCheckBox();
            JLabel cropLabel = new JLabel("Crop");
            cbot.gridx = 1;
            cbot.anchor = 17;
            cropPanel.add(this.cropBox);
            cropPanel.add(cropLabel);
            panel.add((Component)cropPanel, cbot);
        }
        this.messageLabel = new JLabel("");
        this.messageLabel.setVisible(false);
        cbot.gridx = 2;
        cbot.anchor = 10;
        panel.add((Component)this.messageLabel, cbot);
        this.okBtn = new JButton("OK");
        cbot.gridx = 4;
        cbot.ipadx = 20;
        cbot.anchor = 13;
        cbot.fill = 2;
        cbot.insets = new Insets(5, 8, 8, 3);
        panel.add((Component)this.okBtn, cbot);
        this.cancelBtn = new JButton("Cancel");
        cbot.gridx = 5;
        cbot.ipadx = 0;
        cbot.anchor = 13;
        cbot.fill = 2;
        cbot.insets = new Insets(5, 3, 8, 8);
        panel.add((Component)this.cancelBtn, cbot);
        this.containerTree.addMouseListener(new NodePopupMenu(this).getPopupListener());
        this.containerTree.addTreeSelectionListener(tsl -> {
            if (this.containerTree.getSelectionCount() == 0) {
                this.okBtn.setEnabled(false);
            } else {
                int selectedRow = this.containerTree.getSelectionRows()[0];
                N5SwingTreeNode n = (N5SwingTreeNode)this.containerTree.getPathForRow(selectedRow).getLastPathComponent();
                this.okBtn.setEnabled(this.selectionFilter == null ? true : this.selectionFilter.test(n.getMetadata()));
            }
        });
        this.dialog.pack();
        return this.dialog;
    }

    public JTree getJTree() {
        return this.containerTree;
    }

    private String openBrowseDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        if (this.lastBrowsePath != null && !this.lastBrowsePath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.lastBrowsePath));
        } else if (this.initialContainerPath != null && !this.initialContainerPath.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(this.initialContainerPath));
        } else if (IJ.getInstance() != null) {
            File f = null;
            String currDir = IJ.getDirectory((String)"current");
            String homeDir = IJ.getDirectory((String)"home");
            if (currDir != null) {
                f = new File(currDir);
            } else if (homeDir != null) {
                f = new File(homeDir);
            }
            fileChooser.setCurrentDirectory(f);
        }
        int ret = fileChooser.showOpenDialog(this.dialog);
        if (ret != 0) {
            return null;
        }
        String path = fileChooser.getSelectedFile().getAbsolutePath();
        this.containerPathText.setText(path);
        this.lastBrowsePath = path;
        this.containerPathUpdateCallback.accept(path);
        return path;
    }

    private N5DatasetDiscoverer makeDiscoverer() {
        ArrayList<Object> parserList = new ArrayList<Object>();
        Optional<N5GenericSingleScaleMetadataParser> parserOptional = this.spatialMetaSpec.getParserOptional();
        if (parserOptional.isPresent()) {
            parserList.add(parserOptional.get());
            parserList.addAll(Arrays.asList(this.parsers));
        } else {
            parserList.addAll(Arrays.asList(this.parsers));
        }
        List<N5MetadataParser<?>> groupParserList = Arrays.asList(this.groupParsers);
        this.datasetDiscoverer = new N5DatasetDiscoverer(this.n5, this.loaderExecutor, this.n5NodeFilter, parserList, groupParserList);
        return this.datasetDiscoverer;
    }

    private N5Reader makeN5(String n5Path) {
        Gson gson;
        this.n5 = this.n5Fun.apply(n5Path);
        if (this.n5 == null) {
            this.messageLabel.setVisible(false);
            this.dialog.repaint();
            return null;
        }
        ArrayList parserList = new ArrayList();
        if (this.n5 instanceof CachedGsonKeyValueN5Reader) {
            gson = ((CachedGsonKeyValueN5Reader)this.n5).getGson();
        } else {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataType.JsonAdapter());
            gsonBuilder.registerTypeHierarchyAdapter(Compression.class, (Object)CompressionAdapter.getJsonAdapter());
            gsonBuilder.disableHtmlEscaping();
            gson = gsonBuilder.create();
        }
        boolean isTranslated = false;
        Optional<TranslatedN5Reader> translatedN5 = this.translationPanel.getTranslatedN5Optional(this.n5, gson);
        if (translatedN5.isPresent()) {
            this.n5 = (N5Reader)translatedN5.get();
            isTranslated = true;
        }
        return this.n5;
    }

    private void openContainer(Function<String, N5Reader> n5Fun, Supplier<String> opener) {
        this.openContainer(n5Fun, opener, this.pathFun);
    }

    private void openContainer(Function<String, N5Reader> n5Fun, Supplier<String> opener, Function<String, String> pathToRoot) {
        Gson gson;
        if (this.ijProgressBar != null) {
            this.ijProgressBar.show(0.2);
        }
        SwingUtilities.invokeLater(() -> {
            this.messageLabel.setText("Building reader...");
            this.messageLabel.setVisible(true);
            this.messageLabel.repaint();
        });
        this.containerPathText.validateAndUpdate();
        String n5Path = opener.get();
        this.containerPathUpdateCallback.accept(n5Path);
        if (n5Path == null) {
            this.messageLabel.setVisible(false);
            this.dialog.repaint();
            return;
        }
        if (this.loaderExecutor == null) {
            this.loaderExecutor = Executors.newCachedThreadPool();
        }
        this.n5 = n5Fun.apply(n5Path);
        String rootPath = pathToRoot.apply(n5Path).replaceFirst("^/", "");
        if (this.n5 == null) {
            this.messageLabel.setVisible(false);
            this.dialog.repaint();
            return;
        }
        ArrayList parserList = new ArrayList();
        if (this.n5 instanceof CachedGsonKeyValueN5Reader) {
            gson = ((CachedGsonKeyValueN5Reader)this.n5).getGson();
        } else {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataType.JsonAdapter());
            gsonBuilder.registerTypeHierarchyAdapter(Compression.class, (Object)CompressionAdapter.getJsonAdapter());
            gsonBuilder.disableHtmlEscaping();
            gson = gsonBuilder.create();
        }
        boolean isTranslated = false;
        Optional<TranslatedN5Reader> translatedN5 = this.translationPanel.getTranslatedN5Optional(this.n5, gson);
        if (translatedN5.isPresent()) {
            this.n5 = (N5Reader)translatedN5.get();
            isTranslated = true;
        }
        this.datasetDiscoverer = this.makeDiscoverer();
        String[] pathParts = this.n5.getURI().toString().split(this.n5.getGroupSeparator());
        String suffix = rootPath == null || rootPath.isEmpty() ? "" : this.n5.getGroupSeparator() + rootPath;
        String treeRootName = pathParts[pathParts.length - 1] + suffix;
        if (this.treeRenderer != null && this.treeRenderer instanceof N5DatasetTreeCellRenderer) {
            ((N5DatasetTreeCellRenderer)this.treeRenderer).setRootName(treeRootName);
        }
        N5TreeNode tmpRootNode = new N5TreeNode(rootPath);
        this.rootNode = new N5SwingTreeNode(rootPath, this.treeModel);
        this.treeModel.setRoot(this.rootNode);
        this.containerTree.setEnabled(true);
        this.containerTree.repaint();
        if (this.ijProgressBar != null) {
            this.ijProgressBar.show(0.3);
        }
        Consumer<N5TreeNode> callback = x -> SwingUtilities.invokeLater(() -> {
            if (x.getMetadata() != null) {
                N5SwingTreeNode node = (N5SwingTreeNode)this.rootNode.getDescendants(y -> DatasetSelectorDialog.pathsEqual(y.getPath(), x.getPath())).findFirst().orElseGet(() -> {
                    if (this.rootNode.getPath().equals(x.getPath())) {
                        return null;
                    }
                    return this.rootNode.addPath(x.getPath());
                });
                if (node != null) {
                    node.setMetadata(x.getMetadata());
                    N5SwingTreeNode parent = (N5SwingTreeNode)node.getParent();
                    this.sortRecursive(parent);
                    this.treeModel.nodeChanged(node);
                }
            } else {
                N5SwingTreeNode node;
                Optional desc = this.rootNode.getDescendant(x.getNodeName());
                if (desc.isPresent() && (node = (N5SwingTreeNode)desc.get()).getParent() != null && node.getChildCount() == 0) {
                    this.treeModel.removeNodeFromParent(node);
                }
            }
        });
        this.parseExec = Executors.newSingleThreadExecutor();
        this.parseExec.submit(() -> {
            try {
                if (this.ijProgressBar != null) {
                    this.ijProgressBar.show(0.3);
                }
                SwingUtilities.invokeLater(() -> {
                    this.messageLabel.setText("Parsing...");
                    this.messageLabel.repaint();
                });
                this.datasetDiscoverer.discoverShallow(tmpRootNode, callback);
                callback.accept(tmpRootNode);
                this.sortRecursive(this.rootNode);
                if (this.ijProgressBar != null) {
                    this.ijProgressBar.show(0.4);
                }
                SwingUtilities.invokeLater(() -> {
                    this.messageLabel.setText("Listing...");
                    this.messageLabel.repaint();
                });
                try {
                    String[] datasetPaths = this.n5.deepList(rootPath, this.loaderExecutor);
                    N5SwingTreeNode.fromFlatList((N5TreeNode)tmpRootNode, (String[])datasetPaths, (String)"/");
                    for (String p : datasetPaths) {
                        this.rootNode.addPath(rootPath + "/" + p);
                    }
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                this.sortRecursive(this.rootNode);
                this.containerTree.expandRow(0);
                if (this.ijProgressBar != null) {
                    this.ijProgressBar.show(0.6);
                }
                SwingUtilities.invokeLater(() -> {
                    this.messageLabel.setText("Parsing deep...");
                    this.messageLabel.repaint();
                });
                this.datasetDiscoverer.parseMetadataRecursive(tmpRootNode, callback, true);
                if (this.ijProgressBar != null) {
                    this.ijProgressBar.show(0.9);
                }
                SwingUtilities.invokeLater(() -> {
                    this.messageLabel.setText("Done");
                    this.messageLabel.repaint();
                });
                if (this.ijProgressBar != null) {
                    this.ijProgressBar.show(1.1);
                }
                Thread.sleep(1000L);
                SwingUtilities.invokeLater(() -> {
                    this.messageLabel.setText("");
                    this.messageLabel.setVisible(false);
                    this.messageLabel.repaint();
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        if (isTranslated) {
            TranslatedN5Reader xlatedN5 = (TranslatedN5Reader)this.n5;
            this.translationResultPanel.set(xlatedN5.getGson(), xlatedN5.getTranslation().getOrig(), xlatedN5.getTranslation().getTranslated());
        }
        this.detectCalled = true;
    }

    public boolean waitUntilDiscoveryIsFinished(long maxWaitingMillis) {
        long waitingPeriodMillis = 100L;
        while (this.messageLabel.isVisible() && maxWaitingMillis > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            maxWaitingMillis -= 100L;
        }
        return !this.messageLabel.isVisible();
    }

    public void ok() {
        if (this.parseExec != null) {
            this.parseExec.shutdownNow();
        }
        this.containerPathText.validateAndUpdate();
        ArrayList<N5Metadata> selectedMetadata = new ArrayList<N5Metadata>();
        String n5Path = this.getN5RootPath();
        if (!this.detectCalled && !n5Path.isEmpty()) {
            this.containerPathUpdateCallback.accept(this.getN5RootPath());
            if (this.n5 == null) {
                this.n5 = this.makeN5(n5Path);
            }
            if (this.datasetDiscoverer == null) {
                this.datasetDiscoverer = this.makeDiscoverer();
            }
            String dataset = this.pathFun.apply(n5Path);
            try {
                N5TreeNode root = this.datasetDiscoverer.discoverAndParseRecursive("");
                Predicate<N5Metadata> filter = this.selectionFilter != null ? this.selectionFilter : x -> x != null;
                root.getDescendant(dataset).filter(x -> x.getMetadata() != null && filter.test(x.getMetadata())).ifPresent(x -> selectedMetadata.add(x.getMetadata()));
            }
            catch (Exception e) {
                throw new N5Exception("Failure to parse or find data at " + dataset, (Throwable)e);
            }
            if (selectedMetadata.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Could not find a dataset / metadata at the provided path.");
                return;
            }
        } else {
            if (this.containerTree.getSelectionPath() == null) {
                JOptionPane.showMessageDialog(null, "No dataset selected.");
                return;
            }
            for (TreePath path : this.containerTree.getSelectionPaths()) {
                selectedMetadata.add(((N5SwingTreeNode)path.getLastPathComponent()).getMetadata());
            }
        }
        this.okCallback.accept(new DataSelection(this.n5, selectedMetadata));
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void cancel() {
        if (this.parseExec != null) {
            this.parseExec.shutdownNow();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        }
        if (this.parserFuture != null) {
            this.parserFuture.cancel(true);
        }
        if (this.cancelCallback != null) {
            this.cancelCallback.accept(null);
        }
    }

    public void detectDatasets() {
        this.openContainer(this.n5Fun, () -> this.getN5RootPath(), this.pathFun);
    }

    private void sortRecursive(N5SwingTreeNode node) {
        if (node != null) {
            List children = node.childrenList();
            if (!children.isEmpty()) {
                children.sort(Comparator.comparing(N5TreeNode::toString, this.comp));
            }
            this.treeModel.nodeStructureChanged(node);
            for (N5TreeNode child : children) {
                this.sortRecursive((N5SwingTreeNode)child);
            }
        }
    }

    private static String normalDatasetName(String fullPath, String groupSeparator) {
        return fullPath.replaceAll("(^" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
    }

    private static boolean pathsEqual(String a, String b) {
        return DatasetSelectorDialog.normalDatasetName(a, "/").equals(DatasetSelectorDialog.normalDatasetName(b, "/"));
    }

    public static class UriValidator
    extends JFormattedTextField.AbstractFormatter {
        private static final long serialVersionUID = 6765664180035018335L;

        @Override
        public Object stringToValue(String inputArg) throws ParseException {
            if (inputArg == null || inputArg.isEmpty()) {
                return null;
            }
            String fmt = null;
            String input = inputArg;
            Pair fmtAndUri = StorageFormat.getStorageFromNestedScheme((String)input);
            StorageFormat format = (StorageFormat)fmtAndUri.getA();
            if (format != null) {
                fmt = format.toString().toLowerCase() + "://";
            }
            input = (String)fmtAndUri.getB();
            N5URI n5uri = null;
            try {
                URI uri = new URI(input.trim());
                if (uri.isAbsolute()) {
                    return this.addTypeScheme(fmt, uri.normalize());
                }
                n5uri = new N5URI(uri);
            }
            catch (Throwable uri) {
                // empty catch block
            }
            try {
                if (n5uri != null) {
                    N5URI pathOnly = new N5URI(Paths.get(n5uri.getContainerPath(), new String[0]).normalize().toUri());
                    URI uri = n5uri.getURI();
                    N5URI queryFragmentOnly = N5URI.from((String)"", (String)(uri.getQuery() == null ? null : n5uri.getGroupPath()), (String)(uri.getFragment() == null ? null : n5uri.getAttributePath()));
                    return this.addTypeScheme(fmt, pathOnly.resolve(queryFragmentOnly).getURI().normalize());
                }
                return this.addTypeScheme(fmt, Paths.get(input.trim(), new String[0]).normalize().toUri());
            }
            catch (Throwable throwable) {
                throw new ParseException("input " + input + " not a valid URI", 0);
            }
        }

        private URI addTypeScheme(String typeScheme, URI uri) {
            if (typeScheme == null) {
                return uri;
            }
            return URI.create(typeScheme + uri.toString());
        }

        @Override
        public String valueToString(Object arg) throws ParseException {
            if (arg instanceof URI) {
                return ((URI)arg).toString();
            }
            throw new ParseException("input " + arg + " not a valid URI", 0);
        }
    }

    public static class N5IjTreeSelectionListener
    implements TreeSelectionListener {
        private final TreeSelectionModel selectionModel;
        private Predicate<N5Metadata> selectionFilter;

        public N5IjTreeSelectionListener(TreeSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public void setSelectionFilter(Predicate<N5Metadata> selectionFilter) {
            this.selectionFilter = selectionFilter;
        }

        @Override
        public void valueChanged(TreeSelectionEvent sel) {
            int i = 0;
            for (TreePath path : sel.getPaths()) {
                if (!sel.isAddedPath(i)) continue;
                Object last = path.getLastPathComponent();
                if (last instanceof N5SwingTreeNode) {
                    N5SwingTreeNode node = (N5SwingTreeNode)last;
                    if (node.getMetadata() == null) {
                        this.selectionModel.removeSelectionPath(path);
                    } else if (this.selectionFilter != null && !this.selectionFilter.test(node.getMetadata())) {
                        this.selectionModel.removeSelectionPath(path);
                    }
                }
                ++i;
            }
        }
    }
}

