/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.ui.DatasetSelectorDialog;
import org.janelia.saalfeldlab.n5.ui.N5TreeNodeWrapper;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;

public class NodePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1431304870893536697L;
    protected final DatasetSelectorDialog n5SelectionDialog;
    protected final JMenuItem showMetadata;
    protected final PopupListener popupListener;
    private Point clickPt;
    private JTree tree;
    private JFrame metadataFrame;
    private JTextArea metadataTextArea;
    private final Gson gson;
    private final ObjectMapper objMapper;
    private final DefaultPrettyPrinter prettyPrinter;

    public NodePopupMenu(DatasetSelectorDialog n5SelectionDialog) {
        this.n5SelectionDialog = n5SelectionDialog;
        this.tree = n5SelectionDialog.getJTree();
        this.popupListener = new PopupListener();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(AffineTransform3D.class, (Object)new AffineTransform3DGsonAdapter());
        this.gson = gsonBuilder.create();
        this.objMapper = new ObjectMapper();
        this.objMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.prettyPrinter = new DefaultPrettyPrinter();
        DefaultIndenter i = new DefaultIndenter("  ", "\n");
        this.prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)i);
        this.prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)i);
        this.objMapper.setDefaultPrettyPrinter((PrettyPrinter)this.prettyPrinter);
        this.showMetadata = new JMenuItem("Show Metadata");
        this.showMetadata.addActionListener(e -> this.showDialog());
        this.add(this.showMetadata);
        this.buildMetadataFrame();
    }

    public PopupListener getPopupListener() {
        return this.popupListener;
    }

    public void setupListeners() {
        this.n5SelectionDialog.getJTree().addMouseListener(this.popupListener);
    }

    public void showDialog() {
        if (this.popupListener.selPath != null) {
            Object o = this.popupListener.selPath.getLastPathComponent();
            if (o instanceof N5TreeNode) {
                N5TreeNode node = (N5TreeNode)o;
                this.setText(node);
            } else if (o instanceof N5TreeNodeWrapper) {
                N5TreeNodeWrapper wrapper = (N5TreeNodeWrapper)o;
                this.setText(wrapper.getNode());
            } else {
                System.out.println(o.getClass());
            }
        }
        this.metadataFrame.setVisible(true);
    }

    public void setText(N5TreeNode node) {
        String jsonTxt;
        N5Metadata meta = node.getMetadata();
        String jsonPretty = jsonTxt = this.gson.toJson((Object)node.getMetadata());
        try {
            HashMap tmpObj = (HashMap)this.objMapper.readValue(jsonTxt, HashMap.class);
            jsonPretty = this.objMapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)tmpObj);
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        this.metadataTextArea.setText(jsonPretty);
    }

    public JFrame buildMetadataFrame() {
        this.metadataFrame = new JFrame("Metadata");
        this.metadataFrame.setPreferredSize(new Dimension(400, 400));
        this.metadataFrame.setMinimumSize(new Dimension(200, 200));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("Metadata"));
        this.metadataTextArea = new JTextArea();
        this.metadataTextArea.setEditable(false);
        JScrollPane textView = new JScrollPane(this.metadataTextArea);
        panel.add((Component)textView, "Center");
        this.metadataFrame.add(panel);
        return this.metadataFrame;
    }

    public static class AffineTransform3DGsonAdapter
    implements JsonDeserializer<AffineTransform3D>,
    JsonSerializer<AffineTransform3D> {
        public JsonElement serialize(AffineTransform3D src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("matrix", context.serialize((Object)src.getRowPackedCopy()));
            return obj;
        }

        public AffineTransform3D deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            AffineTransform3D affine = new AffineTransform3D();
            double[] mtx = (double[])context.deserialize(json.getAsJsonObject().get("a"), double[].class);
            affine.set(mtx);
            return affine;
        }
    }

    public class PopupListener
    extends MouseAdapter {
        TreePath selPath;

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                NodePopupMenu.this.clickPt = e.getPoint();
                Component c = e.getComponent();
                this.selPath = NodePopupMenu.this.tree.getPathForLocation(e.getX(), e.getY());
                NodePopupMenu.this.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

